/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.hander;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import kd.ai.gai.core.agent.tool.hander.BaseHandler;
import kd.ai.gai.core.agent.tool.hander.IOpenAPIHandler;
import kd.ai.gai.core.agent.tool.model.APIParam;
import kd.ai.gai.core.agent.tool.model.OAuthCredentialsConfig;
import kd.ai.gai.core.agent.tool.model.OAuthResponse;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang3.StringUtils;

public class OAuthHandler
extends BaseHandler
implements IOpenAPIHandler {
    private static final Log logger = LogFactory.getLog(OAuthHandler.class);

    @Override
    public BaseResult call(APIParam params) {
        logger.info("\u5904\u7406\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177OAuth\u9274\u6743\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)params));
        JSONObject toolParams = params.getToolParams();
        OperationParam operationParam = params.getOperationParam();
        HashMap<String, String> headerParamsMap = new HashMap<String, String>();
        HashMap<String, Object> queryParamsMap = new HashMap<String, Object>();
        HashMap<String, Object> pathParamsMap = new HashMap<String, Object>();
        this.preHandler(toolParams, operationParam, headerParamsMap, queryParamsMap, pathParamsMap);
        OAuthCredentialsConfig config = (OAuthCredentialsConfig)params.getConfig();
        String tokenUrl = config.getTokenUrl();
        String clientId = config.getClientId();
        String clientSecret = config.getClientSecret();
        String scope = config.getScope();
        OAuthResponse response = null;
        try {
            response = this.getAccessToken(tokenUrl, clientId, clientSecret, scope);
            if (response != null) {
                logger.info("\u901a\u8fc7OAuth\u5ba2\u6237\u7aef\u6a21\u5f0f\u83b7\u53d6accessToken\u54cd\u5e94:{}", (Object)JSONObject.toJSONString((Object)response));
                String accessToken = response.getAccess_token();
                if (!StringUtils.isEmpty((CharSequence)accessToken)) {
                    queryParamsMap.put("access_token", accessToken);
                    String server = operationParam.getServer();
                    String path = operationParam.getPath();
                    String method = operationParam.getMethod();
                    JSONObject data = this.buildRequestData(toolParams);
                    return this.sendCall(server, path, method, headerParamsMap, queryParamsMap, pathParamsMap, data);
                }
                return BaseResult.fail("OAuth\u9274\u6743\u5ba2\u6237\u7aef\u6a21\u5f0f\u83b7\u53d6accessToken\u4e3a\u7a7a");
            }
            return BaseResult.fail("OAuth\u9274\u6743\u5ba2\u6237\u7aef\u6a21\u5f0f\u83b7\u53d6accessToken\u5931\u8d25,\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
        }
        catch (KDBizException e) {
            logger.error(e.getMessage());
            return BaseResult.fail(e.getMessage());
        }
    }

    private OAuthResponse getAccessToken(String tokenUrl, String clientId, String clientSecret, String scope) throws KDBizException {
        OAuthResponse response = null;
        try {
            HashMap<String, String> queryParamsMap = new HashMap<String, String>();
            queryParamsMap.put("grant_type", "client_credentials");
            queryParamsMap.put("client_id", clientId);
            queryParamsMap.put("client_secret", clientSecret);
            queryParamsMap.put("scope", scope);
            logger.info("oauth tokenUrl :{},clientId:{},clientSecret:{},scope:{}", new Object[]{tokenUrl, clientId, clientSecret, scope});
            logger.info("oauth authorization request access token :{}", (Object)JSONObject.toJSONString(queryParamsMap));
            String result = HttpClientUtils.post((String)tokenUrl, new HashMap(), queryParamsMap);
            logger.info("oauth \u83b7\u53d6accessToken\u8fd4\u56de\uff1a{}", (Object)result);
            if (!StringUtils.isEmpty((CharSequence)result)) {
                JSONObject res = JSONObject.parseObject((String)result);
                if (res.containsKey((Object)"error")) {
                    String error = res.getString("error");
                    String errorDescription = res.getString("error_description");
                    logger.info(String.format("request access token response: (%s:%s)", error, errorDescription));
                    throw new KDBizException(String.format("%s:%s", error, errorDescription));
                }
                response = (OAuthResponse)JSONObject.parseObject((String)result, OAuthResponse.class);
            }
        }
        catch (Exception e) {
            logger.error("\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177OAuth\u9274\u6743\u83b7\u53d6AccessToken\u51fa\u9519,error:{}", (Object)e.getMessage());
            throw new KDBizException("\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177OAuth\u9274\u6743\u83b7\u53d6AccessToken\u51fa\u9519,error:" + e.getMessage());
        }
        return response;
    }
}

