/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.hander;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.agent.tool.hander.ApiKeyHandler;
import kd.ai.gai.core.agent.tool.hander.CosmicAccessTokenAuthHandler;
import kd.ai.gai.core.agent.tool.hander.IOpenAPIHandler;
import kd.ai.gai.core.agent.tool.hander.NoAuthHandler;
import kd.ai.gai.core.agent.tool.hander.OAuthHandler;
import kd.ai.gai.core.agent.tool.model.APIParam;
import kd.ai.gai.core.agent.tool.model.AuthType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OpenAPIAuthHandlerFactory {
    private static final Log logger = LogFactory.getLog(OpenAPIAuthHandlerFactory.class);
    private static final Map<AuthType, Class<? extends IOpenAPIHandler>> openAPIHandlerTypeMap = new HashMap<AuthType, Class<? extends IOpenAPIHandler>>();

    public static <T extends IOpenAPIHandler> T getHandler(AuthType authType) {
        Class<? extends IOpenAPIHandler> handlerType = openAPIHandlerTypeMap.get((Object)authType);
        if (handlerType == null) {
            throw new KDBizException(new ErrorCode("gai.tool.000001", String.format("\u5b9e\u4f8b\u5316\u5de5\u5177\u9274\u6743\u7c7b\u578bhandler\u5931\u8d25\uff1a%s gai.tool.000001", authType.getType())), new Object[0]);
        }
        try {
            return (T)handlerType.newInstance();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(new ErrorCode("gai.tool.000001", String.format("\u5b9e\u4f8b\u5316\u5de5\u5177\u9274\u6743\u7c7b\u578bhandler\u5931\u8d25\uff1a%s gai.tool.000001", authType.getType())), new Object[0]);
        }
    }

    public static Object runHandler(AuthType authType, APIParam params) {
        Object handler = OpenAPIAuthHandlerFactory.getHandler(authType);
        return handler.call(params);
    }

    static {
        openAPIHandlerTypeMap.put(AuthType.OAUTH, OAuthHandler.class);
        openAPIHandlerTypeMap.put(AuthType.SERVICE, ApiKeyHandler.class);
        openAPIHandlerTypeMap.put(AuthType.NO_AUTH, NoAuthHandler.class);
        openAPIHandlerTypeMap.put(AuthType.COSMIC_ACCESS_TOKEN, CosmicAccessTokenAuthHandler.class);
    }
}

