/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpXmlUtils {
    private static PoolingHttpClientConnectionManager cm;
    private static final Log logger;
    private static int default_connectionTimeout;
    private static int default_readTimeout;
    private static String SCHEME_HTTPS;

    public static CloseableHttpClient getHttpClient(PoolingHttpClientConnectionManager cm) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(3000).setSocketTimeout(10000).build();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)cm).disableAutomaticRetries().build();
        return httpClient;
    }

    public static HttpClient wrapperHttpClient(int connectionTimeout, int readTimeout) {
        return HttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout);
    }

    public static String postXmlRequest(String url, Map<String, String> header, String xml) throws IOException {
        return HttpXmlUtils.postXmlRequest(url, header, xml, default_connectionTimeout, default_readTimeout);
    }

    public static String putXmlRequest(String url, Map<String, String> header, String xml) throws IOException {
        return HttpXmlUtils.putXmlRequest(url, header, xml, default_connectionTimeout, default_readTimeout);
    }

    public static String put(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpXmlUtils.put(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String put(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        CloseableHttpClient client = null;
        HttpPut put = new HttpPut(url);
        URI uri = put.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HttpXmlUtils.wrapperHttpClient(connectionTimeout, readTimeout);
            if (client == null) {
                return data;
            }
        } else {
            client = HttpXmlUtils.getHttpClient(cm);
        }
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(readTimeout).build();
        put.setConfig(config);
        HttpResponse response = null;
        try {
            HttpEntity resEntity;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    String string = entry.getKey();
                    put.setHeader(string, entry.getValue());
                }
            }
            if (body != null && body.size() != 0) {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    String key = entry.getKey();
                    String value = (String)entry.getValue();
                    params.add(new BasicNameValuePair(key, value));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
                put.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if ((response = client.execute((HttpUriRequest)put)).getStatusLine().getStatusCode() == 200) {
                resEntity = response.getEntity();
                Header header2 = resEntity.getContentEncoding();
                if (header2 == null || !"gzip".equalsIgnoreCase(header2.getValue()) && !"x-gzip".equalsIgnoreCase(header2.getValue())) {
                    data = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                } else {
                    GzipDecompressingEntity gzipDecompressingEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipDecompressingEntity.getContent();
                    data = HttpXmlUtils.getHTMLContent(in);
                }
            } else {
                resEntity = response.getEntity();
                String string = EntityUtils.toString((HttpEntity)resEntity);
                logger.error("response error:{}", (Object)string);
            }
        }
        catch (IOException var17) {
            logger.warn("Http put error", (Throwable)var17);
            throw var17;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("put request error {}", (Object)e.getMessage());
                }
            }
        }
        return data;
    }

    public static String putXmlRequest(String url, Map<String, String> header, String xml, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        CloseableHttpClient client = null;
        HttpPut put = new HttpPut(url);
        URI uri = put.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HttpXmlUtils.wrapperHttpClient(connectionTimeout, readTimeout);
            if (client == null) {
                return data;
            }
        } else {
            client = HttpXmlUtils.getHttpClient(cm);
        }
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(readTimeout).build();
        put.setConfig(config);
        HttpResponse response = null;
        try {
            HttpEntity resEntity;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    String key = entry.getKey();
                    put.setHeader(key, entry.getValue());
                }
            }
            ByteArrayEntity entity = new ByteArrayEntity(xml.getBytes("UTF-8"), ContentType.APPLICATION_XML);
            put.setEntity((HttpEntity)entity);
            response = client.execute((HttpUriRequest)put);
            if (response.getStatusLine().getStatusCode() == 200) {
                resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader == null || !"gzip".equalsIgnoreCase(respHeader.getValue()) && !"x-gzip".equalsIgnoreCase(respHeader.getValue())) {
                    data = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                } else {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpXmlUtils.getHTMLContent(in);
                }
            } else {
                resEntity = response.getEntity();
                String str = EntityUtils.toString((HttpEntity)resEntity);
                logger.error("response error:{}", (Object)str);
            }
        }
        catch (IOException e) {
            logger.warn("http put xml error", (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("putXmlRequest request error {}", (Object)e.getMessage());
                }
            }
        }
        return data;
    }

    public static String postXmlRequest(String url, Map<String, String> header, String xml, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HttpXmlUtils.wrapperHttpClient(connectionTimeout, readTimeout);
            if (client == null) {
                return data;
            }
        } else {
            client = HttpXmlUtils.getHttpClient(cm);
        }
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(readTimeout).build();
        post.setConfig(config);
        HttpResponse response = null;
        try {
            HttpEntity resEntity;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    String key = entry.getKey();
                    post.setHeader(key, entry.getValue());
                }
            }
            ByteArrayEntity entity = new ByteArrayEntity(xml.getBytes("UTF-8"), ContentType.APPLICATION_XML);
            post.setEntity((HttpEntity)entity);
            response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader == null || !"gzip".equalsIgnoreCase(respHeader.getValue()) && !"x-gzip".equalsIgnoreCase(respHeader.getValue())) {
                    data = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                } else {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpXmlUtils.getHTMLContent(in);
                }
            } else {
                resEntity = response.getEntity();
                String str = EntityUtils.toString((HttpEntity)resEntity);
                logger.error("response error:{}", (Object)str);
            }
        }
        catch (IOException e) {
            logger.warn("http post xml error", (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("postXmlRequest request error {}", (Object)e.getMessage());
                }
            }
        }
        return data;
    }

    public static String postApplicationJSON(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpXmlUtils.postApplicationJSON(url, header, JSONObject.toJSONString(body), default_connectionTimeout, default_readTimeout);
    }

    public static String postApplicationJSON(String url, Map<String, String> header, String json) throws IOException {
        return HttpXmlUtils.postApplicationJSON(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    public static String postApplicationJSON(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HttpXmlUtils.wrapperHttpClient(connectionTimeout, readTimeout);
            if (client == null) {
                return data;
            }
        } else {
            client = HttpXmlUtils.getHttpClient(cm);
        }
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(readTimeout).build();
        post.setConfig(config);
        HttpResponse response = null;
        try {
            HttpEntity resEntity;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    String key = entry.getKey();
                    post.setHeader(key, entry.getValue());
                }
            }
            ByteArrayEntity entity = new ByteArrayEntity(json.getBytes("UTF-8"), ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)entity);
            response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader == null || !"gzip".equalsIgnoreCase(respHeader.getValue()) && !"x-gzip".equalsIgnoreCase(respHeader.getValue())) {
                    data = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                } else {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpXmlUtils.getHTMLContent(in);
                }
            } else {
                resEntity = response.getEntity();
                String str = EntityUtils.toString((HttpEntity)resEntity);
                logger.error("response error:{}", (Object)str);
            }
        }
        catch (IOException e) {
            logger.warn("http post json error", (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("postApplicationJSON request error {}", (Object)e.getMessage());
                }
            }
        }
        return data;
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpXmlUtils.post(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HttpXmlUtils.wrapperHttpClient(connectionTimeout, readTimeout);
            if (client == null) {
                return data;
            }
        } else {
            client = HttpXmlUtils.getHttpClient(cm);
        }
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(readTimeout).build();
        post.setConfig(config);
        HttpResponse response = null;
        try {
            HttpEntity resEntity;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    String string = entry.getKey();
                    post.setHeader(string, entry.getValue());
                }
            }
            if (body != null && body.size() != 0) {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    String key = entry.getKey();
                    String value = String.valueOf(entry.getValue());
                    params.add(new BasicNameValuePair(key, value));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
                post.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200) {
                resEntity = response.getEntity();
                Header header2 = resEntity.getContentEncoding();
                if (header2 == null || !"gzip".equalsIgnoreCase(header2.getValue()) && !"x-gzip".equalsIgnoreCase(header2.getValue())) {
                    data = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                } else {
                    GzipDecompressingEntity gzipDecompressingEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipDecompressingEntity.getContent();
                    data = HttpXmlUtils.getHTMLContent(in);
                }
            } else {
                resEntity = response.getEntity();
                String string = EntityUtils.toString((HttpEntity)resEntity);
                logger.error("response error:{}", (Object)string);
            }
        }
        catch (IOException e) {
            logger.warn("http post error", (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("post request error {}", (Object)e.getMessage());
                }
            }
        }
        return data;
    }

    public static String putApplicationJSON(String url, Map<String, String> header, String json) throws IOException {
        return HttpXmlUtils.putApplicationJSON(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    public static String putApplicationJSON(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        CloseableHttpClient client = null;
        HttpPut put = new HttpPut(url);
        URI uri = put.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HttpXmlUtils.wrapperHttpClient(connectionTimeout, readTimeout);
            if (client == null) {
                return data;
            }
        } else {
            client = HttpXmlUtils.getHttpClient(cm);
        }
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(readTimeout).build();
        put.setConfig(config);
        HttpResponse response = null;
        try {
            HttpEntity resEntity;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    String key = entry.getKey();
                    put.setHeader(key, entry.getValue());
                }
            }
            ByteArrayEntity entity = new ByteArrayEntity(json.getBytes("UTF-8"), ContentType.APPLICATION_JSON);
            put.setEntity((HttpEntity)entity);
            response = client.execute((HttpUriRequest)put);
            if (response.getStatusLine().getStatusCode() == 200) {
                resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader == null || !"gzip".equalsIgnoreCase(respHeader.getValue()) && !"x-gzip".equalsIgnoreCase(respHeader.getValue())) {
                    data = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                } else {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpXmlUtils.getHTMLContent(in);
                }
            } else {
                resEntity = response.getEntity();
                String str = EntityUtils.toString((HttpEntity)resEntity);
                logger.error("response error:{}", (Object)str);
            }
        }
        catch (IOException e) {
            logger.warn("http put json error", (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("putApplicationJSON request error {}", (Object)e.getMessage());
                }
            }
        }
        return data;
    }

    public static String delete(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpXmlUtils.delete(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String delete(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        String strBody = "";
        HttpResponse response = null;
        try {
            Object value;
            if (body != null && body.size() != 0) {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    String key = entry.getKey();
                    value = String.valueOf(entry.getValue());
                    params.add(new BasicNameValuePair(key, (String)value));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                strBody = EntityUtils.toString((HttpEntity)entity);
            }
            String destUrl = "";
            destUrl = StringUtils.isEmpty((String)strBody) ? url : url + "?" + strBody;
            logger.info("delete method url :{}", (Object)destUrl);
            HttpDelete delete = new HttpDelete(destUrl);
            URI uri = delete.getURI();
            HttpClient client = null;
            if (SCHEME_HTTPS.equals(uri.getScheme())) {
                client = HttpXmlUtils.wrapperHttpClient(connectionTimeout, readTimeout);
                if (client == null) {
                    value = data;
                    return value;
                }
            } else {
                client = HttpXmlUtils.getHttpClient(cm);
            }
            if (header != null && header.size() != 0) {
                for (Map.Entry entry : header.entrySet()) {
                    String key = (String)entry.getKey();
                    delete.setHeader(key, (String)entry.getValue());
                }
            }
            RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(readTimeout).build();
            delete.setConfig(config);
            response = client.execute((HttpUriRequest)delete);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                Header respHeader = httpEntity.getContentEncoding();
                if (respHeader == null || !"gzip".equalsIgnoreCase(respHeader.getValue()) && !"x-gzip".equalsIgnoreCase(respHeader.getValue())) {
                    data = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
                } else {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(httpEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpXmlUtils.getHTMLContent(in);
                }
            } else {
                HttpEntity httpEntity = response.getEntity();
                String str = EntityUtils.toString((HttpEntity)httpEntity);
                logger.error("response error:{}", (Object)str);
            }
        }
        catch (IOException var17) {
            logger.warn("Http put error", (Throwable)var17);
            throw var17;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("put request error {}", (Object)e.getMessage());
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("getHTMLContent error", (Throwable)e);
        }
        try {
            String line = null;
            if (br != null) {
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
        }
        catch (IOException var12) {
            logger.error("getHTMLContent error", (Throwable)var12);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException var11) {
                logger.error("getHTMLContent error", (Throwable)var11);
            }
        }
        return sb.toString();
    }

    static {
        logger = LogFactory.getLog(HttpXmlUtils.class);
        default_connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 5000);
        default_readTimeout = Integer.getInteger("httpclient.readTimeout", 20000);
        SCHEME_HTTPS = "https";
        cm = new PoolingHttpClientConnectionManager(60000L, TimeUnit.MILLISECONDS);
        cm.setMaxTotal(20);
        cm.setDefaultMaxPerRoute(50);
    }
}

