/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.api.websocket.query;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import kd.ai.gai.core.api.websocket.query.GaiRequestContext;
import kd.ai.gai.core.api.websocket.query.RequiredParams;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.context.RequestContext;
import org.apache.commons.lang3.StringUtils;

public class WsRequestParams {
    public static String REQUEST_PREFIX = "request.";
    public static String RESPONSE_PREFIX = "response.";
    private Object bizParams;
    private RequiredParams requiredParams;

    public WsRequestParams() {
    }

    public WsRequestParams(RequiredParams requiredParams, Object bizParams) {
        this.requiredParams = requiredParams;
        this.bizParams = bizParams;
    }

    public WsRequestParams(String type, String requestId, Object bizParams) {
        RequiredParams requiredParams = new RequiredParams();
        requiredParams.setType(type);
        requiredParams.setRequestId(requestId);
        this.initGaiRequestContext(requiredParams);
        this.requiredParams = requiredParams;
        this.bizParams = bizParams;
    }

    public WsRequestParams(String type, String requestId, BaseResult baseResult) {
        RequiredParams requiredParams = new RequiredParams();
        requiredParams.setType(type);
        requiredParams.setRequestId(requestId);
        this.initGaiRequestContext(requiredParams);
        this.requiredParams = requiredParams;
        this.bizParams = baseResult;
    }

    private void initGaiRequestContext(RequiredParams requiredParams) {
        RequestContext rc = RequestContext.get();
        GaiRequestContext gaiRequestContext = new GaiRequestContext(rc);
        requiredParams.setGaiRequestContext(gaiRequestContext);
    }

    public Object getBizParams() {
        return this.bizParams;
    }

    public void setBizParams(Object bizParams) {
        this.bizParams = bizParams;
    }

    public RequiredParams getRequiredParams() {
        return this.requiredParams;
    }

    public void setRequiredParams(RequiredParams requiredParams) {
        this.requiredParams = requiredParams;
    }

    public boolean isRequest() {
        return StringUtils.startsWith((CharSequence)this.getRequiredParams().getType(), (CharSequence)REQUEST_PREFIX);
    }

    public boolean isResponse() {
        return StringUtils.startsWith((CharSequence)this.getRequiredParams().getType(), (CharSequence)RESPONSE_PREFIX);
    }

    public String toJSONString() {
        return JSONObject.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }
}

