/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.dto;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.agent.ChatUser;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.service.AssistantService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.base.parameter.ParameterService;
import org.apache.commons.lang3.StringUtils;

public class GaiInitConfig
implements Serializable {
    private Boolean showIcon;
    private Boolean switchSide;
    private Boolean lockSide;
    private String selectedProcessNumber;
    private String startProcessNumber;
    private String selectedProcessId;
    private String startProcessId;
    private Map<String, String> startParams;
    private String chatSessionId;
    private String id;
    private SLIDEENV slideEnv;
    private Boolean newPortal;
    private String assistantId;
    private String assistantName;
    private String introduce;
    private String openingSpeech;
    private String avatar;
    private boolean userAgree;
    protected String activeControlId;
    private JSONArray selectionControls;
    private String tabChangeTo;
    private ChatUser chatUser;

    public GaiInitConfig() {
        this.newPortal = ParameterService.isSupportNewPortal();
        this.chatUser = ChatService.getChatUser();
        this.initGeneralAssistant();
    }

    public GaiInitConfig(Boolean showIcon, Boolean switchSide, Boolean lockSide, SLIDEENV slideEnv, String chatSessionId) {
        this.showIcon = showIcon;
        this.switchSide = switchSide;
        this.slideEnv = slideEnv == null ? SLIDEENV.MAIN : slideEnv;
        this.chatSessionId = chatSessionId;
        this.lockSide = lockSide;
        this.newPortal = ParameterService.isSupportNewPortal();
        this.chatUser = ChatService.getChatUser();
        this.initGeneralAssistant();
    }

    private void initGeneralAssistant() {
        Assistant assistant = AssistantService.getAssistantWithDefault();
        this.assistantId = StrUtils.longAsString(assistant.getId());
        this.assistantName = assistant.getName();
        this.introduce = assistant.getIntroduce();
        this.openingSpeech = assistant.getOpeningSpeech();
        String picture = assistant.getPicture();
        if (kd.bos.util.StringUtils.isNotEmpty((String)picture)) {
            String avatar;
            this.avatar = avatar = AgentService.assemblyPictureWebUrl(picture);
        }
    }

    public GaiInitConfig(Boolean showIcon, Boolean switchSide, Boolean lockSide, SLIDEENV slideEnv, String chatSessionId, String activeIdString, JSONArray selectionControls) {
        this.showIcon = showIcon;
        this.switchSide = switchSide;
        this.slideEnv = slideEnv == null ? SLIDEENV.MAIN : slideEnv;
        this.chatSessionId = chatSessionId;
        this.lockSide = lockSide;
        this.newPortal = ParameterService.isSupportNewPortal();
        this.activeControlId = activeIdString;
        this.selectionControls = selectionControls;
    }

    public GaiInitConfig(String chatSessionId) {
        this.chatSessionId = chatSessionId;
        this.switchSide = null;
        this.newPortal = ParameterService.isSupportNewPortal();
        this.chatUser = ChatService.getChatUser();
        this.initGeneralAssistant();
    }

    public String getStartProcessId() {
        return this.startProcessId;
    }

    public void setStartProcessId(String startProcessId) {
        this.startProcessId = startProcessId;
    }

    public Boolean getLockSide() {
        return this.lockSide;
    }

    public String getTabChangeTo() {
        return this.tabChangeTo;
    }

    public void setTabChangeTo(String tabChangeTo) {
        this.tabChangeTo = tabChangeTo;
    }

    public void setLockSide(Boolean lockSide) {
        this.lockSide = lockSide;
    }

    public Boolean getShowIcon() {
        return this.showIcon;
    }

    public String getActiveControlId() {
        return this.activeControlId;
    }

    public void setActiveControlId(String activeControlId) {
        this.activeControlId = activeControlId;
    }

    public JSONArray getSelectionControls() {
        return this.selectionControls;
    }

    public void setSelectionControls(JSONArray selectionControls) {
        this.selectionControls = selectionControls;
    }

    public void setShowIcon(Boolean showIcon) {
        this.showIcon = showIcon;
    }

    public String getSelectedProcessNumber() {
        return this.selectedProcessNumber;
    }

    public void setSelectedProcessNumber(String selectedProcessNumber) {
        this.selectedProcessNumber = selectedProcessNumber;
    }

    public String getStartProcessNumber() {
        return this.startProcessNumber;
    }

    public void setStartProcessNumber(String startProcessNumber) {
        this.startProcessNumber = startProcessNumber;
    }

    public Boolean getSwitchSide() {
        return this.switchSide;
    }

    public void setSwitchSide(Boolean switchSide) {
        this.switchSide = switchSide;
    }

    public String getSelectedProcessId() {
        return this.selectedProcessId;
    }

    public void setSelectedProcessId(String selectedProcessId) {
        this.selectedProcessId = selectedProcessId;
    }

    public SLIDEENV getSlideEnv() {
        return this.slideEnv;
    }

    public void setSlideEnv(SLIDEENV slideEnv) {
        this.slideEnv = slideEnv;
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this);
    }

    public String getChatSessionId() {
        return this.chatSessionId;
    }

    public void setChatSessionId(String chatSessionId) {
        this.chatSessionId = chatSessionId;
    }

    public Map<String, String> getStartParams() {
        return this.startParams;
    }

    public void setStartParams(Map<String, String> startParams) {
        this.startParams = startParams;
    }

    public Boolean getNewPortal() {
        return this.newPortal;
    }

    public void setNewPortal(Boolean newPortal) {
        this.newPortal = newPortal;
    }

    public String getAssistantName() {
        return this.assistantName;
    }

    public void setAssistantName(String assistantName) {
        this.assistantName = assistantName;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public boolean isUserAgree() {
        return this.userAgree;
    }

    public void setUserAgree(boolean userAgree) {
        this.userAgree = userAgree;
    }

    public String getIntroduce() {
        return this.introduce;
    }

    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }

    public String getOpeningSpeech() {
        return this.openingSpeech;
    }

    public void setOpeningSpeech(String openingSpeech) {
        this.openingSpeech = openingSpeech;
    }

    public ChatUser getChatUser() {
        return this.chatUser;
    }

    public void setChatUser(ChatUser chatUser) {
        this.chatUser = chatUser;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public String getId() {
        if (StringUtils.isNotEmpty((CharSequence)this.getChatSessionId())) {
            this.id = this.getChatSessionId();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

