/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;

public class AwsClaude2Param
extends LlmParam {
    private int top_p;
    private int top_k;
    private int max_tokens_to_sample;
    private float temperature;
    @MaskingField
    private String prompt;
    private List<String> stop_sequences;
    @JSONField(serialize=false)
    private int inPutToken;

    public AwsClaude2Param() {
        this.setLlmStyle(LlmStyle.BALANCE);
    }

    public AwsClaude2Param(LlmStyle llmStyle) {
        this.setLlmStyle(llmStyle);
        this.stop_sequences = new ArrayList<String>();
        this.stop_sequences.add("\\n\\nHuman:");
    }

    public int getTop_p() {
        return this.top_p;
    }

    public void setTop_p(int top_p) {
        this.top_p = top_p;
    }

    public int getTop_k() {
        return this.top_k;
    }

    public void setTop_k(int top_k) {
        this.top_k = top_k;
    }

    public int getMax_tokens_to_sample() {
        return this.max_tokens_to_sample;
    }

    public void setMax_tokens_to_sample(int max_tokens_to_sample) {
        this.max_tokens_to_sample = max_tokens_to_sample;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public List<String> getStop_sequences() {
        return this.stop_sequences;
    }

    public void setStop_sequences(List<String> stop_sequences) {
        this.stop_sequences = stop_sequences;
    }

    @Override
    public int getInPutToken() {
        return this.inPutToken;
    }

    @Override
    public void setInPutToken(int inPutToken) {
        this.inPutToken = inPutToken;
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle) {
        switch (llmStyle) {
            case CREATIVITY: {
                this.temperature = 0.8f;
                this.top_p = 1;
                this.top_k = 1;
                this.max_tokens_to_sample = 8000;
                break;
            }
            case PRECISION: {
                this.temperature = 0.0f;
                this.top_p = 1;
                this.top_k = 250;
                this.max_tokens_to_sample = 8000;
                break;
            }
            default: {
                this.temperature = 0.5f;
                this.top_p = 1;
                this.top_k = 250;
                this.max_tokens_to_sample = 8000;
            }
        }
    }
}

