/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;

public class KimiParam
extends LlmParam {
    private String model;
    private float temperature;
    @MaskingField
    private List<MessageItem4AzureBaiduTencentXf> messages;
    private boolean stream;
    private float top_p;
    private int n;
    @JSONField(serialize=false)
    private int inPutToken;

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public KimiParam() {
        this.setLlmStyle(LlmStyle.BALANCE);
    }

    public KimiParam(LlmStyle llmStyle, LLM llm) {
        this.setLlmStyle(llmStyle, llm);
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public float getTop_p() {
        return this.top_p;
    }

    public void setTop_p(float top_p) {
        this.top_p = top_p;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public List<MessageItem4AzureBaiduTencentXf> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageItem4AzureBaiduTencentXf> messages) {
        this.messages = messages;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle) {
        this.setLlmStyle(llmStyle, LLM.MOONSHOT_V1_8K);
    }

    @Override
    public int getInPutToken() {
        return this.inPutToken;
    }

    @Override
    public void setInPutToken(int inPutToken) {
        this.inPutToken = inPutToken;
    }

    protected final void setLlmStyle(LlmStyle llmStyle, LLM llm) {
        this.n = 1;
        this.top_p = 1.0f;
        switch (llmStyle) {
            case CREATIVITY: {
                this.temperature = 0.7f;
                break;
            }
            case PRECISION: {
                this.temperature = 0.2f;
                break;
            }
            default: {
                this.temperature = 0.3f;
            }
        }
        switch (llm) {
            case MOONSHOT_V1_8K: {
                this.model = "moonshot-v1-8k";
                break;
            }
            case MOONSHOT_V1_32K: {
                this.model = "moonshot-v1-32k";
                break;
            }
            case MOONSHOT_V1_128K: {
                this.model = "moonshot-v1-128k";
            }
        }
    }
}

