/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class KingdeeLlmParam
extends LlmParam {
    @MaskingField
    private List<String> instructions;
    @MaskingField
    private List<String> inputs;
    private List<Float> temperatures;
    private boolean stream;

    public KingdeeLlmParam() {
    }

    public KingdeeLlmParam(LlmStyle llmStyle) {
        this.setLlmStyle(llmStyle);
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public List<String> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<String> instructions) {
        this.instructions = instructions;
    }

    public void setUserInput(String userInput) {
        if (this.instructions == null) {
            this.instructions = new ArrayList<String>();
        }
        this.instructions.add(userInput);
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public List<Float> getTemperatures() {
        return this.temperatures;
    }

    public void setTemperatures(List<Float> temperatures) {
        this.temperatures = temperatures;
    }

    public void setSystem(String system) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<String>();
        }
        if (!StringUtils.isEmpty((CharSequence)system)) {
            this.inputs.add(system);
        }
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle) {
        this.temperatures = new ArrayList<Float>();
        switch (llmStyle) {
            case CREATIVITY: {
                this.temperatures.add(Float.valueOf(0.8f));
                break;
            }
            case PRECISION: {
                this.temperatures.add(Float.valueOf(0.01f));
                break;
            }
            default: {
                this.temperatures.add(Float.valueOf(0.5f));
            }
        }
    }
}

