/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;

public class XunFeiLlmParam
extends LlmParam {
    private Parameter parameter;
    @MaskingField
    private Payload payload;

    public XunFeiLlmParam() {
    }

    public XunFeiLlmParam(LlmStyle llmStyle) {
        this.setLlmStyle(llmStyle);
    }

    public void setTemperature(float temperature) {
        ParameterChat chat;
        if (this.parameter == null) {
            this.parameter = new Parameter();
        }
        if ((chat = this.parameter.chat) == null) {
            chat = new ParameterChat();
        }
        chat.setTemperature(temperature);
    }

    public void setMessages(List<MessageItem4AzureBaiduTencentXf> textList) {
        PayloadMessage payloadMessage;
        if (this.payload == null) {
            this.payload = new Payload();
        }
        if ((payloadMessage = this.payload.getMessage()) == null) {
            payloadMessage = new PayloadMessage();
        }
        payloadMessage.setText(textList);
        this.payload.setMessage(payloadMessage);
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    @Override
    public final void setLlmStyle(LlmStyle llmStyle) {
        switch (llmStyle) {
            case CREATIVITY: {
                this.setTemperature(0.8f);
                break;
            }
            case BALANCE: {
                this.setTemperature(0.5f);
                break;
            }
            default: {
                this.setTemperature(0.01f);
            }
        }
    }

    public static class PayloadMessage {
        @MaskingField
        private List<MessageItem4AzureBaiduTencentXf> text;

        public List<MessageItem4AzureBaiduTencentXf> getText() {
            return this.text;
        }

        public void setText(List<MessageItem4AzureBaiduTencentXf> text) {
            this.text = text;
        }
    }

    public static class Payload {
        @MaskingField
        private PayloadMessage message;

        public PayloadMessage getMessage() {
            return this.message;
        }

        public void setMessage(PayloadMessage message) {
            this.message = message;
        }
    }

    public static class ParameterChat {
        private String domain = "generalv3";
        private float temperature;

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public float getTemperature() {
            return this.temperature;
        }

        public void setTemperature(float temperature) {
            this.temperature = temperature;
        }
    }

    public static class Parameter {
        private ParameterChat chat = new ParameterChat();

        public ParameterChat getChat() {
            return this.chat;
        }

        public void setChat(ParameterChat chat) {
            this.chat = chat;
        }
    }
}

