/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.bos.context.RequestContext;
import org.apache.commons.lang3.StringUtils;

public class Context
implements Serializable {
    private long userId;
    private String globalSessionId;
    private String chatSessionId;
    private String assistantPageId;
    private String bizPageId;
    private String rootPageId;
    private Assistant assistant;
    private SLIDEENV slideenv;
    private List<Skill> skillList;
    private Skill currentSkill;

    public Context() {
    }

    public Context(SLIDEENV slideenv) {
        this.slideenv = slideenv;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getGlobalSessionId() {
        return this.globalSessionId;
    }

    public void setGlobalSessionId(String globalSessionId) {
        this.globalSessionId = globalSessionId;
    }

    public String getChatSessionId() {
        return this.chatSessionId;
    }

    public void setChatSessionId(String chatSessionId) {
        this.chatSessionId = chatSessionId;
    }

    public String getAssistantPageId() {
        return this.assistantPageId;
    }

    public void setAssistantPageId(String assistantPageId) {
        this.assistantPageId = assistantPageId;
    }

    public SLIDEENV getSlideenv() {
        return this.slideenv;
    }

    public void setSlideenv(SLIDEENV slideenv) {
        this.slideenv = slideenv;
    }

    public String getBizPageId() {
        return this.bizPageId;
    }

    public void setBizPageId(String bizPageId) {
        this.bizPageId = bizPageId;
    }

    public Assistant getAssistant() {
        return this.assistant;
    }

    public void setAssistant(Assistant assistant) {
        this.assistant = assistant;
    }

    public List<Skill> getSkillList() {
        return this.skillList;
    }

    public void setSkillList(List<Skill> skillList) {
        this.skillList = skillList;
    }

    public String getRootPageId() {
        return this.rootPageId;
    }

    public void setRootPageId(String rootPageId) {
        this.rootPageId = rootPageId;
    }

    public Skill getCurrentSkill() {
        return this.currentSkill;
    }

    public void setCurrentSkill(Skill currentSkill) {
        this.currentSkill = currentSkill;
    }

    public static Context create(SLIDEENV slideenv, long assistantId, String rootPageId, String assistantPageId, String bizPageId, List<Skill> processData) {
        Context context = new Context(slideenv);
        String chatSessionId = UUID.randomUUID().toString().replace("-", "");
        context.setChatSessionId(chatSessionId);
        context.setGlobalSessionId(RequestContext.get().getGlobalSessionId());
        context.setUserId(RequestContext.get().getCurrUserId());
        Assistant assistant = new Assistant();
        assistant.setId(assistantId);
        context.setAssistant(assistant);
        context.setRootPageId(rootPageId);
        context.setAssistantPageId(assistantPageId);
        context.setBizPageId(bizPageId);
        context.setSkillList(processData);
        FlowCacheData.putContext(chatSessionId, context);
        return context;
    }

    public static Context create(SLIDEENV slideenv, String chatSessionId, String rootPageId, long assistantId, String assistantPageId, String bizPageId, List<Skill> processData) {
        Context context = new Context(slideenv);
        context.setChatSessionId(chatSessionId);
        context.setGlobalSessionId(RequestContext.get().getGlobalSessionId());
        context.setUserId(RequestContext.get().getCurrUserId());
        Assistant assistant = new Assistant();
        assistant.setId(assistantId);
        context.setRootPageId(rootPageId);
        context.setAssistant(assistant);
        context.setAssistantPageId(assistantPageId);
        context.setBizPageId(bizPageId);
        context.setSkillList(processData);
        FlowCacheData.putContext(chatSessionId, context);
        return context;
    }

    public static Context create(SLIDEENV slideenv, Assistant assistant, String rootPageId, String assistantPageId, String bizPageId, List<Skill> processData, String chatSessionId) {
        Context context = new Context(slideenv);
        if (StringUtils.isEmpty((CharSequence)chatSessionId)) {
            chatSessionId = UUID.randomUUID().toString().replace("-", "");
        }
        context.setChatSessionId(chatSessionId);
        context.setGlobalSessionId(RequestContext.get().getGlobalSessionId());
        context.setUserId(RequestContext.get().getCurrUserId());
        context.setAssistant(assistant);
        context.setAssistantPageId(assistantPageId);
        context.setRootPageId(rootPageId);
        context.setBizPageId(bizPageId);
        context.setSkillList(processData);
        FlowCacheData.putContext(chatSessionId, context);
        return context;
    }

    public static Context create4API() {
        Context context = new Context(SLIDEENV.API_MSERVICE);
        String chatSessionId = UUID.randomUUID().toString().replace("-", "");
        context.setChatSessionId(chatSessionId);
        context.setGlobalSessionId(RequestContext.get().getGlobalSessionId());
        context.setUserId(RequestContext.get().getCurrUserId());
        context.setAssistant(new Assistant());
        FlowCacheData.putContext(chatSessionId, context);
        return context;
    }

    public static boolean needCheckLicense(Context context) {
        return context.getSlideenv() != SLIDEENV.PLAYGROUND && context.getSlideenv() != SLIDEENV.ASSISTANT && context.getSlideenv() != SLIDEENV.AGENT;
    }
}

