/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine;

import java.util.Objects;
import kd.ai.gai.core.engine.Errors;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;

public class EngineCache {
    private static final int MAX_KEY_LENGTH = 4;

    private EngineCache() {
    }

    public static IAppCache getAppCache(String chatSessionId) {
        if (Objects.nonNull(chatSessionId)) {
            int length = chatSessionId.length();
            if (length > 4) {
                chatSessionId = chatSessionId.substring(0, 4);
            }
        } else {
            throw new KDBizException(Errors.APPCACHE_KEY_ISNULL, new Object[0]);
        }
        return AppCache.get((String)("gai-" + chatSessionId));
    }

    public static IAppCache getAppCache4UserSession(String userSessionId) {
        if (Objects.nonNull(userSessionId)) {
            int length = userSessionId.length();
            if (length > 4) {
                userSessionId = userSessionId.substring(0, 4);
            }
        } else {
            throw new KDBizException(Errors.APPCACHE_KEY_ISNULL, new Object[0]);
        }
        return AppCache.get((String)("gai-u-" + userSessionId));
    }
}

