/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine;

import java.util.Collections;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.service.ProcessService;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;

public class FlowCacheData {
    public static final Log log = LogFactory.getLog(FlowCacheData.class);

    private FlowCacheData() {
    }

    public static Flow createFlow(String chatSessionId, long processId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        Process process = ProcessService.getProcessById(processId);
        if (process == null) {
            throw new KDBizException(Errors.flowNotExistedError(String.valueOf(processId)), new Object[0]);
        }
        String flowBase64Str = process.getFlow();
        if (StringUtils.isEmpty((String)flowBase64Str)) {
            throw new KDBizException(Errors.flowNotDataError(String.valueOf(processId)), new Object[0]);
        }
        Flow flow = JsonUtil.fromBase64String(flowBase64Str);
        long flowId = DB.genLongId((String)"t_gai_process");
        flow.setId(flowId);
        flow.setDefId(processId);
        flow.setNumber(process.getNumber());
        flow.setName(process.getName());
        log.info("\u5b9e\u4f8b\u5316\u6d41\u7a0b{}-{}, \u6d41\u7a0b\u5b9e\u4f8bID{}", new Object[]{chatSessionId, processId, flowId});
        flowBase64Str = JsonUtil.toBase64String(flow);
        String key = FlowCacheData.buildFlowInstanceIdKey(flowId);
        appCache.put(key, (Object)flowBase64Str);
        String resultKey = String.format("%s_%s", chatSessionId, processId);
        FlowCacheData.clearCache(chatSessionId, resultKey);
        return flow;
    }

    public static Flow getFlowById(String chatSessionId, long flowId) {
        String key;
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String flowBase64Str = (String)appCache.get(key = FlowCacheData.buildFlowInstanceIdKey(flowId), String.class);
        if (StringUtils.isNotEmpty((String)flowBase64Str)) {
            return JsonUtil.fromBase64String(flowBase64Str);
        }
        return null;
    }

    public static void clearFlow(String chatSessionId, long flowId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String key = FlowCacheData.buildFlowInstanceIdKey(flowId);
        appCache.remove(key);
    }

    public static String buildFlowInstanceIdKey(long flowId) {
        return "F_IT_" + flowId;
    }

    public static Map<String, String> getFlowNodeData(String chatSessionId, long flowId, int nodeId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        Map data = (Map)appCache.get(FlowCacheData.flowNodeKey(flowId, nodeId), Map.class);
        if (data != null) {
            return data;
        }
        return Collections.emptyMap();
    }

    public static void setFlowNodeData(String chatSessionId, long flowId, int nodeId, Map<String, String> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.put(FlowCacheData.flowNodeKey(flowId, nodeId), data);
    }

    public static void clearFlowNodeData(String chatSessionId, long flowId, int nodeId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.remove(FlowCacheData.flowNodeKey(flowId, nodeId));
    }

    private static String flowNodeKey(long flowId, int nodeId) {
        return String.format("ND-%s-%s", flowId, nodeId);
    }

    public static void putContext(String chatSessionId, Context context) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.put("CTX-" + chatSessionId, (Object)context);
        appCache.put("RC-" + chatSessionId, (Object)SerializationUtils.toJsonString((Object)RequestContext.get()));
    }

    public static Context getContext(String chatSessionId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        return (Context)appCache.get("CTX-" + chatSessionId, Context.class);
    }

    public static void restoreRequestContext(String chatSessionId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        try {
            String rcString = (String)appCache.get("RC-" + chatSessionId, String.class);
            if (rcString != null) {
                Map rcMap = (Map)SerializationUtils.fromJsonString((String)rcString, Map.class);
                RequestContext rc = RequestContext.create((boolean)false);
                rc.setClient((String)rcMap.get("client"));
                rc.setUserAgent((String)rcMap.get("userAgent"));
                rc.setTenantId((String)rcMap.get("tenantId"));
                rc.setAccountId((String)rcMap.get("accountId"));
                rc.setUserId((String)rcMap.get("userId"));
                if (rcMap.get("orgid") != null) {
                    rc.setOrgId(Long.parseLong((String)rcMap.get("orgid")));
                }
                rc.setGlobalSessionId((String)rcMap.get("globalSessionId"));
                rc.setTenantCode((String)rcMap.get("tenantCode"));
                if (rcMap.get("lang") != null) {
                    Lang lang = Lang.from((String)((String)rcMap.get("lang")));
                    rc.setLang(lang);
                }
                if (rcMap.get("tenantInfo") != null) {
                    TenantInfo tenantInfo;
                    Map tenantMap = (Map)rcMap.get("tenantInfo");
                    if (rc.getTenantInfo() == null) {
                        tenantInfo = new TenantInfo((String)tenantMap.get("id"), (String)tenantMap.get("name"));
                        rc.setTenantInfo(tenantInfo);
                    } else {
                        tenantInfo = rc.getTenantInfo();
                        tenantInfo.setId((String)tenantMap.get("id"));
                        tenantInfo.setName((String)tenantMap.get("name"));
                    }
                    tenantInfo.setInstanceNumber((String)tenantMap.get("instanceNumber"));
                    if (tenantMap.get("joinImprovement") != null) {
                        tenantInfo.setJoinImprovement(((Boolean)tenantMap.get("joinImprovement")).booleanValue());
                    }
                }
                rc.setUserName((String)rcMap.get("userName"));
                rc.setUserOpenId((String)rcMap.get("userOpenId"));
                rc.setUserType((String)rcMap.get("userType"));
                rc.setYzjAppId((String)rcMap.get("yzjAppId"));
                rc.setYzjAppTicket((String)rcMap.get("yzjAppTicket"));
                rc.setUid((String)rcMap.get("uid"));
                rc.setTraceId((String)rcMap.get("traceId"));
                RequestContextCreator.restoreForThreadPool((RequestContext)rc);
            }
        }
        catch (Exception e) {
            appCache.remove("RC-" + chatSessionId);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static RootPageIdContext getContextByRootPageId(String rootPageId) {
        IAppCache appCache = EngineCache.getAppCache(rootPageId);
        return (RootPageIdContext)appCache.get("RootPageId-" + rootPageId, RootPageIdContext.class);
    }

    public static void putRootPageId2ChatSessionId(String rootPageId, RootPageIdContext rootPageIdContext) {
        IAppCache appCache = EngineCache.getAppCache(rootPageId);
        appCache.put("RootPageId-" + rootPageId, (Object)rootPageIdContext);
    }

    public static void putCache(String chatSessionId, String key, String value) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.put(key, (Object)value);
    }

    public static String getCache(String chatSessionId, String key) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        return (String)appCache.get(key, String.class);
    }

    public static void clearCache(String chatSessionId, String key) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.remove(key);
    }
}

