/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.ai.gai.core.cache.GaiCache;
import kd.ai.gai.core.domain.vo.APIReferenceData;
import kd.ai.gai.core.domain.vo.KnowledgeCitationData;
import kd.ai.gai.core.engine.APILLMData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.APILLMMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.llmcallback.APICallbackMessage;
import kd.ai.gai.core.helper.KnowledgeCitationHelper;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class APILLMHandler
implements IMessageHandler<APILLMMessage>,
IActionCallBack<APICallbackMessage> {
    private static final Log logger = LogFactory.getLog(APILLMHandler.class);

    @Override
    public void callback(APICallbackMessage message) {
        logger.info(String.format("\u3010GPT\u63d0\u793a-OpenApi\u670d\u52a1\u3011API\u56de\u8c03\uff0c\u56de\u8c03\u4fe1\u606f\uff1a%s ", JSON.toJSONString((Object)message)));
        String chatSessionId = message.getChatSessionId();
        String taskId = message.getTaskId();
        long seqNo = GaiCache.counter(taskId);
        List<KnowledgeCitationData> citationInfos = message.getCitationInfos();
        List<APIReferenceData> apiReferenceData = KnowledgeCitationHelper.boxCitationInfoToAPIService(citationInfos);
        APILLMData llmData = new APILLMData(message.getTaskId(), message.getErrCode(), message.getErrMsg(), seqNo, message.isStream(), message.isEnd(), message.getLlmValue(), JsonUtil.toJson(apiReferenceData));
        String apiKey = GaiCache.buildOpenApiKey(taskId, seqNo);
        String llmDataStr = JSON.toJSONString((Object)llmData);
        GaiCache.put(apiKey, llmDataStr);
        logger.info(String.format("\u3010GPT\u63d0\u793a-OpenApi\u670d\u52a1\u3011API\u56de\u8c03,\u5199\u5165\uff1achatSessionId :%s, \u8ba1\u6570\u5668\uff1a%s, key:%s ,msg: %s", chatSessionId, seqNo, apiKey, llmDataStr));
        TraceUtil.saveIfStreamAsyncLLMLog(FlowCacheData.getContext(chatSessionId), message);
    }

    @Override
    public Result process(Context context, APILLMMessage message) {
        APICallbackMessage callbackMessage = new APICallbackMessage();
        callbackMessage.setChatSessionId(context.getChatSessionId());
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(callbackMessage);
        llmMessage.setUserInput(message.getUserInput());
        llmMessage.setPromptId(message.getPromptId());
        llmMessage.setStream(message.isStream());
        llmMessage.setParamMap(message.getParamMap());
        llmMessage.setRepoIdList(message.getRepoIdList());
        llmMessage.setUseKnowledgeTopK(message.getUseKnowledgeTopK());
        Result result = HandlerFactory.runHandler(context, llmMessage);
        result.setCallback(true);
        return result;
    }
}

