/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.UUID;
import kd.ai.gai.core.api.websocket.query.WsRequestParams;
import kd.ai.gai.core.constant.agent.AgentConstants;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.AgentMessage;
import kd.ai.gai.core.domain.dto.agent.AiccAgentConfig;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.MessageConfig;
import kd.ai.gai.core.domain.dto.agent.Repo;
import kd.ai.gai.core.domain.dto.agent.Run;
import kd.ai.gai.core.domain.dto.agent.annotations.BaseAnnotation;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.message.AgentChatMessage;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.service.WebSocketService;
import kd.ai.gai.core.service.agent.AgentMsgWatchWebSocketService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.AgentServiceService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.agent.RunService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class AgentChatHandler
implements IMessageHandler<AgentChatMessage> {
    private static final Log log = LogFactory.getLog(AgentChatHandler.class);

    @Override
    public Result process(Context context, AgentChatMessage agentChatMessage) {
        log.info("process start... with userMessage:{}", (Object)JSONObject.toJSONString((Object)agentChatMessage.getUserMessage()));
        String chatSessionId = agentChatMessage.getChatSessionId();
        Message userMessage = agentChatMessage.getUserMessage();
        DynamicObject editAgentDo = agentChatMessage.getEditAgentDo();
        if (userMessage == null || userMessage.getMessageId() == null || userMessage.getMessageId() == 0L) {
            userMessage = MessageService.getLastUserMessage(chatSessionId, null);
            log.info("re process start... with userMessage:{}", (Object)JSONObject.toJSONString((Object)agentChatMessage.getUserMessage()));
            if (userMessage == null) {
                log.info("userMessage not exist");
                ErrorCode errorCode = Errors.AGNET_NO_USER_MESSAGE;
                this.sendError(context, errorCode);
                return new Result(errorCode);
            }
        }
        if (!AgentServiceService.agentIsAvail("gai_agent").booleanValue()) {
            ErrorCode errorCode = Errors.AGENT_NO_MODEL;
            this.sendError(context, errorCode);
            return new Result(errorCode);
        }
        Result result = new Result(Errors.OK);
        Skill currentSkill = context.getCurrentSkill();
        Long skillId = userMessage.getSkillId();
        if (currentSkill != null && StringUtils.isNotEmpty((CharSequence)currentSkill.getId()) && Long.parseLong(currentSkill.getId()) > 0L) {
            skillId = Long.parseLong(currentSkill.getId());
        }
        if (Context.needCheckLicense(context)) {
            try {
                GPTLicenseHelper.checkLic(GaiFormIdEnum.GAI_AGENT.getId(), skillId);
            }
            catch (KDBizException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.sendError(context, e.getErrorCode());
                return new Result(e.getErrorCode());
            }
        }
        Agent agent = null;
        if (editAgentDo == null) {
            agent = AgentService.getAgent(skillId, true);
        } else {
            AiccAgentConfig aiccAgentConfig = AgentServiceService.getAgentService("gai_agent");
            agent = AgentService.trans2Agent(editAgentDo, true, aiccAgentConfig);
        }
        if (agent != null) {
            Result errorCode = this.checkQueryEntityAgent(context, agent);
            if (errorCode != null) {
                return errorCode;
            }
            String userInput = userMessage.getContentTag();
            EnableEnum enableEnum = EnableEnum.fromKeyStr(userMessage.getEnable());
            ChatService.saveChatSession(chatSessionId, userInput, userMessage.getAssistantId(), enableEnum);
            MessageConfig messageConfig = MessageService.getMessageConfig(userMessage);
            if (messageConfig.getNeedPushMsg().booleanValue()) {
                WebSocketService.pushWaiting(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), 0L, result.getTaskId(), context.getChatSessionId());
            }
            this.triggerAgentStart(agent, chatSessionId, userMessage, userInput);
        }
        return result;
    }

    @Nullable
    private Result checkQueryEntityAgent(Context context, Agent agent) {
        List<Repo> repoList;
        if (StringUtils.equalsIgnoreCase((CharSequence)agent.getAgentName(), (CharSequence)"query_entity") && CollectionUtils.isEmpty(repoList = agent.getRepoList())) {
            ErrorCode errorCode = Errors.AGENT_QUERY_ENTITY_NO_REPO;
            this.sendError(context, errorCode);
            return new Result(errorCode);
        }
        return null;
    }

    private void triggerAgentStart(Agent agent, String chatSessionId, Message userMessage, String contentTag) {
        String llm = agent.getLlm();
        Run run = new Run();
        run.setSessionId(userMessage.getSessionId());
        run.setMessageId(userMessage.getMessageId());
        run.setStartedAt(KDDateUtils.now());
        run.setRunStatus(RunStepStatusEnum.IN_PROGRESS.getId());
        run.setLlm(llm);
        run.setRunId(userMessage.getRunId());
        log.info("triggerAgentStart runId 01 : {}", (Object)run.getRunId());
        run = RunService.saveRun(run);
        List<BaseAnnotation> annotationList = AnnotationService.parseMessageAnnotations(contentTag);
        AgentMessage agentMessage = new AgentMessage();
        agentMessage.setChatSessionId(chatSessionId);
        agentMessage.setRunId(run.getRunId());
        agentMessage.setSessionId(userMessage.getSessionId());
        agentMessage.setMessageId(userMessage.getMessageId());
        agentMessage.setInput(contentTag);
        agentMessage.setAssistant(agent);
        agentMessage.setAnnotations(annotationList);
        String requestId = UUID.randomUUID().toString();
        WsRequestParams wsRequestParams = new WsRequestParams("request.agent.start", requestId, agentMessage);
        AgentMsgWatchWebSocketService agentMsgWatchWebSocketService = AgentConstants.agentMsgWatchWebSocketServiceMap.get(chatSessionId);
        if (agentMsgWatchWebSocketService == null) {
            agentMsgWatchWebSocketService = new AgentMsgWatchWebSocketService();
            AgentConstants.agentMsgWatchWebSocketServiceMap.put(chatSessionId, agentMsgWatchWebSocketService);
        }
        agentMsgWatchWebSocketService.sendMsg(chatSessionId, wsRequestParams);
    }

    private void sendError(Context context, ErrorCode errorCode) {
        log.error("code: {} message: {}", (Object)errorCode.getCode(), (Object)errorCode.getMessage());
        WebSocketService.pushErrMsg(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), errorCode.getCode(), errorCode.getMessage(), context.getChatSessionId());
    }
}

