/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.engine.message.llmcallback.ChatCallbackMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.SkillSrcEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.service.WebSocketService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class ChatHandler
implements IMessageHandler<ChatMessage>,
IActionCallBack<ChatCallbackMessage> {
    private static final Log log = LogFactory.getLog(ChatHandler.class);
    public static final String LLM_CT_RT = "LLM_CT_RT";
    public static final String LLM_CT_END = "LLM_CT_END";
    public static final String LLM_CT_MESSAGE = "LLM_CT_MESSAGE";

    @Override
    public Result process(Context context, ChatMessage chatMessage) {
        if (chatMessage.getSkillId() != 0L) {
            log.info("\u7528\u6237\u9009\u62e9\u6280\u80fd{},\u76f4\u63a5\u542f\u52a8\u6280\u80fd", (Object)chatMessage.getSkillId());
            Skill skill = new Skill();
            skill.setId(String.valueOf(chatMessage.getSkillId()));
            skill.setType(chatMessage.getSkillType());
            skill.setSkillSrc(SkillSrcEnum.USER);
            context.setCurrentSkill(skill);
            Message userMessage = MessageService.insertMessage(context.getChatSessionId(), chatMessage.getUserInput(), null, skill, ChatMessageTypeEnum.USER, EnableEnum.YES);
            return this.startSkill(context, skill, chatMessage.getUserInput(), chatMessage.getInParaMap() == null ? Collections.emptyMap() : chatMessage.getInParaMap(), true, userMessage);
        }
        Message message = MessageService.insertMessage(context.getChatSessionId(), chatMessage.getUserInput(), null, null, ChatMessageTypeEnum.USER, EnableEnum.YES);
        if (chatMessage.isNeedPushMsg()) {
            ChatService.pushUserOrAssistantMessage(context, message);
        }
        context.setCurrentSkill(null);
        FlowCacheData.putContext(context.getChatSessionId(), context);
        ErrorCode errorCode = this.verifyData(context, chatMessage);
        if (errorCode != null) {
            this.sendError(context, errorCode);
            return new Result(errorCode);
        }
        FlowCacheData.clearCache(context.getChatSessionId(), LLM_CT_RT);
        FlowCacheData.clearCache(context.getChatSessionId(), LLM_CT_END);
        FlowCacheData.clearCache(context.getChatSessionId(), LLM_CT_MESSAGE);
        List<Skill> skillList = context.getSkillList();
        ArrayList skillMapList = new ArrayList(skillList.size());
        for (Skill skill : skillList) {
            HashMap<String, String> skillMap = new HashMap<String, String>();
            skillMap.put("ID", skill.getId());
            skillMap.put("DESCRIPTION", skill.getServiceDes());
            skillMapList.add(skillMap);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("NAME", context.getAssistant().getName());
        paraMap.put("PERSONA", context.getAssistant().getPersona());
        paraMap.put("SKILL_LIST", JSON.toJSONString(skillMapList));
        String assistantContext = "-\u5f53\u524d\u65f6\u95f4: " + format.format(new Date()) + "\n";
        paraMap.put("ASSISTANT_CONTEXT", assistantContext);
        ChatCallbackMessage callbackMessage = new ChatCallbackMessage();
        callbackMessage.setParseOutput(false);
        callbackMessage.setChatSessionId(context.getChatSessionId());
        callbackMessage.setUserInput(chatMessage.getUserInput());
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(callbackMessage);
        llmMessage.setUserInput(chatMessage.getUserInput());
        llmMessage.setPromptId(context.getAssistant().getPromptId());
        llmMessage.setStream(true);
        llmMessage.setParamMap(paraMap);
        llmMessage.setChatSessionId(context.getChatSessionId());
        Result result = HandlerFactory.runHandler(context, llmMessage);
        result.setCallback(true);
        if (!result.getErrorCode().equals((Object)Errors.FAKE_OK)) {
            WebSocketService.pushWaiting(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), 0L, result.getTaskId(), context.getChatSessionId());
        }
        return result;
    }

    private ErrorCode verifyData(Context context, ChatMessage chatMessage) {
        if (context.getAssistant() == null) {
            return Errors.ASSISTANT_NOT_INIT;
        }
        List<Skill> flowList = context.getSkillList();
        if (flowList == null || flowList.isEmpty()) {
            return Errors.ASSISTANT_NO_FLOW;
        }
        if (context.getAssistant().getPromptId() == 0L) {
            return Errors.ASSISTANT_NO_PROMPT;
        }
        if (StringUtils.isEmpty((String)chatMessage.getUserInput())) {
            return Errors.noUserInputError();
        }
        return null;
    }

    private void sendError(Context context, ErrorCode errorCode) {
        log.error("code: {} message: {}", (Object)errorCode.getCode(), (Object)errorCode.getMessage());
        WebSocketService.pushErrMsg(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), errorCode.getCode(), errorCode.getMessage(), context.getChatSessionId());
    }

    @Override
    public void callback(ChatCallbackMessage callbackMessage) {
        Context context = FlowCacheData.getContext(callbackMessage.getChatSessionId());
        if (context == null) {
            log.error("chat session id [{}] , context is null", (Object)callbackMessage.getChatSessionId());
            return;
        }
        String errCode = callbackMessage.getErrCode();
        if (!Errors.OK.getCode().equals(errCode)) {
            log.error("\u56de\u8c03\u9519\u8bef,{}", (Object)callbackMessage);
            WebSocketService.pushErrMsg(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getErrCode(), callbackMessage.getErrMsg(), context.getChatSessionId());
            TraceUtil.saveAsyncLLMLog(context, callbackMessage);
            return;
        }
        List<Skill> skillList = context.getSkillList();
        if (skillList == null || skillList.isEmpty()) {
            this.noSkill(context, callbackMessage);
            return;
        }
        if (callbackMessage.isStream()) {
            this.stream(context, callbackMessage);
        } else {
            this.noStream(context, callbackMessage);
        }
    }

    private void stream(Context context, ChatCallbackMessage callbackMessage) {
        String endFlag;
        List<Skill> flowList = context.getSkillList();
        if (callbackMessage.isEnd()) {
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
        }
        if ((endFlag = FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_END)) != null) {
            return;
        }
        if (StringUtils.isEmpty((String)callbackMessage.getLlmValue())) {
            if (callbackMessage.isEnd()) {
                this.streamEnd(context, callbackMessage);
            }
            return;
        }
        String llmValueOld = FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_RT);
        String llmValue = llmValueOld == null ? callbackMessage.getLlmValue() : llmValueOld + callbackMessage.getLlmValue();
        Object[] result = this.matchSkill(flowList, llmValue);
        int matchStatus = (Integer)result[0];
        if (matchStatus == 2) {
            FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_END, "Y");
            WebSocketService.pushStreamDown(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), "0", callbackMessage.getLlmValue(), "");
            Skill skill = (Skill)result[1];
            WebSocketService.pushWaitingDone(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), context.getChatSessionId());
            log.info("\u6d41\u5f0f\u4e2d\u63a7\u542f\u52a8\u6280\u80fd{}", (Object)skill.getId());
            this.startSkill(context, skill, callbackMessage.getUserInput(), Collections.emptyMap(), false, null);
        } else {
            String llmMessageOld = FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_MESSAGE);
            if (llmMessageOld != null) {
                FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_MESSAGE, llmMessageOld + callbackMessage.getLlmValue());
            } else {
                FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_MESSAGE, callbackMessage.getLlmValue());
            }
            if (matchStatus == -1) {
                String message;
                if (llmValueOld != null) {
                    message = llmValue;
                    FlowCacheData.clearCache(context.getChatSessionId(), LLM_CT_RT);
                } else {
                    message = callbackMessage.getLlmValue();
                }
                WebSocketService.pushStreamChat(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), "0", callbackMessage.getSeqNo(), message, false);
            } else {
                FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_RT, llmValue);
            }
            if (callbackMessage.isEnd()) {
                if (StringUtils.isNotEmpty((String)callbackMessage.getLlmValue())) {
                    WebSocketService.pushStreamChat(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), "0", callbackMessage.getSeqNo(), callbackMessage.getLlmValue(), false);
                }
                this.streamEnd(context, callbackMessage);
            }
        }
    }

    private void noStream(Context context, ChatCallbackMessage callbackMessage) {
        Skill skill = this.getSkillId(context, callbackMessage.getLlmValue());
        if (skill == null) {
            WebSocketService.pushChat(null, context.getAssistantPageId(), callbackMessage.getTaskId(), context.getRootPageId(), context.getGlobalSessionId(), context.getChatSessionId(), callbackMessage.getLlmValue());
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            MessageService.insertMessage(context.getChatSessionId(), callbackMessage.getLlmValue(), null, null, ChatMessageTypeEnum.ASSISTANT, EnableEnum.YES);
        }
        WebSocketService.pushWaitingDone(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), context.getChatSessionId());
        if (skill == null) {
            return;
        }
        log.info("\u4e2d\u63a7\u542f\u52a8\u6280\u80fd{}", (Object)skill.getId());
        this.startSkill(context, skill, callbackMessage.getUserInput(), Collections.emptyMap(), false, null);
    }

    private void noSkill(Context context, ChatCallbackMessage callbackMessage) {
        if (callbackMessage.isStream() && !callbackMessage.isEnd()) {
            WebSocketService.pushStreamChat(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), "0", callbackMessage.getSeqNo(), callbackMessage.getLlmValue(), false);
        } else if (callbackMessage.isEnd()) {
            if (callbackMessage.isStream()) {
                if (StringUtils.isNotEmpty((String)callbackMessage.getLlmValue())) {
                    WebSocketService.pushStreamChat(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), "0", callbackMessage.getSeqNo(), callbackMessage.getLlmValue(), false);
                }
                this.streamEnd(context, callbackMessage);
            }
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
        }
    }

    private void streamEnd(Context context, ChatCallbackMessage callbackMessage) {
        Message message = MessageService.insertMessage(context.getChatSessionId(), FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_MESSAGE), null, context.getCurrentSkill(), ChatMessageTypeEnum.ASSISTANT, EnableEnum.YES);
        WebSocketService.pushStreamDown(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), "0", "", StrUtils.longAsString(message.getMessageId()));
        WebSocketService.pushWaitingDone(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), context.getChatSessionId());
    }

    public Object[] matchSkill(List<Skill> flowList, String llmValue) {
        int matchStatus = -1;
        Skill matchSkill = null;
        for (Skill skill : flowList) {
            int matchStatusTmp = this.match(llmValue, skill.getId());
            if (matchStatusTmp > matchStatus) {
                matchStatus = matchStatusTmp;
            }
            if (matchStatus != 2) continue;
            matchSkill = skill;
            break;
        }
        return new Object[]{matchStatus, matchSkill};
    }

    public int match(String llmValue, String skillIdStr) {
        if (llmValue.contains(skillIdStr)) {
            return 2;
        }
        int matchIndex = -1;
        int i = 2;
        while (i <= skillIdStr.length() && llmValue.contains(skillIdStr.substring(0, i))) {
            matchIndex = i++;
        }
        if (matchIndex == -1) {
            if (llmValue.startsWith("```")) {
                return 1;
            }
            return -1;
        }
        if (matchIndex == skillIdStr.length()) {
            return 2;
        }
        if (llmValue.endsWith(skillIdStr.substring(0, matchIndex))) {
            return 1;
        }
        return -1;
    }

    private Skill getSkillId(Context context, String llmValue) {
        List<Skill> skillList = context.getSkillList();
        if (skillList == null || skillList.isEmpty()) {
            return null;
        }
        for (Skill skill : skillList) {
            if (!llmValue.contains(skill.getId())) continue;
            return skill;
        }
        return null;
    }

    private Result startSkill(Context context, Skill skill, String userInput, Map<String, String> inParaMap, boolean isUserSelected, Message userMessage) {
        skill.setSkillSrc(isUserSelected ? SkillSrcEnum.USER : SkillSrcEnum.AUTO);
        if (!isUserSelected) {
            WebSocketService.pushIdentifySkill(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), skill.getId());
        }
        context.setCurrentSkill(skill);
        FlowCacheData.putContext(context.getChatSessionId(), context);
        try {
            if (Skill.Type.PROCESS == skill.getType()) {
                return this.startProcess(context, skill, userInput, inParaMap);
            }
            return ChatService.startAgentChat(context, userMessage, null);
        }
        catch (Exception e) {
            ErrorCode errorCode = Errors.startSkillError(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            WebSocketService.pushErrMsg(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), errorCode.getCode(), errorCode.getMessage(), context.getChatSessionId());
            return new Result(errorCode);
        }
    }

    private Result startProcess(Context context, Skill skill, String userInput, Map<String, String> inParaMap) {
        StartFlowMessage startFlowMessage = new StartFlowMessage();
        startFlowMessage.setProcessId(Long.parseLong(skill.getId()));
        startFlowMessage.setChatSessionId(context.getChatSessionId());
        startFlowMessage.setInParams(inParaMap);
        startFlowMessage.setUserInput(userInput);
        return HandlerFactory.runHandler(context, startFlowMessage);
    }
}

