/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.engine.Errors;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HexUtils;

class Decrypt {
    private static final Log log = LogFactory.getLog(Decrypt.class);
    private static final String ERR_CODE = "gai.decrypt.000001";
    private static final String ERR_CODE2 = "gai.decrypt.000002";

    private Decrypt() {
    }

    static void decrypt(Prompt prompt) {
        byte[] decryptData1;
        prompt.setEncrypt(false);
        if (prompt.getPrompt() == null || !Encrypters.isEncrypted((String)prompt.getPrompt())) {
            return;
        }
        Decrypt.checkParameter(prompt);
        byte[] decryptData = HexUtils.fromHex((String)Encrypters.decode((String)prompt.getPrompt()));
        Key key = Decrypt.genKey(prompt);
        try {
            decryptData1 = Decrypt.doDecrypt(key, decryptData);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(Errors.DECRYPT_PROMPT_ERR, new Object[0]);
        }
        prompt.setPrompt(new String(decryptData1, StandardCharsets.UTF_8));
        prompt.setEncrypt(true);
    }

    private static void checkParameter(Prompt prompt) {
        if (prompt == null) {
            throw new KDBizException(new ErrorCode(ERR_CODE, "prompt parameter is null"), new Object[0]);
        }
        if (prompt.getId() == 0L) {
            throw new KDBizException(new ErrorCode(ERR_CODE, "prompt.id parameter is null"), new Object[0]);
        }
        if (prompt.getCreateTime() == null) {
            throw new KDBizException(new ErrorCode(ERR_CODE, "prompt.createTime parameter is null"), new Object[0]);
        }
        if (prompt.getPrompt() == null) {
            throw new KDBizException(new ErrorCode(ERR_CODE, "prompt.Prompt parameter is null"), new Object[0]);
        }
    }

    private static Key genKey(Prompt prompt) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String s2 = prompt.getCreateTime() == null ? "null" : simpleDateFormat.format(prompt.getCreateTime());
        String k = String.format("%s-%s", prompt.getId(), s2);
        byte[] data = Hashing.sha512().hashString((CharSequence)k, StandardCharsets.UTF_8).asBytes();
        byte[] aesKeyBytes = new byte[32];
        System.arraycopy(data, 0, aesKeyBytes, 0, aesKeyBytes.length);
        return new SecretKeySpec(aesKeyBytes, "AES");
    }

    private static byte[] doDecrypt(Key key, byte[] encrypted) throws NoSuchPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] iv = new byte[16];
        byte[] data = new byte[encrypted.length - 16];
        System.arraycopy(encrypted, 0, iv, 0, 16);
        System.arraycopy(encrypted, 16, data, 0, data.length);
        GCMParameterSpec ivParameterSpec = new GCMParameterSpec(128, iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, key, ivParameterSpec);
        return cipher.doFinal(data);
    }
}

