/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.handler.SendMessage;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FlowErrorHandler
implements IMessageHandler<FlowErrorMessage> {
    private static final Log log = LogFactory.getLog(FlowNextHandler.class);

    @Override
    public Result process(Context context, FlowErrorMessage message) {
        long flowId = message.getFlowId();
        ErrorCode errorCode = message.getErrorCode();
        log.error("flow {} run error {} : {}", new Object[]{flowId, errorCode.getCode(), errorCode.getMessage()});
        if (Errors.FAKE_OK.equals((Object)errorCode)) {
            SendMessage.sendFakeOkMsg(context, message.getMsg());
            FlowNextHandler.endFlow(context, flowId, true, errorCode);
            return new Result(Errors.OK);
        }
        SendMessage.sendErr(context, errorCode);
        FlowNextHandler.endFlow(context, flowId, true, errorCode);
        return new Result(errorCode);
    }
}

