/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.gai.core.domain.dto.Operation;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.engine.ActionCallbackMessage;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Condition;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.handler.StopStreamHandler;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.EndFlowMessage;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.engine.message.FlowNextMessage;
import kd.ai.gai.core.engine.message.JavaActionMessage;
import kd.ai.gai.core.engine.message.LLMActionMessage;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.enuz.OperationType;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.OperationService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.ScriptEngine;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class FlowNextHandler
implements IMessageHandler<FlowNextMessage> {
    private static final Log log = LogFactory.getLog(FlowNextHandler.class);
    private static final int USER_HISTORY_COUNT = 200;
    private static final String VAR_PREFIX = "__GAI_V_";
    private static final char SPACE = ' ';

    @Override
    public Result process(Context context, FlowNextMessage message) {
        log.info("next message\uff1a{} ", (Object)JsonUtil.toJson(message));
        if (StopStreamHandler.isStopped(context.getChatSessionId(), message.getFlowId())) {
            log.warn("flow {} is stopped.", (Object)message.getFlowId());
            return FlowNextHandler.endFlow(context, message.getFlowId(), false, null);
        }
        Flow flow = FlowCacheData.getFlowById(message.getChatSessionId(), message.getFlowId());
        if (flow == null) {
            log.warn("\u6d41\u7a0b\u3010{}\u3011\u5b9e\u4f8b\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u7ed3\u675f\u3002 ", (Object)message.getFlowId());
            return FlowNextHandler.endFlow(context, message.getFlowId(), true, Errors.flowInstanceNotExisted(message.getFlowId()));
        }
        Node nextNode = this.nextNode(context, flow, message.getPreNodeId());
        if (nextNode == null || nextNode.getId() == flow.getEnd().getId()) {
            return FlowNextHandler.endFlow(context, flow.getId(), false, null);
        }
        log.info("next node\uff1a{} ", (Object)JsonUtil.toJson(nextNode));
        Action nextAction = (Action)nextNode;
        Message actionMessage = this.buildMessage(context, flow, nextAction);
        try {
            log.info("\u5f00\u59cb\u6267\u884cAction:{}", (Object)JsonUtil.toJson(actionMessage));
            long start = System.currentTimeMillis();
            Result result = HandlerFactory.runHandler(context, actionMessage);
            long end = System.currentTimeMillis();
            log.info("\u5b8c\u6210Action:{},result:{}", (Object)JsonUtil.toJson(actionMessage), (Object)JsonUtil.toJson(result));
            TraceUtil.saveFlowNodeLog(result, context, flow, nextNode, actionMessage, nextAction, start, end, result.getData());
            if (result.getStatus() == Result.Status.END) {
                return result;
            }
            if (!result.getErrorCode().equals((Object)Errors.OK)) {
                if (result.getErrorCode().equals((Object)Errors.FAKE_OK)) {
                    return FlowNextHandler.flowEnd(context, flow.getId(), result.getErrorCode(), result.getErrorCode().getMessage());
                }
                return FlowNextHandler.flowError(context, flow.getId(), result.getErrorCode());
            }
            if (result.isCallback()) {
                return result;
            }
        }
        catch (Exception exp) {
            log.error(String.format("\u6267\u884c\u6d88\u606f{%s}\u53d1\u751f\u5f02\u5e38", JsonUtil.toJson(actionMessage)), (Throwable)exp);
            ErrorCode errorCode = FlowNextHandler.getErrorCode(exp);
            return FlowNextHandler.flowError(context, flow.getId(), errorCode);
        }
        return FlowNextHandler.next(context, message.getFlowId(), nextNode.getId());
    }

    public Node nextNode(Context context, Flow flow, int nodeId) {
        if (nodeId == flow.getEnd().getId()) {
            return null;
        }
        Node node = flow.findNodeById(nodeId);
        if (node.getTransferOutList() == null || node.getTransferOutList().isEmpty()) {
            throw new KDBizException(Errors.flowDefineError(node.getDesc()), new Object[0]);
        }
        ArrayList<Transfer> noConditionTransfers = new ArrayList<Transfer>(2);
        for (int transferId : node.getTransferOutList()) {
            Transfer transfer = flow.findTransferById(transferId);
            Condition condition = transfer.getCondition();
            if (condition == null || condition.getConditionRows() == null || condition.getConditionRows().isEmpty()) {
                noConditionTransfers.add(transfer);
                continue;
            }
            if (!this.execCondition(context, flow, condition)) continue;
            return flow.findNodeById(transfer.getToNodeId());
        }
        if (!noConditionTransfers.isEmpty()) {
            Transfer transfer = (Transfer)noConditionTransfers.get(0);
            return flow.findNodeById(transfer.getToNodeId());
        }
        throw new KDBizException(Errors.flowRunError(flow.getNumber() + " : " + flow.getName()), new Object[0]);
    }

    public boolean execCondition(Context context, Flow flow, Condition condition) {
        HashMap<String, String> varMap = new HashMap<String, String>();
        HashMap<String, Object> scriptCtx = new HashMap<String, Object>();
        AtomicInteger varIndex = new AtomicInteger();
        StringBuilder script = new StringBuilder();
        for (Condition.Row row : condition.getConditionRows()) {
            if (!row.check()) {
                throw new KDBizException(Errors.conditionConfigError(condition.getName()), new Object[0]);
            }
            String leftVarName = String.format("%s.%s", row.getLeftNodeId(), row.getLeftVarName());
            String varAlias = varMap.computeIfAbsent(leftVarName, k -> VAR_PREFIX + varIndex.getAndIncrement());
            String varValueLeft = this.getVarValue(context.getChatSessionId(), flow.getId(), row.getLeftNodeId(), row.getLeftVarName());
            scriptCtx.computeIfAbsent(varAlias, k -> varValueLeft);
            if (script.length() > 0) {
                script.append(" && ");
            }
            script.append(varAlias).append(' ').append((Object)row.getOperator()).append(' ');
            if (Condition.Operator.ISNOTNULL == row.getOperator() || Condition.Operator.ISNULL == row.getOperator()) continue;
            if (Condition.ValueType.TEXT == row.getValueType()) {
                script.append(' ').append('\"').append(row.getText()).append('\"').append(' ');
                continue;
            }
            String rightVarName = String.format("%s.%s", row.getRightNodeId(), row.getRightVarName());
            varAlias = varMap.computeIfAbsent(rightVarName, k -> VAR_PREFIX + varIndex.getAndIncrement());
            String varValueRight = this.getVarValue(context.getChatSessionId(), flow.getId(), row.getRightNodeId(), row.getRightVarName());
            scriptCtx.computeIfAbsent(varAlias, k -> varValueRight);
            script.append(' ').append(varAlias).append(' ');
        }
        return (Boolean)ScriptEngine.getEngine().runScript(script.toString(), scriptCtx);
    }

    private Map<String, String> buildInputData(Context context, Flow flow, Action action) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (action.getInParamMap() != null) {
            for (VarMapper varMapper : action.getInParamMap()) {
                if ("system.chat_history".equals(varMapper.getOutVarName())) {
                    UserHistoryMessage[] userHistoryMessage = ChatHistoryService.getByChatSessionId(200, context.getChatSessionId());
                    data.put(varMapper.getInVarName(), JsonUtil.toJson(userHistoryMessage));
                    continue;
                }
                if ("system.chat_sessionid".equals(varMapper.getOutVarName())) {
                    data.put(varMapper.getInVarName(), context.getChatSessionId());
                    continue;
                }
                String outVarName = varMapper.getOutVarName();
                if ("user_input".equals(outVarName)) {
                    outVarName = "system.user_input";
                }
                data.put(varMapper.getInVarName(), this.getVarValue(context.getChatSessionId(), flow.getId(), varMapper.getOutNodeId(), outVarName));
            }
        } else {
            log.warn("action {} \u6ca1\u6709\u914d\u7f6e\u8f93\u5165\u53c2\u6570\u7684\u503c\u6620\u5c04\u5173\u7cfb\u3002");
        }
        if (action instanceof JavaPluginAction) {
            data.put("PAGE_ID", context.getBizPageId());
            data.put("ROOT_PAGE_ID", context.getRootPageId());
        }
        return data;
    }

    private String getVarValue(String chatSessionId, long flowId, int outNodeId, String outVarName) {
        Map<String, String> outDataMap = FlowCacheData.getFlowNodeData(chatSessionId, flowId, outNodeId);
        return outDataMap.get(outVarName);
    }

    private Message buildMessage(Context context, Flow flow, Action action) {
        if (action instanceof JavaPluginAction) {
            JavaActionMessage message = this.buildJavaActionMessage(context, flow, (JavaPluginAction)action);
            message.setParams(this.buildInputData(context, flow, action));
            return message;
        }
        if (action instanceof LLMAction) {
            LLMActionMessage message = this.buildLLMActionMessage(context, flow, (LLMAction)action);
            message.setParams(this.buildInputData(context, flow, action));
            return message;
        }
        if (action instanceof MessageAction) {
            return this.buildNodeMessage(context, flow, (MessageAction)action);
        }
        throw new KDBizException(Errors.notSupportActionType(action.getClass().getName()), new Object[0]);
    }

    public MsgNodeMessage buildNodeMessage(Context context, Flow flow, MessageAction messageAction) {
        MsgNodeMessage message = new MsgNodeMessage();
        message.setFlowId(flow.getId());
        ArrayList<MsgNodeMessage.MessageElement> elementList = new ArrayList<MsgNodeMessage.MessageElement>(messageAction.getVarList().size());
        block0: for (Var var : messageAction.getVarList()) {
            MsgNodeMessage.MessageElement messageElement = new MsgNodeMessage.MessageElement();
            elementList.add(messageElement);
            messageElement.setType(var.getType());
            if (var.isInput()) {
                messageElement.setValue(var.getValue());
                continue;
            }
            for (VarMapper varMapper : messageAction.getInParamMap()) {
                if (!varMapper.getInVarName().equals(var.getName())) continue;
                messageElement.setValue(this.getVarValue(context.getChatSessionId(), flow.getId(), varMapper.getOutNodeId(), varMapper.getOutVarName()));
                continue block0;
            }
        }
        message.setElementList(elementList);
        message.setReplaceLastMessage(messageAction.isReplaceLastMessage());
        return message;
    }

    public JavaActionMessage buildJavaActionMessage(Context context, Flow flow, JavaPluginAction javaPluginAction) {
        JavaActionMessage message = new JavaActionMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setPageId(context.getBizPageId());
        message.setFlowId(flow.getId());
        message.setNodeId(javaPluginAction.getId());
        Operation operation = OperationService.getOperationById(javaPluginAction.getActionId());
        if (operation == null) {
            throw new KDBizException(Errors.operationNotExistedError(String.valueOf(javaPluginAction.getActionId())), new Object[0]);
        }
        message.setAppId(operation.getAppid());
        message.setClassName(operation.getServiceName());
        message.setActionName(operation.getAction());
        message.setFrontOperation(operation.getOperationType() == OperationType.Client);
        return message;
    }

    public LLMActionMessage buildLLMActionMessage(Context context, Flow flow, LLMAction llmAction) {
        String repoIDStr;
        LLMActionMessage message = new LLMActionMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(llmAction.getId());
        message.setStream(llmAction.isStream());
        message.setPromptId(llmAction.getLlmPromptId());
        VarMapper repoMapper = llmAction.getRepoMapper();
        if (repoMapper != null && StringUtils.isNotEmpty((String)(repoIDStr = this.getVarValue(context.getChatSessionId(), flow.getId(), repoMapper.getOutNodeId(), repoMapper.getOutVarName())))) {
            String[] idArray = repoIDStr.split(",");
            ArrayList<Long> repoIdList = new ArrayList<Long>(idArray.length);
            for (String idStr : idArray) {
                repoIdList.add(Long.parseLong(idStr.trim()));
            }
            message.setRepoIdList(repoIdList);
        }
        message.setUserInput(this.getUserInput(context, flow, llmAction));
        message.setMergeLastMessageCard(llmAction.isMergeLastMessageCard());
        return message;
    }

    public String getUserInput(Context context, Flow flow, LLMAction llmAction) {
        Map<String, String> inputMap = FlowCacheData.getFlowNodeData(context.getChatSessionId(), flow.getId(), flow.getStart().getId());
        String userInput = llmAction.getUserInputMapper() != null ? this.getVarValue(context.getChatSessionId(), flow.getId(), llmAction.getUserInputMapper().getOutNodeId(), llmAction.getUserInputMapper().getOutVarName()) : inputMap.get("system.user_input");
        if (StringUtils.isEmpty((String)userInput)) {
            userInput = "";
        }
        return userInput;
    }

    public static Result endFlow(Context context, long flowId, boolean isError, ErrorCode errorCode) {
        EndFlowMessage endFlowMessage = new EndFlowMessage();
        endFlowMessage.setFlowId(flowId);
        endFlowMessage.setError(isError);
        endFlowMessage.setErrorCode(errorCode);
        log.info("\u6d41\u7a0b\u7ed3\u675f\uff1a{}", (Object)JsonUtil.toJson(endFlowMessage));
        return HandlerFactory.runHandler(context, endFlowMessage);
    }

    public static void callBack(ActionCallbackMessage callbackMessage) {
        Context context = FlowCacheData.getContext(callbackMessage.getChatSessionId());
        if (context == null) {
            throw new KDBizException(Errors.getFlowContextIsNull(String.format("chat sessionid:%s flowId:%s", callbackMessage.getChatSessionId(), callbackMessage.getFlowId())), new Object[0]);
        }
        FlowNextHandler.next(context, callbackMessage.getFlowId(), callbackMessage.getNodeId());
    }

    public static Result next(Context context, long flowId, int preNodeId) {
        if (StopStreamHandler.isStopped(context.getChatSessionId(), flowId)) {
            log.warn("flow {} is stopped.", (Object)flowId);
            return new Result(Errors.OK);
        }
        FlowNextMessage nextMessage = new FlowNextMessage();
        nextMessage.setChatSessionId(context.getChatSessionId());
        nextMessage.setFlowId(flowId);
        nextMessage.setPreNodeId(preNodeId);
        try {
            return HandlerFactory.runHandler(context, nextMessage);
        }
        catch (Exception exp) {
            log.error(exp.getMessage(), (Throwable)exp);
            ErrorCode errorCode = FlowNextHandler.getErrorCode(exp);
            return FlowNextHandler.flowError(context, flowId, errorCode);
        }
    }

    public static Result flowError(Context context, long flowId, ErrorCode errorCode) {
        FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
        flowErrorMessage.setFlowId(flowId);
        flowErrorMessage.setErrorCode(errorCode);
        log.info("flow error {}", (Object)JsonUtil.toJson(flowErrorMessage));
        return HandlerFactory.runHandler(context, flowErrorMessage);
    }

    public static Result flowEnd(Context context, long flowId, ErrorCode errorCode, String msg) {
        FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
        flowErrorMessage.setFlowId(flowId);
        flowErrorMessage.setErrorCode(errorCode);
        flowErrorMessage.setMsg(msg);
        log.info("flow end {}", (Object)JsonUtil.toJson(flowErrorMessage));
        return HandlerFactory.runHandler(context, flowErrorMessage);
    }

    public static ErrorCode getErrorCode(Exception exp) {
        ErrorCode errorCode = null;
        if (exp instanceof KDBizException) {
            errorCode = ((KDBizException)((Object)exp)).getErrorCode();
        }
        if (errorCode == null || StringUtils.isEmpty((String)errorCode.getCode())) {
            errorCode = Errors.internalError(exp.getMessage());
        }
        return errorCode;
    }
}

