/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.KnowledgeCitationData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.engine.message.LLMActionMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMActionCallbackMessage;
import kd.ai.gai.core.enuz.AttType;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.service.FilePreviewService;
import kd.ai.gai.core.service.WebSocketService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.context.RequestContext;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class LLMActionHandler
implements IMessageHandler<LLMActionMessage>,
IActionCallBack<LLMActionCallbackMessage> {
    private static final Log log = LogFactory.getLog(LLMActionHandler.class);

    @Override
    public Result process(Context context, LLMActionMessage message) {
        LLMActionCallbackMessage callbackMessage = new LLMActionCallbackMessage();
        callbackMessage.setParseOutput(true);
        callbackMessage.setFlowId(message.getFlowId());
        callbackMessage.setNodeId(message.getNodeId());
        callbackMessage.setPageId(context.getAssistantPageId());
        callbackMessage.setChatSessionId(context.getChatSessionId());
        callbackMessage.setGlobalSessionId(context.getGlobalSessionId());
        callbackMessage.setMergeLastMessageCard(message.isMergeLastMessageCard());
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(callbackMessage);
        llmMessage.setUserInput(message.getUserInput());
        llmMessage.setPromptId(message.getPromptId());
        llmMessage.setRepoIdList(message.getRepoIdList());
        llmMessage.setStream(message.isStream());
        llmMessage.setParamMap(message.getParams());
        Result result = HandlerFactory.runHandler(context, llmMessage);
        result.setCallback(true);
        return result;
    }

    @Override
    public void callback(LLMActionCallbackMessage callbackMessage) {
        String chatSessionId = callbackMessage.getChatSessionId();
        Context context = FlowCacheData.getContext(chatSessionId);
        String errCode = callbackMessage.getErrCode();
        if (StringUtils.isEmpty((String)errCode) || !errCode.equals(Errors.OK.getCode())) {
            errCode = StringUtils.isEmpty((String)errCode) ? Errors.LLM_ERROR.getCode() : errCode;
            log.error("\u56de\u8c03\u9519\u8bef", (Object)callbackMessage);
            FlowErrorMessage message = new FlowErrorMessage();
            message.setErrorCode(new ErrorCode(errCode, "\u5927\u8bed\u8a00\u6a21\u578b\u51fa\u9519\uff1a" + callbackMessage.getErrMsg()));
            message.setFlowId(callbackMessage.getFlowId());
            message.setChatSessionId(callbackMessage.getChatSessionId());
            HandlerFactory.runHandler(FlowCacheData.getContext(callbackMessage.getChatSessionId()), message);
            TraceUtil.saveAsyncLLMLog(context, callbackMessage);
            return;
        }
        String llmValue = callbackMessage.getLlmValue();
        if (callbackMessage.isStream() && !callbackMessage.isEnd()) {
            WebSocketService.pushStreamChat(null, callbackMessage.getPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmValue, callbackMessage.isMergeLastMessageCard());
        } else if (callbackMessage.isEnd()) {
            if (callbackMessage.isStream()) {
                if (StringUtils.isNotEmpty((String)llmValue)) {
                    WebSocketService.pushStreamChat(null, callbackMessage.getPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmValue, callbackMessage.isMergeLastMessageCard());
                }
                SLIDEENV slideenv = context.getSlideenv();
                HashMap<String, Boolean> tagMap = new HashMap<String, Boolean>(3);
                tagMap.put("replaceLast", false);
                tagMap.put("concatLast", callbackMessage.isMergeLastMessageCard());
                IAppCache appCache = EngineCache.getAppCache(chatSessionId);
                String msgContent = (String)appCache.get("streamBuffer" + callbackMessage.getTaskId(), String.class);
                msgContent = (msgContent == null ? "" : msgContent) + (llmValue == null ? "" : llmValue);
                Message message = MessageService.insertMessage(context.getChatSessionId(), msgContent, JSON.toJSONString(tagMap), context.getCurrentSkill(), ChatMessageTypeEnum.ASSISTANT, slideenv == SLIDEENV.MAIN ? EnableEnum.YES : EnableEnum.NO);
                WebSocketService.pushStreamDown(null, callbackMessage.getPageId(), context.getRootPageId(), context.getGlobalSessionId(), chatSessionId, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", llmValue, StrUtils.longAsString(message.getMessageId()));
                List<KnowledgeCitationData> citationInfos = callbackMessage.getCitationInfos();
                LLMActionHandler.sendChatBottomMsg(context, null, callbackMessage.getPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", "\u53c2\u8003\u6587\u4ef6", citationInfos);
            }
            if (callbackMessage.getJsonValue() != null && !callbackMessage.getJsonValue().isEmpty()) {
                FlowCacheData.setFlowNodeData(callbackMessage.getChatSessionId(), callbackMessage.getFlowId(), callbackMessage.getNodeId(), callbackMessage.getJsonValue());
            } else {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("prompt_output", llmValue);
                data.put("reference_output", JsonUtil.toJson(callbackMessage.getCitationInfos()));
                FlowCacheData.setFlowNodeData(callbackMessage.getChatSessionId(), callbackMessage.getFlowId(), callbackMessage.getNodeId(), data);
            }
            TraceUtil.saveAsyncLLMLog(context, callbackMessage);
            FlowNextHandler.callBack(callbackMessage);
        }
    }

    public static void sendChatBottomMsg(Context context, String k, String pageId, String rootPageId, String globalSessionId, String chatSessionId, String taskId, String flowId, String title, List<KnowledgeCitationData> knowledgeCitationData) {
        if (knowledgeCitationData == null || knowledgeCitationData.isEmpty()) {
            return;
        }
        StringBuilder logMsgBuilder = new StringBuilder();
        ArrayList<ContextData.Item> webItems = new ArrayList<ContextData.Item>(knowledgeCitationData.size());
        for (KnowledgeCitationData citationData : knowledgeCitationData) {
            String previewPath;
            String citationTitle = citationData.getTitle();
            String source = citationData.getSource();
            String linkUrl = citationData.getLinkUrl();
            long fileId = citationData.getFileId();
            int order = citationData.getOrder();
            logMsgBuilder.append("[gairepodoc]");
            logMsgBuilder.append(fileId);
            logMsgBuilder.append("[/gairepodoc]");
            ContextData.Item item = null;
            RequestContext rc = RequestContext.get();
            if ("doc".equals(source)) {
                previewPath = FilePreviewService.getPreviewUrl(linkUrl);
                previewPath = String.format("%s%s%s", previewPath, previewPath.contains("?") ? "&kdcdc=" : "?kdcdc=", rc.getAccountId());
                item = new ContextData.Item(AttType.document, citationTitle, previewPath, order);
                webItems.add(item);
            } else if ("code".equals(source)) {
                previewPath = FilePreviewService.getPreviewUrl(linkUrl);
                previewPath = String.format("%s%s%s", previewPath, previewPath.contains("?") ? "&kdcdc=" : "?kdcdc=", rc.getAccountId());
                item = new ContextData.Item(AttType.code, citationTitle, previewPath, order);
            } else {
                String url = linkUrl;
                boolean isNextCloud = url.startsWith("{domainContextUrl}");
                if (isNextCloud) {
                    String domainContextUrl = UrlService.getDomainContextUrl();
                    url = url.replaceFirst("\\{domainContextUrl\\}", domainContextUrl);
                }
                item = new ContextData.Item(AttType.knowledge, citationTitle, url, order);
            }
            webItems.add(item);
        }
        ContextData contextData = new ContextData(chatSessionId, taskId, flowId + "", title, webItems);
        Assistant assistant = context.getAssistant();
        Long assId = context.getAssistant() == null ? 0L : assistant.getId();
        SLIDEENV assistantDevice = context.getSlideenv();
        Message message = MessageService.insertMessage(chatSessionId, logMsgBuilder.toString(), null, context.getCurrentSkill(), ChatMessageTypeEnum.PROCESS, assistantDevice == SLIDEENV.MAIN ? EnableEnum.YES : EnableEnum.NO);
        contextData.setMessageId(StrUtils.longAsString(message.getMessageId()));
        WebSocketService.pushChatBottom(k, pageId, rootPageId, globalSessionId, contextData);
    }
}

