/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.ChatItem;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.PromptOutVar;
import kd.ai.gai.core.domain.dto.TrustLayerContext;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.vo.APIReferenceData;
import kd.ai.gai.core.domain.vo.KnowledgeCitationData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.handler.Decrypt;
import kd.ai.gai.core.engine.handler.StopStreamHandler;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMRawMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.OutPreVar;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.helper.KnowledgeCitationHelper;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.LlmServiceFactory;
import kd.ai.gai.core.service.PromptService;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.trace.entity.PromptLog;
import kd.ai.gai.core.trace.entity.VectorRetrieverLog;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LLMHandler
implements IMessageHandler<LLMMessage>,
IActionCallBack<LLMRawMessage> {
    private static final Log logger = LogFactory.getLog(LLMHandler.class);

    @Override
    public void callback(LLMRawMessage result) {
        String taskId = String.valueOf(result.getId());
        IAppCache taskCache = EngineCache.getAppCache(taskId);
        String stopStreamStr = (String)taskCache.get("stop_stream" + taskId, String.class);
        if ("TRUE".equals(stopStreamStr) || "stopped".equals(result.getStatus())) {
            logger.info("task : {} is stopped.", (Object)taskId);
            return;
        }
        String llmParsedMessageString = (String)taskCache.get("llmTask" + taskId, String.class);
        logger.info("GAI \u5f02\u6b65\u8c03\u7528\u56de\u8c03\u7f13\u5b58\u83b7\u53d6\uff0ctaskId({}),content\uff1a{}", (Object)taskId, (Object)llmParsedMessageString);
        if (StringUtils.isEmpty((CharSequence)llmParsedMessageString)) {
            throw new KDBizException("GAI \u5f02\u6b65\u8c03\u7528\u56de\u8c03\u7f13\u5b58\u83b7\u53d6\u5931\u8d25\u3002");
        }
        LLMParsedMessage llmParsedMessage = JsonUtil.fromJson(llmParsedMessageString, LLMParsedMessage.class);
        String chatSessionId = llmParsedMessage.getChatSessionId();
        if (llmParsedMessage.getFlowId() != 0L && StopStreamHandler.isStopped(chatSessionId, llmParsedMessage.getFlowId())) {
            logger.warn("flow {} is stopped.", (Object)llmParsedMessage.getFlowId());
            StopStreamHandler.stopTask(taskId);
            return;
        }
        logger.info("AICC \u56de\u8c03 LLMHandler {}", JSON.toJSON((Object)result));
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        llmParsedMessage.setTaskId(taskId);
        llmParsedMessage.setErrCode(result.getErrCode());
        llmParsedMessage.setErrMsg(result.getErrMsg());
        if (!Errors.OK.getCode().equals(result.getErrCode())) {
            HandlerFactory.callback(llmParsedMessage);
            logger.info("task : {} is error {} -- {}.", new Object[]{taskId, result.getErrCode(), result.getErrMsg()});
            return;
        }
        try {
            boolean end;
            String msg;
            Prompt prompt = (Prompt)appCache.get("prompt" + taskId, Prompt.class);
            LLM llm = prompt.getLlm();
            boolean stream = result.isStream();
            LlmService helper = LlmServiceFactory.getExecutor(llm, stream);
            if (stream) {
                msg = result.isParsedResult() ? result.getLlmValue() : helper.getResult(stream, result.getResult());
                if (msg != null && msg.equals("")) {
                    return;
                }
                if (msg == null) {
                    end = true;
                    msg = (String)appCache.get("streamBuffer" + taskId, String.class);
                    String streamRepoBuffer = (String)appCache.get("streamRepoBuffer" + taskId, String.class);
                    String allChatMsg = (msg == null ? "" : msg) + (streamRepoBuffer != null ? streamRepoBuffer : "");
                    ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(1, allChatMsg)));
                    msg = StringUtils.isNotEmpty((CharSequence)streamRepoBuffer) ? KnowledgeCitationHelper.getSupKnowledgeIndex(chatSessionId, taskId, prompt.getChunkIdList(), streamRepoBuffer) : "";
                    llmParsedMessage.setSeqNo(result.getStreamSeqNO());
                    List<KnowledgeCitationData> citationInfos = KnowledgeCitationHelper.getCitationInfo(chatSessionId, taskId);
                    logger.info("\u3010\u6d41\u3011\u5927\u6a21\u578b\u6d41\u5f0f\u6d88\u606f\u6c47\u603b\uff1a{}\u3002\r\n\u3002\u641c\u7d22\u51fa\u7684chunkIds\uff1a{} \u3002\u4f7f\u7528\u7684\u77e5\u8bc6\u5e93\u5f15\u7528\u4fe1\u606f\u4e3a{}", new Object[]{allChatMsg, JSON.toJSON(prompt.getChunkIdList()), JSON.toJSON(citationInfos)});
                    llmParsedMessage.setCitationInfos(citationInfos);
                    if (llmParsedMessage.isParseOutput()) {
                        JSONObject jsonObject = GaiUtils.toJson(allChatMsg);
                        if (jsonObject.isEmpty()) {
                            logger.error("json\u89e3\u6790\u5f02\u5e38\uff1a{}", (Object)allChatMsg);
                        }
                        Map<String, String> outMap = jsonObject.isEmpty() ? Collections.singletonMap(OutPreVar.GPT_OUTPUT.getVar(), allChatMsg) : LLMHandler.getPromptJsonMap(allChatMsg, jsonObject, prompt.getPromptOutVarList());
                        llmParsedMessage.setJsonValue(outMap);
                    }
                } else {
                    String streamBuffer;
                    end = false;
                    List<Long> chunkIdList = prompt.getChunkIdList();
                    if (null != chunkIdList && !chunkIdList.isEmpty()) {
                        String streamRepoBuffer = (String)appCache.get("streamRepoBuffer" + taskId, String.class);
                        if (StringUtils.isNotEmpty((CharSequence)streamRepoBuffer)) {
                            if (!msg.contains("########")) {
                                appCache.put("streamRepoBuffer" + taskId, (Object)(streamRepoBuffer + msg));
                                return;
                            }
                            msg = KnowledgeCitationHelper.getSupKnowledgeIndex(chatSessionId, taskId, chunkIdList, streamRepoBuffer + msg);
                            appCache.put("streamRepoBuffer" + taskId, (Object)"");
                        } else if (msg.contains("########")) {
                            appCache.put("streamRepoBuffer" + taskId, (Object)msg);
                            return;
                        }
                    }
                    streamBuffer = null == (streamBuffer = (String)appCache.get("streamBuffer" + taskId, String.class)) ? "" : streamBuffer;
                    appCache.put("streamBuffer" + taskId, (Object)(streamBuffer + msg));
                    llmParsedMessage.setSeqNo(result.getStreamSeqNO());
                }
            } else {
                end = true;
                msg = result.isParsedResult() ? result.getLlmValue() : helper.getResult(stream, result.getResult());
                ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(1, msg)));
                List<Long> chunkIdList = prompt.getChunkIdList();
                chunkIdList = LlmServiceFactory.getExecutor(LLM.BAIDU_ERNIE_BOT, true).filterContext(msg, chunkIdList);
                logger.info("\u3010\u975e\u6d41\u3011\u4f7f\u7528\u7684\u77e5\u8bc6\u5e93\u5757\u4fe1\u606f\uff1a{}\u3002", JSON.toJSON(chunkIdList));
                msg = KnowledgeCitationHelper.getSupKnowledgeIndex(chatSessionId, taskId, chunkIdList, msg);
                List<KnowledgeCitationData> citationInfos = KnowledgeCitationHelper.getCitationInfo(chatSessionId, taskId);
                llmParsedMessage.setCitationInfos(citationInfos);
                if (llmParsedMessage.isParseOutput()) {
                    JSONObject jsonObject = GaiUtils.toJson(msg);
                    if (jsonObject.isEmpty()) {
                        logger.error("json\u89e3\u6790\u5f02\u5e38\uff1a{}", (Object)msg);
                    }
                    Map<String, String> outMap = jsonObject.isEmpty() ? Collections.singletonMap(OutPreVar.GPT_OUTPUT.getVar(), msg) : LLMHandler.getPromptJsonMap(msg, jsonObject, prompt.getPromptOutVarList());
                    llmParsedMessage.setJsonValue(outMap);
                }
            }
            llmParsedMessage.setStream(stream);
            llmParsedMessage.setEnd(end);
            llmParsedMessage.setLlmValue(msg);
        }
        catch (Exception e) {
            logger.error("gai LLM callback \u5f02\u6b65\u8c03\u7528\u51fa\u9519\u3002", (Throwable)e);
            if (e instanceof KDBizException) {
                String errCode = ((KDBizException)((Object)e)).getErrorCode().getCode();
                errCode = StringUtils.isEmpty((CharSequence)errCode) ? Errors.LLM_ERROR.getCode() : errCode;
                llmParsedMessage.setErrCode(errCode);
            } else {
                llmParsedMessage.setErrCode(Errors.LLM_ERROR.getCode());
            }
            llmParsedMessage.setErrMsg(e.getMessage());
        }
        HandlerFactory.callback(llmParsedMessage);
    }

    @Override
    public Result process(Context context, LLMMessage message) {
        Result2User result2User;
        logger.info("gai\u8017\u65f6\u8bb0\u5f55 1.process ");
        String chatSessionId = context.getChatSessionId();
        Prompt prompt = message.getPrompt();
        Result result = new Result();
        if (message.getPrompt() == null) {
            long promptId = message.getPromptId();
            prompt = PromptService.getById(promptId);
            if (message.getRepoIdList() != null && !message.getRepoIdList().isEmpty()) {
                HashSet<Long> allRepoSet = new HashSet<Long>(message.getRepoIdList());
                if (prompt.getRepoIds() != null) {
                    allRepoSet.addAll(prompt.getRepoIds());
                }
                logger.info("\u5408\u5e76\u77e5\u8bc6\u5e93\uff0c\u539f\u6765\uff1a{}\uff0c\u4f20\u9012{},\u7ed3\u679c{}", new Object[]{prompt.getRepoIds(), message.getRepoIdList(), allRepoSet});
                prompt.setRepoIds(new ArrayList<Long>(allRepoSet));
            }
        }
        if (Context.needCheckLicense(context)) {
            try {
                GPTLicenseHelper.checkLic("gai_prompt", prompt.getId());
                if (prompt.getRepoIds() != null && prompt.getRepoIds().size() > 0) {
                    GPTLicenseHelper.checkLic("ai_gai_reporag", 0L);
                }
            }
            catch (KDBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                result.setErrorCode(e.getErrorCode());
                return result;
            }
        }
        Decrypt.decrypt(prompt);
        List<UserHistoryMessage> history = ChatHistoryService.getPromptHistory(chatSessionId, prompt.getRemembercount(), prompt.getId());
        boolean sync = message.isSync();
        long start = System.currentTimeMillis();
        long traceId = TraceUtil.buildTraceId(context, message);
        if (sync) {
            result2User = LlmService.syncGpt(prompt, message.getParamMap(), history, message.getUserInput(), chatSessionId, traceId, message.getUseKnowledgeTopK());
            long end = System.currentTimeMillis();
            String content = result2User.getContent();
            ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(0, message.getUserInput())));
            ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(1, content)));
            String taskId = result2User.getTaskId();
            content = KnowledgeCitationHelper.getSupKnowledgeIndex(chatSessionId, taskId, prompt.getChunkIdList(), content);
            List<KnowledgeCitationData> citationInfos = KnowledgeCitationHelper.getCitationInfo(chatSessionId, taskId);
            List<APIReferenceData> apiReferenceData = KnowledgeCitationHelper.boxCitationInfoToAPIService(citationInfos);
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("taskId", taskId);
            data.put("llmValue", content);
            data.put("referenceInfos", SerializationUtils.toJsonString(apiReferenceData));
            result.setData(data);
            TraceUtil.saveSyncLLMLog(result2User.getTaskId(), context, message, content, prompt, traceId, start, end, result2User.getCode());
        } else {
            result2User = LlmService.doAsyncGpt(message.isStream(), prompt, message.getParamMap(), history, message.getUserInput(), chatSessionId, message.getCallbackMessage(), traceId, message.getUseKnowledgeTopK());
            String taskId = result2User.getTaskId();
            LLMParsedMessage callbackMessage = message.getCallbackMessage();
            callbackMessage.setChatSessionId(chatSessionId);
            IAppCache taskCache = EngineCache.getAppCache(taskId);
            taskCache.put("llmTask" + taskId, (Object)JsonUtil.messageToJson(callbackMessage));
            taskCache.put("MsgSplit.LLM" + taskId, (Object)prompt.getLlm().getNumber());
            logger.info("GAI \u5f02\u6b65\u8c03\u7528\u56de\u8c03\u7f13\u5b58\uff0ctaskId({}),content\uff1a{}", (Object)taskId, (Object)JsonUtil.messageToJson(callbackMessage));
            EngineCache.getAppCache(chatSessionId).put("prompt" + taskId, (Object)prompt);
            ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(0, message.getUserInput())));
            TrustLayerContext trustLayerContext = result2User.getTrustLayerContext();
            if (trustLayerContext != null && trustLayerContext.getMaskingInfoList() != null && !trustLayerContext.getMaskingInfoList().isEmpty()) {
                taskCache.put("TrustLayer.MaskingContext" + taskId, (Object)JSON.toJSONString((Object)trustLayerContext));
                taskCache.put("MsgSplit.Enable" + taskId, (Object)"true");
            }
            List<Chunk> chunkList = result2User.getChunkList();
            long beforeChunk = result2User.getBeforeChunk();
            long endChunk = result2User.getEndChunk();
            VectorRetrieverLog vectorRetrieverLog = new VectorRetrieverLog(chatSessionId, traceId, message.getUserInput(), JSON.toJSONString(chunkList), callbackMessage, prompt, beforeChunk, endChunk);
            LLM llm = prompt.getLlm();
            String llmNumber = llm.getNumber();
            String llmParamString = result2User.getLlmParamString();
            PromptLog promptLog = new PromptLog(taskId, chatSessionId, traceId, llmNumber, JSON.toJSONString(chunkList), llmParamString, callbackMessage, prompt, endChunk, start);
            TraceUtil.saveTraceVectorAndPromptLog(chatSessionId, traceId, vectorRetrieverLog, promptLog);
            TraceUtil.endLLMLog(taskId, traceId, System.currentTimeMillis());
            result.setTaskId(taskId);
        }
        result.setErrorCode(new ErrorCode(result2User.getCode(), result2User.getErrMsg()));
        logger.info("gai\u8017\u65f6\u8bb0\u5f55 2.process done ");
        return result;
    }

    private static Map<String, String> getPromptJsonMap(String origin, JSONObject jsonObject, List<PromptOutVar> promptOutVarList) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (promptOutVarList == null || promptOutVarList.isEmpty()) {
            throw new KDBizException("\u8bf7\u68c0\u67e5prompt\u4e2d\u63d0\u793a\u8f93\u51fa\u53c2\u6570\u914d\u7f6e.");
        }
        for (PromptOutVar promptOutVar : promptOutVarList) {
            if (promptOutVar.getVar().equals(OutPreVar.GPT_OUTPUT.getVar())) {
                if (promptOutVar.getJsonAnalysis()) {
                    if (jsonObject.isEmpty()) {
                        throw new KDBizException("json\u63d0\u53d6\u5f02\u5e38\uff1a" + origin);
                    }
                    result.put(OutPreVar.GPT_OUTPUT.getVar(), jsonObject.toJSONString());
                    continue;
                }
                result.put(OutPreVar.GPT_OUTPUT.getVar(), origin);
                continue;
            }
            result.put(promptOutVar.getVar(), jsonObject.getString(promptOutVar.getVar()));
        }
        return result;
    }
}

