/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.handler.StopStreamHandler;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.service.WebSocketService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MessageHandler
implements IMessageHandler<MsgNodeMessage> {
    private static final Log log = LogFactory.getLog(MessageHandler.class);

    @Override
    public Result process(Context context, MsgNodeMessage message) {
        if (StopStreamHandler.isStopped(context.getChatSessionId(), message.getFlowId())) {
            log.warn("flow {} is stopped.", (Object)message.getFlowId());
            return new Result(Errors.OK);
        }
        List<MsgNodeMessage.MessageElement> messageElementList = message.getElementList();
        StringBuilder inputBuilder = new StringBuilder();
        for (MsgNodeMessage.MessageElement item : messageElementList) {
            if (item.getType().equals(MessageType.Text.getValue())) {
                inputBuilder.append(item.getValue()).append(" \r\n");
                continue;
            }
            if (item.getType().equals(MessageType.HyperLink.getValue())) {
                inputBuilder.append("[gaiurl]<urlhref>").append(item.getValue()).append("</urlhref>[/gaiurl]");
                continue;
            }
            if (item.getType().equals(MessageType.Iframe.getValue())) {
                inputBuilder.append("[gaiiframe]").append(item.getValue()).append("[/gaiiframe]");
                continue;
            }
            if (!item.getType().equals(MessageType.Picture.getValue())) continue;
            inputBuilder.append("[gaiimgurl]").append(item.getValue()).append("[/gaiimgurl]");
        }
        Assistant assistant = context.getAssistant();
        Long assId = context.getAssistant() == null ? 0L : assistant.getId();
        SLIDEENV assistantDevice = context.getSlideenv();
        HashMap<String, Boolean> tagMap = new HashMap<String, Boolean>();
        tagMap.put("replaceLast", message.isReplaceLastMessage());
        tagMap.put("concatLast", false);
        Message chatMessage = MessageService.insertMessage(context.getChatSessionId(), inputBuilder.toString(), JSON.toJSONString(tagMap), context.getCurrentSkill(), ChatMessageTypeEnum.PROCESS, assistantDevice == SLIDEENV.MAIN ? EnableEnum.YES : EnableEnum.NO);
        WebSocketService.pushMultiMsg(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), context.getChatSessionId(), message.isReplaceLastMessage(), messageElementList, StrUtils.longAsString(chatMessage.getMessageId()));
        return new Result(Errors.OK);
    }
}

