/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.gai.core.domain.dto.TrustLayerContext;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.message.llmcallback.LLMRawMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMSplitMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.service.LlmServiceFactory;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.service.trusty.TrustLayerService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MessageSplitHandler
implements IActionCallBack<LLMSplitMessage> {
    private static final Log logger = LogFactory.getLog(MessageSplitHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(LLMSplitMessage result) {
        String taskId = String.valueOf(result.getId());
        IAppCache taskCache = EngineCache.getAppCache(taskId);
        String enable = (String)taskCache.get("MsgSplit.Enable" + taskId, String.class);
        if (!"true".equals(enable)) {
            this.pass(result, -1);
            return;
        }
        String stopStreamStr = (String)taskCache.get("stop_stream" + taskId, String.class);
        if ("TRUE".equals(stopStreamStr) || "stopped".equals(result.getStatus())) {
            logger.info("task : {} is stopped.", (Object)taskId);
            return;
        }
        String maskingContextStr = (String)taskCache.get("TrustLayer.MaskingContext" + taskId, String.class);
        TrustLayerContext tlCtx = null;
        if (!StringUtils.isEmpty((CharSequence)maskingContextStr)) {
            try {
                tlCtx = (TrustLayerContext)JSON.parseObject((String)maskingContextStr, TrustLayerContext.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tlCtx == null || !tlCtx.isEnableMasking() || tlCtx.getMaskingInfoList() == null || tlCtx.getMaskingInfoList().isEmpty()) {
            this.pass(result, -1);
            return;
        }
        String seqNoStr = (String)taskCache.get("MsgSplit.seqNo" + taskId, String.class);
        AtomicInteger seqNo = new AtomicInteger(0);
        if (!StringUtils.isEmpty((CharSequence)seqNoStr)) {
            seqNo.set(Integer.parseInt(seqNoStr));
        }
        int olsSeqNo = seqNo.get();
        try {
            String llmNumber = (String)taskCache.get("MsgSplit.LLM" + taskId, String.class);
            LLM llm = LLM.parse(llmNumber);
            if (llm == null) {
                logger.info(String.format("\u672a\u627e\u5230llmNumber=%s \u7684LLM\u679a\u4e3e\u3002llm is null", llmNumber));
                this.pass(result, seqNo.getAndIncrement());
                return;
            }
            boolean stream = result.isStream();
            LlmService helper = LlmServiceFactory.getExecutor(llm, stream);
            String msg = helper.getResult(stream, result.getResult());
            if (stream) {
                if ("".equals(msg)) {
                    return;
                }
                if (msg == null) {
                    String streamBuffer = (String)taskCache.get("MsgSplit.streamBuffer" + taskId, String.class);
                    if (!StringUtils.isEmpty((CharSequence)streamBuffer)) {
                        streamBuffer = this.deMasking(streamBuffer, tlCtx);
                        this.toNext(result, streamBuffer, seqNo);
                    }
                    this.toNext(result, null, seqNo);
                } else {
                    ArrayList<String> splitList = new ArrayList<String>();
                    this.splitMsg(taskId, taskCache, msg, splitList);
                    for (String line : splitList) {
                        line = this.deMasking(line, tlCtx);
                        this.toNext(result, line, seqNo);
                    }
                }
            } else {
                msg = this.deMasking(msg, tlCtx);
                this.toNext(result, msg, seqNo);
            }
        }
        finally {
            if (olsSeqNo != seqNo.get()) {
                taskCache.put("MsgSplit.seqNo" + taskId, (Object)("" + seqNo.get()));
            }
        }
    }

    private String deMasking(String llmRespLine, TrustLayerContext tlCtx) {
        return TrustLayerService.deMasking(llmRespLine, tlCtx);
    }

    private void splitMsg(String taskId, IAppCache taskCache, String msg, List<String> splitList) {
        String streamBuffer = (String)taskCache.get("MsgSplit.streamBuffer" + taskId, String.class);
        streamBuffer = streamBuffer == null ? "" : streamBuffer;
        StringBuilder sb = new StringBuilder(streamBuffer);
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            char ch = msg.charAt(i);
            sb.append(ch);
            if (ch != '\uff0c' && ch != '\u3002' && ch != '\uff1f' && ch != '\uff01' && ch != '\uff1a' && ch != '\uff1b' && ch != '\n' && (ch != ',' && ch != '.' && ch != '?' && ch != '!' || i >= len - 1 || msg.charAt(i + 1) != ' ')) continue;
            splitList.add(sb.toString());
            sb = new StringBuilder();
        }
        if (!splitList.isEmpty()) {
            String one = String.join((CharSequence)"", splitList);
            splitList.clear();
            splitList.add(one);
        }
        taskCache.put("MsgSplit.streamBuffer" + taskId, (Object)sb.toString());
    }

    private boolean handleRepo(LLMSplitMessage result, String taskId, IAppCache taskCache, AtomicInteger seqNo, String msg, TrustLayerContext context) {
        String state = (String)taskCache.get("MsgSplit.State" + taskId, String.class);
        if (StringUtils.isEmpty((CharSequence)state) && msg.contains("########")) {
            String streamBuffer = (String)taskCache.get("MsgSplit.streamBuffer" + taskId, String.class);
            if (!StringUtils.isEmpty((CharSequence)streamBuffer)) {
                streamBuffer = this.deMasking(streamBuffer, context);
                this.toNext(result, streamBuffer, seqNo);
                taskCache.put("MsgSplit.streamBuffer" + taskId, (Object)"");
            }
            taskCache.put("MsgSplit.State" + taskId, (Object)"Repo");
            this.toNext(result, msg, seqNo);
            return true;
        }
        if ("Repo".equals(state)) {
            if (msg.contains("########")) {
                taskCache.put("MsgSplit.State" + taskId, (Object)"");
            }
            this.toNext(result, msg, seqNo);
            return true;
        }
        return false;
    }

    private void pass(LLMSplitMessage result, int streamSeqNO) {
        LLMRawMessage llmRawMessage = new LLMRawMessage();
        llmRawMessage.setId(result.getId());
        llmRawMessage.setStatus(result.getStatus());
        llmRawMessage.setResult(result.getResult());
        llmRawMessage.setErrCode(result.getErrCode());
        llmRawMessage.setErrMsg(result.getErrMsg());
        llmRawMessage.setStream(result.isStream());
        if (streamSeqNO == -1) {
            llmRawMessage.setStreamSeqNO(result.getStreamSeqNO());
        } else {
            llmRawMessage.setStreamSeqNO(streamSeqNO);
        }
        HandlerFactory.callback(llmRawMessage);
    }

    private void toNext(LLMSplitMessage result, String msg, AtomicInteger seqNo) {
        LLMRawMessage llmRawMessage = new LLMRawMessage();
        llmRawMessage.setId(result.getId());
        llmRawMessage.setStatus(result.getStatus());
        llmRawMessage.setResult(null);
        llmRawMessage.setErrCode(result.getErrCode());
        llmRawMessage.setErrMsg(result.getErrMsg());
        llmRawMessage.setStream(result.isStream());
        llmRawMessage.setStreamSeqNO(seqNo.getAndIncrement());
        llmRawMessage.setParsedResult(true);
        llmRawMessage.setLlmValue(msg);
        HandlerFactory.callback(llmRawMessage);
    }
}

