/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import java.util.Map;
import kd.ai.gai.core.api.mservice.MserviceResultHelper;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.message.llmcallback.MserviceLLMCallbackMessage;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class MserviceLLMHandler
implements IActionCallBack<MserviceLLMCallbackMessage> {
    private static final Log logger = LogFactory.getLog(MserviceLLMHandler.class);
    private static final String BOS_DOMAIN = "bos";
    private static final String ISV_DOMAIN = "isv";

    @Override
    public void callback(MserviceLLMCallbackMessage callbackMessage) {
        logger.info(String.format("\u5fae\u670d\u52a1\u5f02\u6b65\u56de\u8c03\u4e1a\u52a1,\u63a5\u6536 llm \u8fd4\u56de\u7ed3\u679c\uff1a%s", SerializationUtils.toJsonString((Object)callbackMessage)));
        String appId = callbackMessage.getAppId();
        String cloudId = callbackMessage.getCloudId();
        String serviceName = callbackMessage.getServiceName();
        String methodName = callbackMessage.getMethodName();
        Map<String, Object> response = MserviceResultHelper.buildCallMsg(callbackMessage);
        logger.info(String.format("\u5fae\u670d\u52a1\u5f02\u6b65\u56de\u8c03\u4e1a\u52a1,\u54cd\u5e94\u7ed3\u679c\uff1a%s", SerializationUtils.toJsonString(response)));
        if (BOS_DOMAIN.equalsIgnoreCase(cloudId)) {
            DispatchServiceHelper.invokeBOSService((String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{response});
            logger.info("\u56de\u8c03bos:{}\u5e73\u53f0\u6210\u529f", (Object)appId);
        } else if (ISV_DOMAIN.equalsIgnoreCase(cloudId)) {
            String prefix = callbackMessage.getFactoryQualifiedPrefix();
            DispatchServiceHelper.invokeService((String)prefix, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{response});
            logger.info("\u56de\u8c03isv:{}\u6210\u529f", (Object)prefix);
        } else {
            DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{response});
            logger.info("\u56de\u8c03\u4e1a\u52a1:{}\u6210\u529f", (Object)appId);
        }
        String chatSessionId = callbackMessage.getChatSessionId();
        TraceUtil.saveMserviceStreamAsyncLLMLog(FlowCacheData.getContext(chatSessionId), callbackMessage);
    }
}

