/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.handler.LLMActionHandler;
import kd.ai.gai.core.engine.message.llmcallback.PromptTestCallbackMessage;
import kd.ai.gai.core.service.WebSocketService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.bos.util.StringUtils;

public class PromptTestHandler
implements IActionCallBack<PromptTestCallbackMessage> {
    @Override
    public void callback(PromptTestCallbackMessage callbackMessage) {
        String chatSessionId = callbackMessage.getChatSessionId();
        Context context = FlowCacheData.getContext(callbackMessage.getChatSessionId());
        String assistantPageId = context.getAssistantPageId();
        String rootPageId = context.getRootPageId();
        String globalSessionId = context.getGlobalSessionId();
        String taskId = callbackMessage.getTaskId();
        String flowId = "0";
        if (!Errors.OK.getCode().equals(callbackMessage.getErrCode())) {
            WebSocketService.pushErrMsg("gai_gpt_playground", assistantPageId, rootPageId, globalSessionId, callbackMessage.getErrCode(), callbackMessage.getErrMsg(), context.getChatSessionId());
            TraceUtil.saveAsyncLLMLog(context, callbackMessage);
            return;
        }
        String llmValue = callbackMessage.getLlmValue();
        if (callbackMessage.isStream()) {
            if (callbackMessage.isEnd()) {
                if (StringUtils.isNotEmpty((String)llmValue)) {
                    WebSocketService.pushStreamChat("gai_gpt_playground", assistantPageId, rootPageId, globalSessionId, chatSessionId, taskId, flowId, callbackMessage.getSeqNo(), llmValue, false);
                }
                WebSocketService.pushStreamDown("gai_gpt_playground", assistantPageId, rootPageId, globalSessionId, chatSessionId, taskId, flowId, callbackMessage.getLlmValue(), "");
                TraceUtil.savePromptTestStreamAsyncLLMLog(context, callbackMessage);
            } else {
                WebSocketService.pushStreamChat("gai_gpt_playground", assistantPageId, rootPageId, globalSessionId, chatSessionId, taskId, flowId, callbackMessage.getSeqNo(), llmValue, false);
                TraceUtil.savePromptTestStreamAsyncLLMLog(context, callbackMessage);
            }
        } else {
            WebSocketService.pushChat("gai_gpt_playground", assistantPageId, taskId, rootPageId, globalSessionId, chatSessionId, llmValue);
            TraceUtil.savePromptTestStreamAsyncLLMLog(context, callbackMessage);
        }
        LLMActionHandler.sendChatBottomMsg(context, "gai_gpt_playground", assistantPageId, rootPageId, globalSessionId, chatSessionId, taskId, callbackMessage.getFlowId() + "", "\u53c2\u8003\u6587\u4ef6", callbackMessage.getCitationInfos());
    }
}

