/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import java.util.HashMap;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.service.WebSocketService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class StartFlowHandler
implements IMessageHandler<StartFlowMessage> {
    private static final Log log = LogFactory.getLog(StartFlowHandler.class);

    @Override
    public Result process(Context context, StartFlowMessage message) {
        long flowId = 0L;
        if (Context.needCheckLicense(context)) {
            GPTLicenseHelper.checkLic("gai_process", message.getProcessId());
        }
        Flow flow = FlowCacheData.createFlow(message.getChatSessionId(), message.getProcessId());
        flowId = flow.getId();
        Start start = flow.getStart();
        HashMap<String, String> initData = new HashMap<String, String>();
        if (start.getInputVars() != null && !start.getInputVars().isEmpty() && message.getInParams() != null) {
            for (Var var : start.getInputVars()) {
                String val = message.getInParams().get(var.getName());
                if (val == null) continue;
                initData.put(var.getName(), val);
            }
        }
        if (message.getUserInput() == null) {
            initData.put("system.user_input", "");
        } else {
            initData.put("system.user_input", message.getUserInput());
        }
        FlowCacheData.setFlowNodeData(context.getChatSessionId(), flow.getId(), start.getId(), initData);
        WebSocketService.pushWaiting(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), flow.getId(), null, context.getChatSessionId());
        TraceUtil.startFlow(context, flow, message.getProcessId());
        return FlowNextHandler.next(context, flow.getId(), start.getId());
    }
}

