/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.message.StopStreamMessage;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.llm.LlmService;
import kd.bos.entity.cache.IAppCache;
import kd.bos.util.StringUtils;

public class StopStreamHandler
implements IMessageHandler<StopStreamMessage> {
    @Override
    public Result process(Context context, StopStreamMessage message) {
        MessageService.updateUserMessage2Cancelled(context.getChatSessionId());
        if (StringUtils.isNotEmpty((String)message.getTaskId())) {
            StopStreamHandler.stopTask(message.getTaskId());
        }
        if (message.getFlowId() != 0L) {
            IAppCache sessionCache = EngineCache.getAppCache(context.getChatSessionId());
            sessionCache.put(StopStreamHandler.getFlowStopFlagKey(message.getFlowId()), (Object)"TRUE");
            return FlowNextHandler.endFlow(context, message.getFlowId(), false, null);
        }
        return new Result(Errors.OK);
    }

    private static String getFlowStopFlagKey(long flowId) {
        return "F_STOP_" + flowId;
    }

    public static void stopTask(String taskId) {
        IAppCache taskCache = EngineCache.getAppCache(taskId);
        taskCache.put("stop_stream" + taskId, (Object)"TRUE");
        LlmService.stopGpt(Long.parseLong(taskId));
    }

    public static boolean isStopped(String chatSessionId, long flowId) {
        IAppCache sessionCache = EngineCache.getAppCache(chatSessionId);
        return "TRUE".equals(sessionCache.get(StopStreamHandler.getFlowStopFlagKey(flowId), String.class));
    }

    public static void removeStopFlag(String chatSessionId, long flowId) {
        IAppCache sessionCache = EngineCache.getAppCache(chatSessionId);
        sessionCache.remove(StopStreamHandler.getFlowStopFlagKey(flowId));
    }
}

