/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.Date;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.json.ActionTypeAdapter;
import kd.ai.gai.core.engine.json.LLMParsedMessageTypeAdapter;
import kd.ai.gai.core.engine.message.EmbeddingMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;

public class JsonUtil {
    private static Gson gson = null;

    private JsonUtil() {
    }

    private static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        builder.serializeSpecialFloatingPointValues();
        builder.disableHtmlEscaping();
        builder.setLenient();
        builder.registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter());
        builder.registerTypeAdapter(Action.class, (Object)new ActionTypeAdapter());
        builder.registerTypeAdapter(LLMParsedMessage.class, (Object)new LLMParsedMessageTypeAdapter());
        gson = builder.create();
        return gson;
    }

    public static String toBase64String(Flow flow) {
        String jsonStr = JsonUtil.getGson().toJson((Object)flow);
        return Base64.getEncoder().encodeToString(jsonStr.getBytes(StandardCharsets.UTF_8));
    }

    public static Flow fromBase64String(String base64Str) {
        String jsonStr = new String(Base64.getDecoder().decode(base64Str), StandardCharsets.UTF_8);
        return (Flow)JsonUtil.getGson().fromJson(jsonStr, Flow.class);
    }

    public static String toJson(Object obj) {
        return JsonUtil.getGson().toJson(obj);
    }

    public static String messageToJson(LLMParsedMessage message) {
        return JsonUtil.getGson().toJsonTree((Object)message, LLMParsedMessage.class).toString();
    }

    public static String messageToJson(EmbeddingMessage message) {
        return JsonUtil.getGson().toJsonTree((Object)message, EmbeddingMessage.class).toString();
    }

    public static String actionToJson(Action action) {
        return JsonUtil.getGson().toJsonTree((Object)action, Action.class).toString();
    }

    public static <T> T fromJson(String jsonStr, Class<T> classOfT) {
        return (T)JsonUtil.getGson().fromJson(jsonStr, classOfT);
    }
}

