/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.bos.exception.KDBizException;

public class LLMParsedMessageTypeAdapter
implements JsonDeserializer<LLMParsedMessage>,
JsonSerializer<LLMParsedMessage> {
    private static final String ACTION_TYPE = "type";
    private static final String PROPERTIES = "properties";

    public LLMParsedMessage deserialize(JsonElement jsonElement, Type typeOf, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement actionTypeJson = jsonObject.get(ACTION_TYPE);
        if (actionTypeJson == null) {
            throw new KDBizException(Errors.actionJsonDataError("Type\u8282\u70b9\u4e0d\u5b58\u5728"), new Object[0]);
        }
        String type = actionTypeJson.getAsString();
        JsonElement element = jsonObject.get(PROPERTIES);
        try {
            return (LLMParsedMessage)context.deserialize(element, Class.forName(type));
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonParseException("Unknown element type: " + type, (Throwable)cnfe);
        }
    }

    public JsonElement serialize(LLMParsedMessage llmParsedMessage, Type typeOf, JsonSerializationContext context) {
        if (llmParsedMessage == null) {
            return null;
        }
        JsonObject result = new JsonObject();
        result.add(ACTION_TYPE, (JsonElement)new JsonPrimitive(llmParsedMessage.getClass().getName()));
        result.add(PROPERTIES, context.serialize((Object)llmParsedMessage, llmParsedMessage.getClass()));
        return result;
    }
}

