/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.enuz.repo;

import kd.ai.gai.core.enuz.LLM;

public enum ChunkRule {
    AZURE_002_BASE_SPLIT(LLM.AZURE_EMBEDDING_ADA_002, 400, ChunkStrategy.BASE_FIXED_LENGTH),
    AZURE_002NEW_BASE_SPLIT(LLM.AZURE_EMBEDDING_ADA_002_BATCH, 400, ChunkStrategy.BASE_FIXED_LENGTH),
    BAIDU_BASE_SPLIT(LLM.BAIDU_EMBEDDING_V1, 384, ChunkStrategy.BASE_FIXED_LENGTH),
    BAIDU_BGE_LARGE_ZH_BASE_SPLIT(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, 512, ChunkStrategy.BASE_FIXED_LENGTH),
    BAIDU_TAO_8K_BASE_SPLIT(LLM.BAIDU_EMBEDDING_TAO_8K, 512, ChunkStrategy.BASE_FIXED_LENGTH),
    KINGDEE_BASE_SPLIT(LLM.KINGDEE_EMBEDDING, 400, ChunkStrategy.BASE_FIXED_LENGTH),
    AZURE_002_CUSTOMIZE(LLM.AZURE_EMBEDDING_ADA_002, 2000, ChunkStrategy.CUSTOMIZE),
    AZURE_002NEW_CUSTOMIZE(LLM.AZURE_EMBEDDING_ADA_002_BATCH, 2000, ChunkStrategy.CUSTOMIZE),
    BAIDU_CUSTOMIZE(LLM.BAIDU_EMBEDDING_V1, 350, ChunkStrategy.CUSTOMIZE),
    BAIDU_BGE_LARGE_ZH_CUSTOMIZE(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, 512, ChunkStrategy.CUSTOMIZE),
    BAIDU_TAO_8K_CUSTOMIZE(LLM.BAIDU_EMBEDDING_TAO_8K, 2000, ChunkStrategy.CUSTOMIZE),
    KINGDEE_CUSTOMIZE(LLM.KINGDEE_EMBEDDING, 350, ChunkStrategy.CUSTOMIZE);

    private LLM llm;
    private int maxSize;
    private ChunkStrategy chunkStrategy;

    private ChunkRule(LLM llm, int maxSize, ChunkStrategy chunkStrategy) {
        this.llm = llm;
        this.maxSize = maxSize;
        this.chunkStrategy = chunkStrategy;
    }

    public ChunkStrategy getChunkStrategy() {
        return this.chunkStrategy;
    }

    public void setChunkStrategy(ChunkStrategy chunkStrategy) {
        this.chunkStrategy = chunkStrategy;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public LLM getLlm() {
        return this.llm;
    }

    public void setLlm(LLM llm) {
        this.llm = llm;
    }

    public static ChunkRule parse(LLM llm, ChunkStrategy type) {
        for (ChunkRule rule : ChunkRule.values()) {
            if (rule.llm != llm || rule.chunkStrategy != type) continue;
            return rule;
        }
        return null;
    }

    public static enum ChunkStrategy {
        BASE_FIXED_LENGTH("base"),
        CUSTOMIZE("customize");

        private String strategy;

        private ChunkStrategy(String strategy) {
            this.strategy = strategy;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public static ChunkStrategy parse(String strategy) {
            for (ChunkStrategy cs : ChunkStrategy.values()) {
                if (!cs.strategy.equals(strategy)) continue;
                return cs;
            }
            return null;
        }
    }
}

