/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.helper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.ai.gai.core.engine.FlowCacheData;

public class ClusterWaiter {
    private static final int MAX_WAIT_TIME = 1800000;
    private static final Map<String, CountDownLatch> waitObjectMap = new ConcurrentHashMap<String, CountDownLatch>();

    private ClusterWaiter() {
    }

    public static void release(String key) {
        CountDownLatch latch = waitObjectMap.get(key);
        if (latch != null) {
            latch.countDown();
            waitObjectMap.remove(key);
        }
    }

    public static void remove(String key) {
        CountDownLatch latch = waitObjectMap.get(key);
        if (latch != null) {
            waitObjectMap.remove(key);
        }
    }

    public static void waiting(String chatSessionId, String key) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        waitObjectMap.put(key, latch);
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 1800000L) {
            if (latch.await(10L, TimeUnit.SECONDS)) {
                return;
            }
            String val = FlowCacheData.getCache(chatSessionId, key);
            if (val == null) continue;
            return;
        }
    }
}

