/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.helper;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.LicenseResult;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.BLG;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.util.GaiLicenseUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.license.bean.LicenseGroupCtrl;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseGrayServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GPTLicenseHelper {
    private static final Log logger = LogFactory.getLog(GPTLicenseHelper.class);
    public static final String GAI_APP_ID = "3ACHGCGWU9MJ";
    public static final String REPO_CODE = "ai_gai_reporag";
    public static final String PROCESS_CODE = "gai_process";
    public static final long AI_GAIR_GROUP_ID = 2026183729222894592L;

    public static Set<Long> getUseBizIds(String bizObjCode, Set<Long> bizIds) {
        String version = LicenseServiceHelper.getProductVersion();
        logger.info("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u8bb8\u53ef\u7248\u672c\uff1a{},\u4e1a\u52a1\u5355\u636e\u7f16\u7801\uff1a{},\u6570\u636eIDs:{}", new Object[]{version, bizObjCode, JsonUtil.toJson(bizIds)});
        TreeSet<Long> useBizIds = new TreeSet<Long>();
        for (Long bizId : bizIds) {
            LicenseResult licenseResult = GPTLicenseHelper.checkLicData(bizObjCode, bizId);
            if (!licenseResult.isHasLicense()) continue;
            useBizIds.add(bizId);
        }
        logger.info("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011,\u8bb8\u53ef\u7248\u672c\uff1a{},\u4e1a\u52a1\u5355\u636e\u7f16\u7801\uff1a{},\u8fc7\u6ee4\u540e\u53ef\u7528\u6e05\u5355\u6570\u636e\uff1a{}\u3002", new Object[]{version, bizObjCode, JsonUtil.toJson(useBizIds)});
        return useBizIds;
    }

    public static boolean checkLic(String bizObjCode, Long bizId) {
        try {
            logger.info("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u9690\u79c1\u534f\u8bae\u76f8\u5173\u7b7e\u7f72\u68c0\u67e5-\u5f00\u59cb", (Object)bizObjCode, (Object)bizId);
            GptPrivacyHelper.checkCurrUserPrivacy();
            logger.info("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u9690\u79c1\u534f\u8bae\u76f8\u5173\u7b7e\u7f72\u68c0\u67e5-\u7ed3\u675f", (Object)bizObjCode, (Object)bizId);
            LicenseResult licenseResult = GPTLicenseHelper.checkLicData(bizObjCode, bizId);
            if (licenseResult != null && !licenseResult.isHasLicense()) {
                throw new KDBizException(licenseResult.getErrorCode(), new Object[0]);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u68c0\u67e5\u5f02\u5e38\uff0c\u4e1a\u52a1\u5355\u636e\u7f16\u7801:{},\u6570\u636eID:{},errMsg:{}", new Object[]{bizObjCode, bizId, e.getMessage(), e});
            throw e;
        }
    }

    private static LicenseResult checkLicData(String bizObjCode, Long bizId) {
        try {
            String version = LicenseServiceHelper.getProductVersion();
            logger.info("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u68c0\u67e5\u5f00\u59cb\uff0c\u8bb8\u53ef\u7248\u672c\uff1a{},\u4e1a\u52a1\u5355\u636e\u7f16\u7801\uff1a{},\u6570\u636eID:{}", new Object[]{version, bizObjCode, bizId});
            if (StringUtils.isEmpty((String)bizObjCode)) {
                String message = ResManager.loadKDString((String)"\u53c2\u6570\u3010\u4e1a\u52a1\u5355\u636e\u7f16\u7801\u3011\u5f02\u5e38", (String)"GPTLicenseHelper_1", (String)"ai-gai-core", (Object[])new Object[0]);
                ErrorCode errorCode = GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.LIC_PARAMS_ERR, message);
                return LicenseResult.fail(errorCode);
            }
            if (!(REPO_CODE.equalsIgnoreCase(bizObjCode) || bizId != null && bizId != 0L)) {
                String message = ResManager.loadKDString((String)"\u53c2\u6570\u3010\u5355\u636e\u6570\u636eID\u3011\u5f02\u5e38", (String)"GPTLicenseHelper_2", (String)"ai-gai-core", (Object[])new Object[0]);
                ErrorCode errorCode = GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.LIC_PARAMS_ERR, message);
                return LicenseResult.fail(errorCode);
            }
            String bizObjID = GPTLicenseHelper.buildBizObjID(bizObjCode, bizId);
            long currUserId = RequestContext.get().getCurrUserId();
            LicenseGroupCtrl licenseGroupCtrl = LicenseCache.getLicenseGroupCtrl((String)GAI_APP_ID, (String)bizObjID);
            Set useAppGroupIds = licenseGroupCtrl.getCurVersionGroups();
            logger.info("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u8bb8\u53ef\u7248\u672c\uff1a{},\u4e1a\u52a1\u5355\u636e\u7f16\u7801\uff1a{},\u6570\u636eID:{}\uff0c\u63a7\u5236\u6e05\u5355\u7ed1\u5b9a\u8bb8\u53ef\u5206\u7ec4IDS:{}", new Object[]{version, bizObjCode, bizId, JsonUtil.toJson(useAppGroupIds)});
            int useSize = useAppGroupIds.size();
            LicenseResult licenseResult = LicenseResult.fail(GaiExceptionUtil.buildErr(GaiErrorCode.NO_GPT_LICENSE_ERR));
            if (useSize > 0) {
                boolean use = false;
                for (Long groupId : useAppGroupIds) {
                    LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)currUserId, (Long)groupId);
                    Boolean hasLicense = licenseCheckResult.getHasLicense();
                    if (!hasLicense.booleanValue()) continue;
                    use = true;
                }
                if (!use) {
                    int count = 1;
                    StringBuilder msg = new StringBuilder();
                    for (Long groupId : useAppGroupIds) {
                        String licName = GPTLicenseHelper.getLicNameById(groupId);
                        if (count == useSize) {
                            msg.append(licName);
                            if (useSize > 1) {
                                String message = ResManager.loadKDString((String)"\u5176\u4e2d\u4e00\u4e2a", (String)"GPTLicenseHelper_3", (String)"ai-gai-core", (Object[])new Object[0]);
                                msg.append(message);
                            }
                        } else {
                            msg.append(licName).append('\u3001');
                        }
                        ++count;
                    }
                    ErrorCode errorCode = GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.LIC_ASSISTANT_ERR, msg.toString());
                    return LicenseResult.fail(errorCode);
                }
                return LicenseResult.ok();
            }
            switch (version) {
                case "1.0": {
                    licenseResult = LicenseResult.ok();
                    break;
                }
                case "2.0": 
                case "3.0": 
                case "4.0": {
                    logger.warn("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011,\u5f53\u524d\u7248\u672c\uff1a{},\u4e0d\u652f\u6301\u3002", (Object)version);
                    break;
                }
                case "5.0": {
                    licenseResult = GPTLicenseHelper.checkLicByV5();
                    break;
                }
                case "6.0": {
                    licenseResult = GPTLicenseHelper.checkLicByV6(bizObjCode, bizId);
                    break;
                }
                default: {
                    LicenseCheckResult licenseCheckResult;
                    licenseResult = GPTLicenseHelper.checkLicByV7(bizObjCode, bizId);
                    if (licenseResult.isHasLicense() || (licenseCheckResult = LicenseGrayServiceHelper.checkGrayLicense((String)bizObjID)) == null || licenseCheckResult.getHasLicense().booleanValue()) break;
                    licenseResult = LicenseResult.fail(GaiExceptionUtil.buildErr(GaiErrorCode.NO_GPT_LICENSE_ERR));
                }
            }
            logger.info("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u68c0\u67e5\u7ed3\u675f\uff0c\u8bb8\u53ef\u7248\u672c\uff1a{},\u4e1a\u52a1\u5355\u636e\u7f16\u7801\uff1a{},\u6570\u636eID:{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{version, bizObjCode, bizId, JsonUtil.toJson(licenseResult)});
            return licenseResult;
        }
        catch (Exception e) {
            logger.error("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u68c0\u67e5\u5f02\u5e38\uff0c\u4e1a\u52a1\u5355\u636e\u7f16\u7801:{},bizId:{},errMsg:{}", new Object[]{bizObjCode, bizId, e.getMessage(), e});
            if (e instanceof KDBizException) {
                ErrorCode errorCode = ((KDBizException)((Object)e)).getErrorCode();
                return LicenseResult.fail(errorCode);
            }
            return LicenseResult.fail(GaiExceptionUtil.buildErr(GaiErrorCode.NO_GPT_LICENSE_ERR));
        }
    }

    private static LicenseResult checkLicByV7(String bizObjCode, Long bizId) {
        if ("gai_prompt".equalsIgnoreCase(bizObjCode) && 2002989110637102080L == bizId) {
            return new LicenseResult(true);
        }
        return GPTLicenseHelper.checkLicByV7AI();
    }

    @NotNull
    private static LicenseResult checkLicByV7AI() {
        long currUserId = RequestContext.get().getCurrUserId();
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)currUserId, (Long)2026183729222894592L);
        if (licenseCheckResult != null) {
            Boolean hasLicense = licenseCheckResult.getHasLicense();
            LicenseResult licenseResult = new LicenseResult(hasLicense);
            if (!hasLicense.booleanValue()) {
                ErrorCode errorCode = GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.LIC_ASSISTANT_ERR, GPTLicenseHelper.getLicNameById(2026183729222894592L));
                licenseResult.setErrorCode(errorCode);
            }
            return licenseResult;
        }
        String message = ResManager.loadKDString((String)"AI\u5f00\u53d1\u5e73\u53f0\u8fd0\u884c\u65f6\u8bb8\u53ef\uff0c\u63a7\u5236\u6e05\u5355\u4e0d\u5b58\u5728", (String)"GPTLicenseHelper_4", (String)"ai-gai-core", (Object[])new Object[0]);
        ErrorCode errorCode = GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.LIC_PARAMS_ERR, message);
        throw new KDBizException(errorCode, new Object[0]);
    }

    private static LicenseResult checkLicByV6(String bizObjCode, Long bizId) {
        if ("gai_prompt".equalsIgnoreCase(bizObjCode)) {
            return GPTLicenseHelper.usePromptByV6(bizId);
        }
        if (PROCESS_CODE.equalsIgnoreCase(bizObjCode)) {
            return GPTLicenseHelper.useProcessByV6(bizId);
        }
        if (REPO_CODE.equalsIgnoreCase(bizObjCode) || GaiFormIdEnum.GAI_AGENT.getId().equalsIgnoreCase(bizObjCode)) {
            return GPTLicenseHelper.checkBLGByV6();
        }
        return LicenseResult.ok();
    }

    @Nullable
    private static LicenseResult checkBLGByV6() {
        boolean use = false;
        long currUserId = RequestContext.get().getCurrUserId();
        for (BLG blg : BLG.values()) {
            long groupId = blg.getGroupId();
            use = GaiLicenseUtils.checkUserUseGroupLic(currUserId, groupId);
            if (use) break;
        }
        if (!use) {
            LicenseResult licenseResult = new LicenseResult(false);
            licenseResult.setErrorCode(GaiExceptionUtil.buildErr(GaiErrorCode.NO_GPT_LICENSE_ERR));
            return licenseResult;
        }
        return new LicenseResult(true);
    }

    private static LicenseResult checkLicByV5() {
        Map info = LicenseServiceHelper.getProductInfo();
        String softwareCode = info.get("softwareCode") == null ? "" : (String)info.get("softwareCode");
        String version = LicenseServiceHelper.getProductVersion();
        if ("5.0".equals(version) && ("22CBDC6A72E84A23".equals(softwareCode) || "EA18D8E1CD665E25".equals(softwareCode))) {
            return new LicenseResult(true);
        }
        LicenseResult licenseResult = new LicenseResult(false);
        licenseResult.setErrorCode(GaiExceptionUtil.buildErr(GaiErrorCode.NO_GPT_LICENSE_ERR));
        return licenseResult;
    }

    private static String buildBizObjID(String bizObjCode, Long bizId) {
        if (REPO_CODE.equalsIgnoreCase(bizObjCode)) {
            return REPO_CODE;
        }
        return String.format("%s-%s", bizObjCode, bizId);
    }

    private static String getLicNameById(long groupId) {
        logger.info("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u67e5\u8be2\u5bf9\u5e94\u8bb8\u53ef\u540d\u79f0-\u5f00\u59cb\uff0cgroupId:{}", (Object)groupId);
        DynamicObject lic = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"lic_group");
        if (lic != null) {
            ILocaleString localeName = lic.getLocaleString("name");
            String name = localeName.getLocaleValue();
            if (name == null) {
                String number = lic.getString("number");
                name = ResManager.loadKDString((String)String.format("\u7f16\u7801\u4e3a%s", number), (String)"GPTLicenseHelper_7", (String)"ai-gai-core", (Object[])new Object[0]);
            }
            logger.info("\u3010AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\u3011\u67e5\u8be2\u5bf9\u5e94\u8bb8\u53ef\u540d\u79f0-\u7ed3\u675f\uff0cgroupId:{},name:{}", (Object)groupId, (Object)name);
            return name;
        }
        String message = ResManager.loadKDString((String)"\u8bb8\u53ef\u5206\u7ec4ID:%s \u4e0d\u5b58\u5728", (String)"GPTLicenseHelper_5", (String)"ai-gai-core", (Object[])new Object[0]);
        ErrorCode errorCode = GaiExceptionUtil.buildExtMsgErr(GaiErrorCode.LIC_PARAMS_ERR, String.format(message, groupId));
        throw new KDBizException(errorCode, new Object[0]);
    }

    private static LicenseResult usePromptByV6(long promptId) {
        LicenseResult licenseResult;
        DynamicObject prompt = QueryServiceHelper.queryOne((String)"gai_prompt", (String)"blgids", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)promptId)});
        if (prompt != null) {
            String blgids = prompt.getString("blgids");
            logger.info("lic check data,promptId:{},blgids:{}", (Object)promptId, (Object)blgids);
            licenseResult = GPTLicenseHelper.checkBlgids(blgids);
        } else {
            licenseResult = new LicenseResult(false);
            licenseResult.setErrorCode(GaiExceptionUtil.buildErr(GaiErrorCode.PRAMPT_NO_EXIET_ERROR));
        }
        return licenseResult;
    }

    private static LicenseResult useProcessByV6(long processId) {
        LicenseResult licenseResult;
        DynamicObject process = QueryServiceHelper.queryOne((String)PROCESS_CODE, (String)"blgids", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)processId)});
        if (process != null) {
            String blgids = process.getString("blgids");
            logger.info("lic check data,processId:{},blgids:{}", (Object)processId, (Object)blgids);
            licenseResult = GPTLicenseHelper.checkBlgids(blgids);
        } else {
            licenseResult = new LicenseResult(false);
            licenseResult.setErrorCode(GaiExceptionUtil.buildErr(GaiErrorCode.PROCESS_NO_EXIET_ERR));
        }
        return licenseResult;
    }

    @NotNull
    private static LicenseResult checkBlgids(String blgids) {
        long groupId;
        boolean use = false;
        long currUserId = RequestContext.get().getCurrUserId();
        LicenseResult licenseResult = new LicenseResult(use);
        if (StringUtils.isNotEmpty((String)blgids)) {
            String[] ids;
            for (String id : ids = blgids.split(",")) {
                try {
                    groupId = Long.parseLong(id);
                    if (!BLG.exists(groupId) || !(use = GaiLicenseUtils.checkUserUseGroupLic(currUserId, groupId))) continue;
                    break;
                }
                catch (NumberFormatException e) {
                    throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.LIC_BIND_DATA_ERR), new Object[0]);
                }
            }
        } else {
            use = GaiLicenseUtils.checkUserUseGroupLic(currUserId, BLG.GAI.getGroupId());
        }
        if (use) {
            licenseResult.setHasLicense(true);
        } else {
            boolean multiple = false;
            StringBuilder msgbuild = new StringBuilder();
            msgbuild.append('\u3010');
            if (StringUtils.isNotEmpty((String)blgids)) {
                BLG blg;
                String[] ids = blgids.split(",");
                int size = ids.length;
                if (size > 1) {
                    multiple = true;
                }
                for (int i = 0; i < size - 1; ++i) {
                    groupId = Long.parseLong(ids[i]);
                    BLG blg2 = BLG.parse(groupId);
                    if (blg2 == null) continue;
                    if (BLG.PRO.getGroupId() == groupId) {
                        multiple = true;
                    }
                    msgbuild.append(blg2.getName()).append(',');
                }
                long groupId2 = Long.parseLong(ids[size - 1]);
                if (BLG.PRO.getGroupId() == groupId2) {
                    multiple = true;
                }
                if ((blg = BLG.parse(groupId2)) != null) {
                    msgbuild.append(blg.getName());
                }
            } else {
                msgbuild.append(BLG.GAI.getName());
            }
            msgbuild.append('\u3011');
            if (multiple) {
                String message = ResManager.loadKDString((String)"\u4e2d\u4efb\u4e00", (String)"GPTLicenseHelper_6", (String)"ai-gai-core", (Object[])new Object[0]);
                msgbuild.append(message);
            }
            ErrorCode errorCode = new ErrorCode(GaiErrorCode.LIC_ASSISTANT_ERR.getCode(), String.format(GaiErrorCode.LIC_ASSISTANT_ERR.getMsg(), msgbuild.toString()));
            licenseResult.setHasLicense(false);
            licenseResult.setErrorCode(errorCode);
        }
        return licenseResult;
    }
}

