/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.helper.ClusterWaiter;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ProcessHelper {
    private static final Log logger = LogFactory.getLog(ProcessHelper.class);

    private ProcessHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result callProcess(long processId, String userInput, Map<String, String> params) {
        Context context = Context.create4API();
        String chatSessionId = context.getChatSessionId();
        StartFlowMessage startFlowMessage = new StartFlowMessage();
        startFlowMessage.setProcessId(processId);
        startFlowMessage.setChatSessionId(chatSessionId);
        startFlowMessage.setInParams(params);
        startFlowMessage.setUserInput(userInput);
        Result result = new Result();
        try {
            result = HandlerFactory.runHandler(context, startFlowMessage);
        }
        catch (Exception exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
            ErrorCode errorCode = FlowNextHandler.getErrorCode(exp);
            result.setErrorCode(errorCode);
            result.setStatus(Result.Status.END);
        }
        if (result.getStatus() == Result.Status.RUNNING) {
            String key = String.format("%s_%s", chatSessionId, processId);
            try {
                ClusterWaiter.waiting(chatSessionId, key);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ClusterWaiter.remove(key);
            }
            String resultStr = FlowCacheData.getCache(chatSessionId, key);
            if (resultStr == null) {
                result = new Result(Errors.FLOW_RUN_TIMEOUT);
            } else {
                FlowCacheData.clearCache(chatSessionId, key);
                result = (Result)JSON.parseObject((String)resultStr, Result.class);
                JSONObject jsonObject = JSON.parseObject((String)resultStr);
                JSONObject errorCodeObj = jsonObject.getJSONObject("errorCode");
                if (errorCodeObj != null) {
                    result.setErrorCode(new ErrorCode(errorCodeObj.getString("code"), errorCodeObj.getString("message")));
                }
            }
        }
        return result;
    }
}

