/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.privacy.model;

import kd.ai.gai.core.privacy.model.PrivacyAgreementType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;

public class PrivacyAgreeRecord {
    private String tenantId;
    private long userId;
    private String version;
    private long signTime;
    private String signOperation;
    private String viewUrl;

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getSignTime() {
        return this.signTime;
    }

    public void setSignTime(long signTime) {
        this.signTime = signTime;
    }

    public String getSignOperation() {
        return this.signOperation;
    }

    public void setSignOperation(String signOperation) {
        this.signOperation = signOperation;
    }

    public String getViewUrl() {
        return this.viewUrl;
    }

    public void setViewUrl(String viewUrl) {
        this.viewUrl = viewUrl;
    }

    public static PrivacyAgreeRecord fromDynamicObject(PrivacyAgreementType agreementType, DynamicObject dObjRecord) {
        String operationDesc;
        long signTime;
        PrivacyAgreeRecord record = new PrivacyAgreeRecord();
        if (agreementType == PrivacyAgreementType.TENANT_PRIVACY_AGREEMENT) {
            record.setTenantId(dObjRecord.getString("tenantid"));
            record.setUserId((Long)dObjRecord.getDynamicObject("user").getPkValue());
            record.setVersion(dObjRecord.getString("version"));
            signTime = dObjRecord.getLong("agreetimestamp");
            if (signTime == 0L) {
                signTime = dObjRecord.getDate("agreetime").getTime();
            }
            record.setSignTime(signTime);
            operationDesc = dObjRecord.getBoolean("isagree") ? "\u540c\u610f\u7b7e\u7f72" : "\u89e3\u9664\u7b7e\u7f72";
            record.setSignOperation(operationDesc);
            record.setViewUrl(agreementType.getUrl());
        }
        if (agreementType == PrivacyAgreementType.USER_PRIVACY_POLICY) {
            record.setTenantId(RequestContext.get().getTenantId());
            record.setUserId((Long)dObjRecord.getDynamicObject("user").getPkValue());
            record.setVersion(dObjRecord.getString("version"));
            signTime = dObjRecord.getLong("agreetimestamp");
            if (signTime == 0L) {
                signTime = dObjRecord.getDate("agreetime").getTime();
            }
            record.setSignTime(signTime);
            operationDesc = dObjRecord.getBoolean("isagree") ? "\u540c\u610f\u7b7e\u7f72" : "\u89e3\u9664\u7b7e\u7f72";
            record.setSignOperation(operationDesc);
            record.setViewUrl(agreementType.getUrl());
        }
        return record;
    }
}

