/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.chunk;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.rag.chunk.ChunkInput;
import kd.ai.gai.core.rag.chunk.IChunk;
import kd.ai.gai.core.rag.service.RepoDispatchService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public abstract class AbstractChunkService
implements IChunk {
    private static Log LOGGER = LogFactory.getLog(AbstractChunkService.class);
    private static final long LOCK_WAIT_TIME = 3000L;
    private static final String LOCK_KEY_PER = "gai_chunk_";

    @Override
    public boolean preExecute(ChunkInput chunkInput) {
        LOGGER.info("\u3010\u77e5\u8bc6\u5e93-\u6587\u4ef6\u5206\u5757\u3011\uff0c\u5206\u5757\u6587\u4ef6\u4fe1\u606f:{}", (Object)SerializationUtils.toJsonString((Object)chunkInput));
        this.checkData(chunkInput);
        long fileId = chunkInput.getFileId();
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=?  where fentryid=?", (Object[])new Object[]{"B", fileId});
        return true;
    }

    private void checkData(ChunkInput chunkInput) {
        if (chunkInput == null || chunkInput.getFileId() <= 0L || StringUtils.isEmpty((String)chunkInput.getFilePath())) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.REPO_CHUNK_FILE_ERR), new Object[0]);
        }
        if (chunkInput.getChunkConfig() == null) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.REPO_EMBEDDING_ERR), new Object[0]);
        }
        if (!Arrays.asList(Constant.RepoInfo.handle_file_type).contains(chunkInput.getFileType())) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.REPO_CHUNK_FILE_TYPE_ERR), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ChunkInput chunkInput) {
        if (chunkInput == null || chunkInput.getFileId() <= 0L || StringUtils.isEmpty((String)chunkInput.getFilePath())) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.REPO_CHUNK_FILE_ERR), new Object[0]);
        }
        RequestContext rc = RequestContext.get();
        String lockKey = LOCK_KEY_PER.concat(rc.getTenantCode()).concat(rc.getAccountId()).concat("_").concat(String.valueOf(chunkInput.getFileId()));
        LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011-\u6587\u4ef6\u5206\u5757\u4efb\u52a1, \u9501Key\uff1a%s", lockKey));
        DLock lock = this.getLock(lockKey);
        if (!lock.tryLock(3000L)) {
            LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u5206\u5757\u4efb\u52a1\u4efb\u52a1,\u83b7\u4efb\u52a1\u6267\u884c\u6743\u5931\u8d25\uff0c\u4e2d\u65ad\u672c\u6b21\u4efb\u52a1\uff0c\u77e5\u8bc6\u5e93:%s, FileID: %s ", chunkInput.getRepositoryId(), chunkInput.getFileId()));
            return;
        }
        try {
            this.preExecute(chunkInput);
            this.run(chunkInput);
            this.postExecute(chunkInput);
        }
        catch (Exception e) {
            try {
                LOGGER.error(String.format("\u3010\u77e5\u8bc6\u5e93-chunk\u3011\u4efb\u52a1\uff0c\u5f02\u5e38 \u4efb\u52a1\u4fe1\u606f:%s", JSON.toJSONString((Object)chunkInput)), (Throwable)e);
                String logMsg = String.format("traceId: %s ,errorMsg:%s", RequestContext.get().getTraceId(), e.getMessage());
                logMsg = logMsg.length() > 2000 ? logMsg.substring(0, 2000) : logMsg;
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", chunkInput.getRepositoryId()});
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=? ,flog=? where fentryid=?", (Object[])new Object[]{"D", logMsg, chunkInput.getFileId()});
            }
            catch (Throwable throwable) {
                LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011-\u6587\u4ef6\u3010%s\u3011\u5206\u5757\u4efb\u52a1\u5b8c\u6210, \u91ca\u653e\u9501\uff1a%s", chunkInput.getFileId(), lockKey));
                lock.unlock();
                throw throwable;
            }
            LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011-\u6587\u4ef6\u3010%s\u3011\u5206\u5757\u4efb\u52a1\u5b8c\u6210, \u91ca\u653e\u9501\uff1a%s", chunkInput.getFileId(), lockKey));
            lock.unlock();
        }
        LOGGER.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011-\u6587\u4ef6\u3010%s\u3011\u5206\u5757\u4efb\u52a1\u5b8c\u6210, \u91ca\u653e\u9501\uff1a%s", chunkInput.getFileId(), lockKey));
        lock.unlock();
    }

    @Override
    public void postExecute(ChunkInput chunkInput) {
        long fileId = chunkInput.getFileId();
        long repoId = chunkInput.getRepositoryId();
        LLM llm = chunkInput.getChunkConfig().getChunkRule().getLlm();
        LOGGER.info(String.format("\u3010\u77e5\u8bc6\u5e93-chunk\u3011\u51c6\u5907\u52a0\u5165 Embedding \u4efb\u52a1\uff0crepoId:%s", repoId));
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=? where fentryid=?", (Object[])new Object[]{"F", fileId});
        RepoDispatchService.addEmbeddingTask(repoId, llm, fileId);
    }

    abstract void run(ChunkInput var1);

    private DLock getLock(String lockKey) {
        DLock lock = DLock.create((String)lockKey, (String)String.format("\u9501:%s,\u3010GPT-\u77e5\u8bc6\u5e93\u3011\u5206\u5757\u4efb\u52a1\u9501", lockKey));
        lock.fastMode();
        return lock;
    }
}

