/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.embedding;

import java.util.EnumMap;
import java.util.Map;
import kd.ai.gai.core.enuz.EmbeddingModel;
import kd.ai.gai.core.rag.embedding.AbstractEmbeddingService;
import kd.ai.gai.core.rag.embedding.EmbeddingAsyncFixedBatchService;
import kd.bos.exception.KDBizException;

public class EmbeddingExeServiceFactory {
    private EmbeddingExeServiceFactory() {
    }

    public static AbstractEmbeddingService getService(EmbeddingModel embedding) {
        AbstractEmbeddingService service = (AbstractEmbeddingService)Holder.EMBEDDING_SERVICE_MAP.get((Object)embedding);
        if (service != null) {
            return service;
        }
        throw new KDBizException("\u4e0d\u652f\u6301\u7684\u5206\u5757\u7684Embedding\u6a21\u578b");
    }

    public static void register(EmbeddingModel embedding, AbstractEmbeddingService chunkService) {
        AbstractEmbeddingService service = (AbstractEmbeddingService)Holder.EMBEDDING_SERVICE_MAP.get((Object)embedding);
        if (service == null) {
            Holder.EMBEDDING_SERVICE_MAP.put(embedding, chunkService);
        }
    }

    private static class Holder {
        private static final Map<EmbeddingModel, AbstractEmbeddingService> EMBEDDING_SERVICE_MAP = new EnumMap<EmbeddingModel, AbstractEmbeddingService>(EmbeddingModel.class);

        private Holder() {
        }

        static {
            EMBEDDING_SERVICE_MAP.put(EmbeddingModel.AZURE_EMBEDDING_ADA_002_SINGLE, new EmbeddingAsyncFixedBatchService(EmbeddingModel.AZURE_EMBEDDING_ADA_002_SINGLE));
            EMBEDDING_SERVICE_MAP.put(EmbeddingModel.AZURE_EMBEDDING_ADA_002_NEW_BATCH, new EmbeddingAsyncFixedBatchService(EmbeddingModel.AZURE_EMBEDDING_ADA_002_NEW_BATCH));
            EMBEDDING_SERVICE_MAP.put(EmbeddingModel.BAIDU_EMBEDDING_V1_BATCH, new EmbeddingAsyncFixedBatchService(EmbeddingModel.BAIDU_EMBEDDING_V1_BATCH));
            EMBEDDING_SERVICE_MAP.put(EmbeddingModel.BAIDU_EMBEDDING_BGE_LARGE_ZH_BATCH, new EmbeddingAsyncFixedBatchService(EmbeddingModel.BAIDU_EMBEDDING_BGE_LARGE_ZH_BATCH));
            EMBEDDING_SERVICE_MAP.put(EmbeddingModel.BAIDU_EMBEDDING_TAO_8K_BATCH, new EmbeddingAsyncFixedBatchService(EmbeddingModel.BAIDU_EMBEDDING_TAO_8K_BATCH));
            EMBEDDING_SERVICE_MAP.put(EmbeddingModel.KINGDEE_EMBEDDING_BATCH, new EmbeddingAsyncFixedBatchService(EmbeddingModel.KINGDEE_EMBEDDING_BATCH));
        }
    }
}

