/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.milvus;

import java.util.EnumMap;
import java.util.Map;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.rag.milvus.AzureMilvusDao;
import kd.ai.gai.core.rag.milvus.BaiduBgeLargeZhMilvusDao;
import kd.ai.gai.core.rag.milvus.BaiduTao8kMilvusDao;
import kd.ai.gai.core.rag.milvus.BaiduV1MilvusDao;
import kd.ai.gai.core.rag.milvus.KingdeeMilvusDao;
import kd.ai.gai.core.rag.milvus.MilvusBaseDao;
import kd.ai.gai.core.rag.milvus.MilvusClientFactory;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MilvusService {
    private static Log LOGGER = LogFactory.getLog(MilvusService.class);

    private MilvusService() {
    }

    public static MilvusBaseDao getExecutor(LLM llm) {
        LOGGER.info("get milvus getExecutor");
        MilvusBaseDao milvusDao = (MilvusBaseDao)Holder.MILVUS_DAO_MAP.get((Object)llm);
        if (milvusDao != null) {
            return milvusDao;
        }
        throw new KDBizException("\u4e0d\u652f\u6301\u7684Embdedding\u6a21\u578b");
    }

    public static void destroy() {
        MilvusClientFactory.getClient().close();
    }

    private static class Holder {
        private static final Map<LLM, MilvusBaseDao> MILVUS_DAO_MAP = new EnumMap<LLM, MilvusBaseDao>(LLM.class);

        private Holder() {
        }

        static {
            LOGGER.info("milvus azureMilvusDao init start");
            AzureMilvusDao azureMilvusDao = new AzureMilvusDao();
            azureMilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.AZURE_EMBEDDING_ADA_002, azureMilvusDao);
            LOGGER.info("milvus azureMilvusDao init end");
            LOGGER.info("milvus baiduMilvusDao init start");
            BaiduV1MilvusDao baiduV1MilvusDao = new BaiduV1MilvusDao();
            baiduV1MilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.BAIDU_EMBEDDING_V1, baiduV1MilvusDao);
            LOGGER.info("milvus baiduMilvusDao init end");
            LOGGER.info("milvus kingdeeMilvusDao init start");
            KingdeeMilvusDao kingdeeMilvusDao = new KingdeeMilvusDao();
            kingdeeMilvusDao.init();
            MILVUS_DAO_MAP.put(LLM.KINGDEE_EMBEDDING, kingdeeMilvusDao);
            LOGGER.info("milvus kingdeeMilvusDao init end");
            LOGGER.info("milvus baiduTao8k init start");
            BaiduTao8kMilvusDao baiduTao8k = new BaiduTao8kMilvusDao();
            baiduTao8k.init();
            MILVUS_DAO_MAP.put(LLM.BAIDU_EMBEDDING_TAO_8K, baiduTao8k);
            LOGGER.info("milvus baiduTao8k init end");
            LOGGER.info("milvus baiduBeglargeZh init start");
            BaiduBgeLargeZhMilvusDao baiduBeglargeZh = new BaiduBgeLargeZhMilvusDao();
            baiduBeglargeZh.init();
            MILVUS_DAO_MAP.put(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, baiduBeglargeZh);
            LOGGER.info("milvus baiduBeglargeZh init end");
        }
    }
}

