/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.parser;

import java.util.EnumMap;
import java.util.Map;
import kd.ai.gai.core.domain.dto.ChunkConfig;
import kd.ai.gai.core.enuz.repo.ChunkRule;
import kd.ai.gai.core.enuz.repo.RepoSourceType;
import kd.ai.gai.core.rag.parser.AbstractParser;
import kd.ai.gai.core.rag.parser.JsonCommunityBaseParser;
import kd.ai.gai.core.rag.parser.JsonKdCodeBaseParser;
import kd.ai.gai.core.rag.parser.PdfBaseParser;
import kd.ai.gai.core.rag.parser.PdfNonAnalysisParser;
import kd.ai.gai.core.rag.parser.TextCustomizeChunkParser;
import kd.ai.gai.core.rag.parser.TextSimpleBaseParser;
import kd.bos.exception.KDBizException;

public class FileParserFactory {
    private FileParserFactory() {
    }

    public static AbstractParser getService(ChunkConfig config) {
        ChunkRule.ChunkStrategy splitType = config.getChunkRule().getChunkStrategy();
        RepoSourceType repoSourceType = config.getRepoSourceType();
        if (ChunkRule.ChunkStrategy.BASE_FIXED_LENGTH == splitType) {
            return (AbstractParser)Holder.SPLIT_SERVICE_lENGTH_MAP.get((Object)repoSourceType);
        }
        if (ChunkRule.ChunkStrategy.CUSTOMIZE == splitType) {
            return (AbstractParser)Holder.SPLIT_SERVICE_CUSTOMIZE_MAP.get((Object)splitType);
        }
        throw new KDBizException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u89e3\u6790\u7c7b\u578b");
    }

    private static class Holder {
        private static final Map<RepoSourceType, AbstractParser> SPLIT_SERVICE_lENGTH_MAP = new EnumMap<RepoSourceType, AbstractParser>(RepoSourceType.class);
        private static final Map<ChunkRule.ChunkStrategy, AbstractParser> SPLIT_SERVICE_CUSTOMIZE_MAP;

        private Holder() {
        }

        static {
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_TEXT, new TextSimpleBaseParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_PDF, new PdfBaseParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_PDF_NON_ANALYSIS, new PdfNonAnalysisParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.QA_COMMUNITY, new JsonCommunityBaseParser());
            SPLIT_SERVICE_lENGTH_MAP.put(RepoSourceType.GEN_CODE, new JsonKdCodeBaseParser());
            SPLIT_SERVICE_CUSTOMIZE_MAP = new EnumMap<ChunkRule.ChunkStrategy, AbstractParser>(ChunkRule.ChunkStrategy.class);
            SPLIT_SERVICE_CUSTOMIZE_MAP.put(ChunkRule.ChunkStrategy.CUSTOMIZE, new TextCustomizeChunkParser());
        }
    }
}

