/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.rag.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.rag.chunk.ChunkInput;
import kd.ai.gai.core.rag.parser.AbstractParser;
import kd.ai.gai.core.service.ChunkService;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import org.apache.commons.io.IOUtils;

public class JsonKdCodeBaseParser
extends AbstractParser {
    @Override
    public boolean opreate(ChunkInput file) throws IOException {
        String text;
        try (InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(file.getFilePath());){
            text = IOUtils.toString((InputStream)in, (String)"UTF-8");
        }
        JSONObject chunkJson = JSON.parseObject((String)text);
        String source = chunkJson.getString("source");
        JSONArray codes = chunkJson.getJSONArray("codes");
        if (!"kd_code_gen".equals(source) || codes.isEmpty()) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.REPO_FILE_SOURCE_KDCODE_ERR), new Object[0]);
        }
        ArrayList<Chunk> result = new ArrayList<Chunk>(10);
        for (int i = 0; i < codes.size(); ++i) {
            JSONObject code = (JSONObject)codes.get(i);
            String annotation = code.getString("annotation");
            String content = code.getString("content");
            Chunk chunk = new Chunk(file, 1);
            chunk.setOrder(i + 1);
            chunk.setChunk(annotation);
            chunk.setKdCode(content);
            result.add(chunk);
            ChunkService.batchConditionInsert(result);
        }
        ChunkService.batchInsert(result);
        return true;
    }
}

