/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import java.util.Objects;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class AssistantService {
    public static final String TABLE = "gai_gpt_assistant_config";
    public static final String ID = "id";
    public static final long DEFAULT_ID = 10000L;
    public static final String ASS_PICTURE = "picture";
    public static final String ASS_NAME = "name";
    public static final String ASS_OPENING_SPEECH = "openingspeech";
    public static final String ASS_INTRODUCE = "introduce";
    public static final String ASS_PERSONA = "persona";
    public static final String ASS_PROMPT = "prompt";
    public static final String queryKey = "id,picture,name,introduce,prompt,openingspeech,persona,openingspeech";

    public static Assistant getDefault() {
        try {
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)TABLE, (String)queryKey, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)10000L)});
            if (objs == null || objs.length == 0) {
                objs = BusinessDataServiceHelper.load((String)TABLE, (String)queryKey, (QFilter[])new QFilter[]{new QFilter(ID, ">", (Object)0L)});
            }
            if (Objects.isNull(objs)) {
                return null;
            }
            DynamicObject obj = objs[objs.length - 1];
            obj.set(ID, (Object)10000L);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            Assistant assistant = new Assistant();
            assistant.setName(obj.getString(ASS_NAME));
            assistant.setPicture(obj.getString(ASS_PICTURE));
            assistant.setIntroduce(obj.getString(ASS_INTRODUCE));
            assistant.setOpeningSpeech(obj.getString(ASS_OPENING_SPEECH));
            assistant.setPersona(obj.getString(ASS_PERSONA));
            assistant.setId((Long)obj.getPkValue());
            DynamicObject dynamicObject = obj.getDynamicObject(ASS_PROMPT);
            if (dynamicObject != null) {
                assistant.setPromptId(dynamicObject.getLong(0));
            }
            if (StringUtils.isEmpty((CharSequence)assistant.getPicture())) {
                String pictureUrl = UrlService.getDomainContextUrl() + "/kingdee/gai/images/pc/icon/Cosmic_48_48.png";
                assistant.setPicture(pictureUrl);
            }
            return assistant;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Assistant getAssistantWithDefault() {
        Assistant assistant = AssistantService.getDefault();
        if (assistant == null) {
            assistant = new Assistant();
            assistant.setPicture("/kingdee/gai/images/pc/agent/avatar/common_agent.png");
            assistant.setId(10000L);
            assistant.setName(ResManager.loadKDString((String)"\u82cd\u7a79GPT", (String)"gai.core.assistant.default.name", (String)"ai-gai-core", (Object[])new Object[0]));
            assistant.setIntroduce(ResManager.loadKDString((String)"\u901a\u7528\u57fa\u7840\u52a9\u624b", (String)"gai.core.assistant.default.introduce", (String)"ai-gai-plugin", (Object[])new Object[0]));
            assistant.setOpeningSpeech(ResManager.loadKDString((String)"\u4f60\u597d\uff0c\u6211\u662f\u82cd\u7a79GPT\u52a9\u624b", (String)"gai.core.assistant.default.prologue", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)assistant.getPicture())) {
            assistant.setPicture("/kingdee/gai/images/pc/agent/avatar/common_agent.png");
        }
        return assistant;
    }
}

