/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.ai.gai.core.domain.dto.ChatInfo;
import kd.ai.gai.core.domain.dto.ChatItem;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class ChatHistoryService {
    private static final String TABLE_INFO = "gai_chat_info";
    private static final String ID = "id";
    private static final String INFO_USER_ID = "userid";
    private static final String INFO_ASSISTANT_ID = "assistantid";
    private static final String INFO_SESSION_ID = "sessionid";
    private static final String INFO_CHAT_SESSION_ID = "chatsessionid";
    private static final String TABLE_ITEM = "gai_chat_item";
    private static final String ITEM_CHAT_INFO_ID = "chatinfoid";
    private static final String ITEM_TYPE = "type";
    private static final String ITEM_CONTENT = "content_tag";
    private static final String ITEM_TIME = "time";
    private static final Log logger = LogFactory.getLog(ChatHistoryService.class);

    private ChatHistoryService() {
    }

    private static String getChatPromptKey(String chatSessionId) {
        return chatSessionId + "_P_L";
    }

    private static String getChatInfoIdKey(String chatSessionId) {
        return chatSessionId + "_C_ID";
    }

    public static void save(String chatSessionId, long promptId, List<ChatItem> chatItemList) {
        long chatInfoId;
        Context context = FlowCacheData.getContext(chatSessionId);
        if (context == null) {
            logger.error("chat session id : {} \u6ca1\u6709\u4e0a\u4e0b\u6587", (Object)chatSessionId);
            return;
        }
        IAppCache chatSessionCache = EngineCache.getAppCache(chatSessionId);
        String chatInfoIdStr = (String)chatSessionCache.get(ChatHistoryService.getChatInfoIdKey(chatSessionId), String.class);
        if (chatInfoIdStr == null) {
            ChatInfo chatInfo = new ChatInfo(context.getUserId(), context.getAssistant().getId(), context.getGlobalSessionId(), chatSessionId);
            chatInfoId = ChatHistoryService.saveOrGetChatInfo(chatInfo);
            chatSessionCache.put(ChatHistoryService.getChatInfoIdKey(chatSessionId), (Object)String.valueOf(chatInfoId));
            chatSessionCache.remove(ChatHistoryService.getChatPromptKey(chatSessionId));
        } else {
            chatInfoId = Long.parseLong(chatInfoIdStr);
        }
        List<UserHistoryMessage> list = ChatHistoryService.getPromptHistoryFromCache(chatSessionId, promptId);
        for (ChatItem chatItem : chatItemList) {
            if (chatItem.getType() == 0) {
                list.add(new UserHistoryMessage(chatItem.getContent(), "", chatItem.getTime()));
                continue;
            }
            list.add(new UserHistoryMessage("", chatItem.getContent(), chatItem.getTime()));
        }
        chatSessionCache.put(String.valueOf(promptId), (Object)JSON.toJSONString(list));
        Set<Long> promptSet = ChatHistoryService.getChatHistoryPromptSet(chatSessionId);
        promptSet.add(promptId);
        ArrayList<Long> promptList = new ArrayList<Long>(promptSet);
        chatSessionCache.put(ChatHistoryService.getChatPromptKey(chatSessionId), (Object)JSON.toJSONString(promptList));
        ChatHistoryService.saveChatItemList(chatInfoId, chatItemList);
    }

    private static Set<Long> getChatHistoryPromptSet(String chatSessionId) {
        IAppCache chatSessionCache = EngineCache.getAppCache(chatSessionId);
        String chatHistoryStr = (String)chatSessionCache.get(ChatHistoryService.getChatPromptKey(chatSessionId), String.class);
        List promptList = chatHistoryStr == null ? new ArrayList() : JSON.parseArray((String)chatHistoryStr, Long.class);
        return new HashSet<Long>(promptList);
    }

    public static UserHistoryMessage[] getByChatSessionId(int count, String chatSessionId) {
        if (count <= 0) {
            return new UserHistoryMessage[0];
        }
        Set<Long> promptSet = ChatHistoryService.getChatHistoryPromptSet(chatSessionId);
        if (promptSet.isEmpty()) {
            return new UserHistoryMessage[0];
        }
        ArrayList<UserHistoryMessage> userHistoryMessages = new ArrayList<UserHistoryMessage>();
        for (long promptId : promptSet) {
            userHistoryMessages.addAll(ChatHistoryService.getPromptHistoryFromCache(chatSessionId, promptId));
        }
        if (userHistoryMessages.isEmpty()) {
            return new UserHistoryMessage[0];
        }
        UserHistoryMessage[] data = new UserHistoryMessage[userHistoryMessages.size()];
        data = userHistoryMessages.toArray(data);
        Arrays.sort(data, (r1, r2) -> {
            if (r1.getTime() == r2.getTime()) {
                return StringUtils.isNotEmpty((String)r1.getUser()) ? 1 : 0;
            }
            return Long.compare(r1.getTime(), r2.getTime());
        });
        if (data.length <= count) {
            return data;
        }
        UserHistoryMessage[] retChatData = new UserHistoryMessage[count];
        System.arraycopy(data, data.length - count, retChatData, 0, count);
        return retChatData;
    }

    public static List<UserHistoryMessage> getPromptHistory(String chatSessionId, int count, long promptId) {
        if (count <= 0) {
            return Collections.emptyList();
        }
        return ChatHistoryService.getLast(ChatHistoryService.getPromptHistoryFromCache(chatSessionId, promptId), count);
    }

    private static List<UserHistoryMessage> getLast(List<UserHistoryMessage> data, int count) {
        int from;
        if (data.size() <= count) {
            return data;
        }
        ArrayList<UserHistoryMessage> retChatData = new ArrayList<UserHistoryMessage>(count);
        for (int i = from = data.size() - count; i < data.size(); ++i) {
            retChatData.add(data.get(i));
        }
        return retChatData;
    }

    private static List<UserHistoryMessage> getPromptHistoryFromCache(String chatSessionId, long promptId) {
        String dataStr = (String)EngineCache.getAppCache(chatSessionId).get(String.valueOf(promptId), String.class);
        return ChatHistoryService.toUserHistoryMessageList(dataStr);
    }

    private static List<UserHistoryMessage> toUserHistoryMessageList(String dataStr) {
        ArrayList<UserHistoryMessage> list = dataStr != null ? JSON.parseArray((String)dataStr, UserHistoryMessage.class) : new ArrayList<UserHistoryMessage>();
        return list;
    }

    public static List<UserHistoryMessage> getByAssistantId(int count, long userId, long assistantId) {
        String sql = String.format("select top %s b.fid, b.ftype, b.fcontent_tag, b.ftime from t_gai_chat_info a join t_gai_chat_item b on a.fid = b.fchatinfoid where a.fuserid = ? and a.fassistantid = ? order by b.ftime desc", count);
        Object[] param = new Object[]{userId, assistantId};
        return ChatHistoryService.queryUserHistory(sql, param);
    }

    private static List<UserHistoryMessage> queryUserHistory(String sql, Object[] param) {
        ResultSetHandler<List<UserHistoryMessage>> action = new ResultSetHandler<List<UserHistoryMessage>>(){

            public List<UserHistoryMessage> handle(ResultSet rs) throws Exception {
                ArrayList<UserHistoryMessage> userHistoryList = new ArrayList<UserHistoryMessage>(10);
                while (rs.next()) {
                    UserHistoryMessage message = new UserHistoryMessage();
                    int type = rs.getInt("ftype");
                    String content = rs.getString("fcontent_tag");
                    long time = rs.getLong("ftime");
                    if (type != 0) {
                        message.setAssistant(content);
                        message.setUser("");
                    } else {
                        message.setUser(content);
                        message.setAssistant("");
                    }
                    message.setTime(time);
                    userHistoryList.add(message);
                }
                return userHistoryList;
            }
        };
        List userHistoryList = (List)DB.query((DBRoute)new DBRoute("aidb"), (String)sql, (Object[])param, (ResultSetHandler)action);
        Collections.reverse(userHistoryList);
        return userHistoryList;
    }

    private static long saveOrGetChatInfo(ChatInfo chatInfo) {
        long chatInfoId;
        String chatSessionId = chatInfo.getChatSessionId();
        DynamicObjectCollection objs = QueryServiceHelper.query((String)TABLE_INFO, (String)ID, (QFilter[])new QFilter[]{new QFilter(INFO_CHAT_SESSION_ID, "=", (Object)chatSessionId)});
        if (null == objs || objs.isEmpty()) {
            chatInfoId = DB.genLongId((String)TABLE_INFO);
            DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)TABLE_INFO);
            dObj.set(ID, (Object)chatInfoId);
            dObj.set(INFO_USER_ID, (Object)chatInfo.getUserId());
            dObj.set(INFO_ASSISTANT_ID, (Object)chatInfo.getAssistantId());
            dObj.set(INFO_SESSION_ID, (Object)chatInfo.getSessionId());
            dObj.set(INFO_CHAT_SESSION_ID, (Object)chatInfo.getChatSessionId());
            DynamicObject[] objects = new DynamicObject[]{dObj};
            SaveServiceHelper.save((DynamicObject[])objects);
        } else {
            chatInfoId = ((DynamicObject)objs.get(0)).getLong(ID);
        }
        return chatInfoId;
    }

    private static void saveChatItemList(long chatInfoId, List<ChatItem> chatItemList) {
        DynamicObject[] objects = new DynamicObject[chatItemList.size()];
        long[] ids = DB.genLongIds((String)TABLE_ITEM, (int)chatItemList.size());
        for (int i = 0; i < chatItemList.size(); ++i) {
            DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)TABLE_ITEM);
            ChatItem chatItem = chatItemList.get(i);
            dObj.set(ID, (Object)ids[i]);
            dObj.set(ITEM_CHAT_INFO_ID, (Object)chatInfoId);
            dObj.set(ITEM_TYPE, (Object)chatItem.getType());
            if (chatItem.getContent() != null) {
                dObj.set(ITEM_CONTENT, (Object)chatItem.getContent().replace("\u0000", ""));
            } else {
                dObj.set(ITEM_CONTENT, (Object)"");
            }
            dObj.set(ITEM_TIME, (Object)chatItem.getTime());
            objects[i] = dObj;
        }
        SaveServiceHelper.save((DynamicObject[])objects);
    }
}

