/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ChunkService {
    private static final int batchInsertSize = 100;

    public static void insert(List<Chunk> chunkList) {
        if (null == chunkList || chunkList.isEmpty()) {
            return;
        }
        DynamicObject[] objects = new DynamicObject[chunkList.size()];
        for (int i = 0; i < chunkList.size(); ++i) {
            Chunk chunk = chunkList.get(i);
            DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)"gai_text_chunk");
            dObj.set("repoid", (Object)chunk.getRepositoryId());
            dObj.set("fileid", (Object)chunk.getFileId());
            dObj.set("pageid", (Object)chunk.getPage());
            dObj.set("order", (Object)chunk.getOrder());
            dObj.set("source", (Object)chunk.getSource());
            dObj.set("businessId", (Object)chunk.getBusinessId());
            dObj.set("title", (Object)chunk.getTitle());
            dObj.set("url", (Object)chunk.getUrl());
            dObj.set("status", (Object)"A");
            dObj.set("content_tag", (Object)chunk.getChunk());
            dObj.set("code_content_tag", (Object)chunk.getKdCode());
            dObj.set("strigtotal", (Object)chunk.getChunk().length());
            objects[i] = dObj;
        }
        SaveServiceHelper.save((DynamicObject[])objects);
    }

    public static boolean batchInsert(List<Chunk> chunkList) {
        return ChunkService.batchConditionInsert(chunkList, true);
    }

    public static boolean batchConditionInsert(List<Chunk> chunkList) {
        return ChunkService.batchConditionInsert(chunkList, false);
    }

    public static boolean batchConditionInsert(List<Chunk> chunkList, boolean offBatchRule) {
        if (null == chunkList || chunkList.isEmpty()) {
            return false;
        }
        int count = chunkList.size();
        if (count % 100 == 0 || offBatchRule) {
            ChunkService.insert(chunkList);
            chunkList.clear();
            return true;
        }
        return false;
    }

    public static Chunk getChunkInfoById(Long chunkId) {
        MainEntityType chunkTextType = MetadataServiceHelper.getDataEntityType((String)"gai_text_chunk");
        DynamicObject chunkInfo = BusinessDataServiceHelper.loadSingle((Object)chunkId, (DynamicObjectType)chunkTextType);
        String kdCode = chunkInfo.getString("code_content_tag");
        Chunk chunk = new Chunk((Long)chunkInfo.getPkValue(), chunkInfo.getLong("repoid"), chunkInfo.getLong("fileid"), chunkInfo.getInt("pageid"), chunkInfo.getInt("order"), chunkInfo.getString("content_tag"), StringUtils.isBlank((CharSequence)kdCode) ? null : kdCode, chunkInfo.getLong("businessId"), chunkInfo.getString("title"), chunkInfo.getString("url"), chunkInfo.getString("source"));
        return chunk;
    }

    public static Long getFileIdByChunkId(Long chunkId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)chunkId, (String)"gai_text_chunk");
        if (obj == null) {
            return null;
        }
        return obj.getLong("fileid");
    }

    public static List<Chunk> getByList(List<Long> chunkIdList) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        if (chunkIdList != null && chunkIdList.size() > 0) {
            DynamicObject[] dChunks;
            Object[] ids = chunkIdList.toArray(new Long[0]);
            MainEntityType chunkTextType = MetadataServiceHelper.getDataEntityType((String)"gai_text_chunk");
            for (DynamicObject chunkInfo : dChunks = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)chunkTextType)) {
                String kdCode = chunkInfo.getString("code_content_tag");
                Chunk chunk = new Chunk((Long)chunkInfo.getPkValue(), chunkInfo.getLong("repoid"), chunkInfo.getLong("fileid"), chunkInfo.getInt("pageid"), chunkInfo.getInt("order"), chunkInfo.getString("content_tag"), StringUtils.isBlank((CharSequence)kdCode) ? null : kdCode, chunkInfo.getLong("businessId"), chunkInfo.getString("title"), chunkInfo.getString("url"), chunkInfo.getString("source"));
                chunks.add(chunk);
            }
        }
        return chunks;
    }

    public static List<Chunk> getSimpleChunkByIds(List<Long> chunkIdList) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        if (chunkIdList != null && chunkIdList.size() > 0) {
            DynamicObject[] dChunks;
            Object[] ids = chunkIdList.toArray(new Long[0]);
            MainEntityType chunkTextType = MetadataServiceHelper.getDataEntityType((String)"gai_text_chunk");
            for (DynamicObject dChunk : dChunks = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)chunkTextType)) {
                Chunk chunk = new Chunk((Long)dChunk.getPkValue(), dChunk.getLong("repoid"), dChunk.getLong("fileid"), dChunk.getInt("pageid"), dChunk.getInt("order"));
                chunks.add(chunk);
            }
        }
        return chunks;
    }
}

