/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.service.llm.AliQWService;
import kd.ai.gai.core.service.llm.AwsAnthropicClaudeMessagesService;
import kd.ai.gai.core.service.llm.Azure35Service;
import kd.ai.gai.core.service.llm.Azure40Service;
import kd.ai.gai.core.service.llm.BaiduErnieService;
import kd.ai.gai.core.service.llm.BaiduErnieWithSystemService;
import kd.ai.gai.core.service.llm.KimiService;
import kd.ai.gai.core.service.llm.KingdeeModelService;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.service.llm.TencentService;
import kd.ai.gai.core.service.llm.XmindAiGpt40Service;
import kd.ai.gai.core.service.llm.XunFeiService;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LlmServiceFactory {
    private static final Log logger = LogFactory.getLog(LlmServiceFactory.class);

    public static LlmService getExecutor(LLM llm, boolean stream) {
        LlmService llmService = (LlmService)Holder.map.get((Object)llm);
        if (llmService != null) {
            return llmService;
        }
        throw new KDBizException("\u5c1a\u672a\u6ce8\u518c\u7684\u6a21\u578b");
    }

    private static class Holder {
        private static Map<LLM, LlmService> map = new EnumMap<LLM, LlmService>(LLM.class);
        private static List<LlmService> list = new ArrayList<LlmService>();

        private Holder() {
        }

        static {
            list.add(new AwsAnthropicClaudeMessagesService(99000, LLM.AWS_ANTHROPIC_CLAUDE_MESSAGES));
            list.add(new XmindAiGpt40Service(127000, LLM.XMINDAI_GPT_40));
            list.add(new Azure35Service(115000, LLM.AZURE_GPT_35));
            list.add(new Azure40Service(127000, LLM.AZURE_GPT_40));
            list.add(new BaiduErnieService(3000, LLM.BAIDU_ERNIE_BOT));
            list.add(new BaiduErnieService(7000, LLM.BAIDU_ERNIE_TURBO));
            list.add(new BaiduErnieService(7000, LLM.BAIDU_ERNIE_BOT_PRO));
            list.add(new BaiduErnieWithSystemService(3000, LLM.BAIDU_ERNIE_BOT_WITH_SYSTEM));
            list.add(new AliQWService(3000, LLM.ALI_GPT_QWEN));
            list.add(new KingdeeModelService(3000, LLM.KINGDEE_CODE_GPT));
            list.add(new KingdeeModelService(3000, LLM.KINGDEE_FINANCE_GPT));
            list.add(new TencentService(15000, LLM.TENCENT_HUNYUAN_PRO));
            list.add(new XunFeiService(70007, LLM.XUNFEI_SPARK_V3));
            list.add(new KimiService(7000, LLM.MOONSHOT_V1_8K));
            list.add(new KimiService(30000, LLM.MOONSHOT_V1_32K));
            list.add(new KimiService(127000, LLM.MOONSHOT_V1_128K));
            list.add(new Azure35Service(3000, LLM.DOUBAO_PRO_4K));
            list.add(new Azure35Service(30000, LLM.DOUBAO_PRO_32K));
            list.add(new Azure35Service(127000, LLM.DOUBAO_PRO_128K));
            for (LlmService llmService : list) {
                map.put(llmService.getLlm(), llmService);
            }
            list = null;
        }
    }
}

