/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.domain.vo.SuggestedAskData;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.util.GaiLicenseUtils;
import kd.ai.gai.core.util.PinyinUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.property.GroupProp;
import kd.bos.list.query.QueryFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class ProcessService {
    private static final Log logger = LogFactory.getLog(ProcessService.class);
    private static final String ENTITY_PROCESS = "gai_process";
    private static final String ENTITY_OPERATION = "gai_operation";
    private static final String ID = "id";
    private static final String APP_ID = "app";
    private static final String PROCESS_NUMBER = "number";
    private static final String PROCESS_USE_ORG = "useorg";
    private static final String PROCESS_NAME = "name";
    private static final String PROCESS_DES = "desc";
    private static final String PROCESS_FLOW = "flow";
    private static final String PROCESS_BLGS = "blgids";
    private static final String PROCESS_GROUP = "group";
    private static final String PROCESS_SERVICE_DES = "serviceDesc";
    private static final String PROCESS_SERVICE_DES2 = "servicedesc";
    private static final String PROCESS_CONFIG = "process_configs";
    private static final String CONFIG_NODEID = "process_nodeid";
    private static final String CONFIG_NAME = "process_name";
    private static final String CONFIG_TYPE = "process_type";
    private static final String CONFIG_DESC = "process_desc";
    private static final String KEY_APP = "app";
    private static final String KEY_OPERATION = "operationtype";
    private static final String APP_GAI = "gai";

    public static List<Process> getProcessList() {
        ArrayList<Process> processList = new ArrayList<Process>(10);
        Map processMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_PROCESS, null);
        if (processMap != null) {
            for (Map.Entry entry : processMap.entrySet()) {
                processList.add(ProcessService.convertFromDynamicObject((DynamicObject)entry.getValue()));
            }
        }
        return processList;
    }

    public static List<Skill> getProcessListData() {
        return ProcessService.getProcessListData(false, null);
    }

    public static List<Skill> getProcessListData(boolean isPublish, List<String> blgs) {
        DynamicObject[] objs;
        ArrayList<Skill> processListData = new ArrayList<Skill>(10);
        QFilter[] qFilters = null;
        if (isPublish) {
            qFilters = new QFilter[]{new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr())};
        }
        if ((objs = BusinessDataServiceHelper.load((String)ENTITY_PROCESS, (String)"id,name,number,desc,servicedesc,modifytime,blgids ", qFilters, (String)"modifytime desc")) != null) {
            for (DynamicObject obj : objs) {
                String[] blgidArr;
                String blgids = obj.getString(PROCESS_BLGS);
                if (StringUtils.isEmpty((CharSequence)blgids)) {
                    blgids = "606";
                }
                for (String item : blgidArr = blgids.split(",")) {
                    if (blgs != null && !blgs.contains(item)) continue;
                    processListData.add(new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null));
                }
            }
        }
        return processListData;
    }

    public static List<Skill> getProcessListDataByAppid(String appId, List<String> blgs) {
        DynamicObject app;
        logger.info("\u83b7\u53d6\u6d41\u7a0b\u5217\u8868:AppNumber:{},\u7528\u6237\u6743\u9650{}", (Object)appId, blgs);
        ArrayList<Skill> processListData = new ArrayList<Skill>(10);
        if (blgs == null) {
            return processListData;
        }
        if (StringUtils.isNotBlank((CharSequence)appId) && (app = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)ID, (QFilter[])new QFilter[]{new QFilter(PROCESS_NUMBER, "=", (Object)appId)})) != null) {
            String id = app.getString(ID);
            QFilter filter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr());
            QFilter[] qFilters = new QFilter[]{filter.and("app.fbasedataid", "=", (Object)id)};
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)ENTITY_PROCESS, (String)"id,name,number,desc,servicedesc,entryentity_suggestedask.seq,entryentity_suggestedask.question,modifytime,blgids ", (QFilter[])qFilters, (String)"modifytime desc");
            if (objs != null) {
                for (DynamicObject obj : objs) {
                    String[] blgidArr;
                    String blgids = obj.getString(PROCESS_BLGS);
                    if (StringUtils.isEmpty((CharSequence)blgids)) {
                        blgids = "606";
                    }
                    for (String item : blgidArr = blgids.split(",")) {
                        if (!blgs.contains(item)) continue;
                        Skill skill = new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null);
                        DynamicObjectCollection suggestedAskDataObjs = obj.getDynamicObjectCollection("entryentity_suggestedask");
                        ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>(suggestedAskDataObjs.size());
                        for (DynamicObject dObjSuggestedAskData : suggestedAskDataObjs) {
                            SuggestedAskData askData = new SuggestedAskData(dObjSuggestedAskData.getPkValue().toString(), dObjSuggestedAskData.getString("question"));
                            suggestedAskDataList.add(askData);
                        }
                        skill.setSuggestedAsks(suggestedAskDataList);
                        processListData.add(skill);
                    }
                }
            }
        }
        StringBuilder sqlBuild = new StringBuilder();
        sqlBuild.append("SELECT A.fid, A.fname,  A.fnumber, A.fdesc,A.fservicedesc,A.fmodifytime,A.fblgids ");
        sqlBuild.append("FROM t_gai_process A ");
        sqlBuild.append("LEFT JOIN t_gai_process_app B ON A.fid = B.fid ");
        sqlBuild.append("WHERE A.fpublish='1' and B.fid IS NULL ");
        sqlBuild.append("order by A.fmodifytime desc ");
        DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)sqlBuild.toString(), (Object[])new Object[0], resultSet -> {
            block0: while (resultSet.next()) {
                String[] blgidArr;
                String blgids = resultSet.getString("fblgids");
                if (StringUtils.isEmpty((CharSequence)blgids)) {
                    blgids = "606";
                }
                for (String item : blgidArr = blgids.split(",")) {
                    if (!blgs.contains(item)) continue;
                    processListData.add(new Skill(resultSet.getLong("fid") + "", resultSet.getString("fnumber"), resultSet.getString("fname"), resultSet.getString("fdesc"), resultSet.getString("fservicedesc"), null));
                    continue block0;
                }
            }
            return null;
        });
        processListData.sort(Comparator.comparing(o -> PinyinUtils.getPinYin(o.getName()).toLowerCase()));
        logger.info(String.format("\u83b7\u53d6\u6d41\u7a0b\u5217\u8868:AppNumber:%s,\u7528\u6237\u6743\u9650 %s,\u6280\u80fd\u6e05\u5355\uff1a%s", appId, blgs, JSON.toJSONString(processListData)));
        return processListData;
    }

    public static Process getProcessById(long id) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_PROCESS);
        if (obj == null) {
            return null;
        }
        return ProcessService.convertFromDynamicObject(obj);
    }

    public static List<Skill> getProcessByIds(List<Long> ids) {
        DynamicObject[] objs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)ENTITY_PROCESS).getDataEntityType());
        if (objs == null) {
            return null;
        }
        ArrayList<Skill> processListData = new ArrayList<Skill>();
        for (DynamicObject obj : objs) {
            String blgids = obj.getString(PROCESS_BLGS);
            if (StringUtils.isEmpty((CharSequence)blgids)) {
                blgids = "606";
            }
            Skill skill = new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null);
            skill.setType(Skill.Type.PROCESS);
            DynamicObjectCollection suggestedAskDataObjs = obj.getDynamicObjectCollection("entryentity_suggestedask");
            ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>(suggestedAskDataObjs.size());
            for (DynamicObject dObjSuggestedAskData : suggestedAskDataObjs) {
                SuggestedAskData askData = new SuggestedAskData(dObjSuggestedAskData.getPkValue().toString(), dObjSuggestedAskData.getString("question"));
                suggestedAskDataList.add(askData);
            }
            skill.setSuggestedAsks(suggestedAskDataList);
            processListData.add(skill);
        }
        return processListData;
    }

    public static Skill getProcessByIdAndOther(long id, String appNumber, List<String> blgs) {
        Skill skill = null;
        long userId = RequestContext.get().getCurrUserId();
        if (blgs == null) {
            blgs = GaiLicenseUtils.getUserBLG(userId);
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_PROCESS);
        logger.info("id: {}, blg: {}", (Object)appNumber, blgs);
        if (obj == null) {
            logger.info("obj is null");
            return null;
        }
        if (!obj.getString("enable").equals(EnableEnum.YES.getKeyStr())) {
            logger.info("obj is closed");
            return null;
        }
        ArrayList<String> appNumberListInDb = new ArrayList<String>();
        MulBasedataDynamicObjectCollection appObject = (MulBasedataDynamicObjectCollection)obj.get("app");
        if (!appObject.isEmpty()) {
            for (DynamicObject dynamicObject : appObject) {
                if (dynamicObject == null || dynamicObject.get(1) == null) continue;
                String appNumberInDb = ((DynamicObject)dynamicObject.get(1)).getString(PROCESS_NUMBER);
                appNumberListInDb.add(appNumberInDb);
            }
        }
        if (appNumber != null && !appNumberListInDb.isEmpty() && !appNumberListInDb.contains(appNumber)) {
            logger.info("appRealIdInDb is null");
            return null;
        }
        String blgids = obj.getString(PROCESS_BLGS);
        if (StringUtils.isEmpty((CharSequence)blgids)) {
            blgids = "606";
        }
        String[] blgidArr = blgids.split(",");
        String version = LicenseServiceHelper.getProductVersion();
        skill = new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null);
        DynamicObjectCollection suggestedAskDataObjs = obj.getDynamicObjectCollection("entryentity_suggestedask");
        ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>(suggestedAskDataObjs.size());
        for (DynamicObject dObjSuggestedAskData : suggestedAskDataObjs) {
            SuggestedAskData askData = new SuggestedAskData(dObjSuggestedAskData.getPkValue().toString(), dObjSuggestedAskData.getString("question"));
            suggestedAskDataList.add(askData);
        }
        skill.setSuggestedAsks(suggestedAskDataList);
        return skill;
    }

    public static Process getProcessByNumber(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter(PROCESS_NUMBER, "=", (Object)number)};
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)ENTITY_PROCESS, (String)"id,number,name,desc,servicedesc,flow,useorg,blgids", (QFilter[])filters);
        if (objs == null || objs.length == 0) {
            return null;
        }
        return ProcessService.convertFromDynamicObject(objs[0]);
    }

    public static String getAppIdByProcess(long processId) {
        DynamicObject app;
        Long opId;
        DynamicObject op;
        String type;
        String flowStr;
        String appId = "";
        Process process = ProcessService.getProcessById(processId);
        String string = flowStr = process == null ? "" : process.getFlow();
        if (StringUtils.isBlank((CharSequence)flowStr)) {
            return appId;
        }
        Flow flow = JsonUtil.fromBase64String(flowStr);
        List<Action> actionList = flow.actionList();
        if (actionList == null || actionList.isEmpty()) {
            return appId;
        }
        ArrayList<Long> operationIds = new ArrayList<Long>(10);
        for (Action action : actionList) {
            if (!(action instanceof JavaPluginAction) || ((JavaPluginAction)action).getActionId() == 0L) continue;
            operationIds.add(((JavaPluginAction)action).getActionId());
        }
        if (operationIds.isEmpty()) {
            return appId;
        }
        Map opMap = BusinessDataServiceHelper.loadFromCache((Object[])operationIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_OPERATION));
        Iterator iterator = operationIds.iterator();
        while (iterator.hasNext() && (!"0".equals(type = (op = (DynamicObject)opMap.get(opId = (Long)iterator.next())).getString(KEY_OPERATION)) || APP_GAI.equals(appId = (app = op.getDynamicObject("app")).getString(PROCESS_NUMBER)))) {
        }
        return appId;
    }

    private static Process convertFromDynamicObject(DynamicObject obj) {
        if (obj == null) {
            return null;
        }
        DynamicObject org = (DynamicObject)obj.get(PROCESS_USE_ORG);
        long useorg = org == null ? 0L : org.getLong(ID);
        return new Process(obj.getLong(ID), obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), useorg, obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES), obj.getString(PROCESS_FLOW), obj.getString(PROCESS_BLGS));
    }

    private static List<Long> getProcessGroupIdArr(Long[] groupIds, boolean includeChild) {
        DynamicObject[] dObjParentGroups = BusinessDataServiceHelper.load((Object[])groupIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ENTITY_PROCESS));
        ArrayList<Long> idArrays = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : dObjParentGroups) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ENTITY_PROCESS);
            String longNumber = dynamicObject.getString("longnumber");
            idArrays.add((Long)dynamicObject.getPkValue());
            if (!includeChild) continue;
            IQuery query = QueryFactory.createQuery();
            GroupProp groupProp = (GroupProp)entityType.getProperty(PROCESS_GROUP);
            List childIdsArrays = query.getChildsId(groupProp, longNumber);
            for (String childGroupId : childIdsArrays) {
                long id = Long.parseLong(childGroupId);
                idArrays.add(id);
            }
        }
        return idArrays;
    }

    public static List<Skill> getProcessListDataByGroupIds(Long[] groupIds) {
        ArrayList<Skill> processListData = new ArrayList<Skill>(10);
        QFilter[] qFilters = null;
        qFilters = new QFilter[]{new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr()), new QFilter(PROCESS_GROUP, "in", (Object)groupIds)};
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)ENTITY_PROCESS, (String)"id,group,name,number,desc,servicedesc,modifytime,blgids,entryentity_suggestedask.seq,entryentity_suggestedask.question,", (QFilter[])qFilters, (String)"modifytime desc, entryentity_suggestedask.seq asc");
        if (objs != null) {
            for (DynamicObject obj : objs) {
                Skill processData = new Skill(obj.getLong(ID) + "", obj.getString(PROCESS_NUMBER), obj.getString(PROCESS_NAME), obj.getString(PROCESS_DES), obj.getString(PROCESS_SERVICE_DES2), null);
                DynamicObjectCollection suggestedAskDataObjs = obj.getDynamicObjectCollection("entryentity_suggestedask");
                ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>(suggestedAskDataObjs.size());
                for (DynamicObject dObjSuggestedAskData : suggestedAskDataObjs) {
                    SuggestedAskData askData = new SuggestedAskData(dObjSuggestedAskData.getPkValue().toString(), dObjSuggestedAskData.getString("question"));
                    suggestedAskDataList.add(askData);
                }
                processData.setSuggestedAsks(suggestedAskDataList);
                processListData.add(processData);
            }
        }
        return processListData;
    }
}

