/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.domain.vo.RepoOcrAsyncVO;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.repo.ChunkRule;
import kd.ai.gai.core.rag.milvus.MilvusService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;

public class RepoService {
    private static Log log = LogFactory.getLog(RepoService.class);
    private static final String DB_KEY = "aidb";
    private static final String repos_file_parh = "doc_manage.file_path";
    private static final String repos_file_status = "doc_manage.file_status";

    public static RepoVO getRepoInfo(long repoId) {
        DynamicObject repoObj = BusinessDataServiceHelper.loadSingle((Object)repoId, (String)"gai_repo_info");
        String name = repoObj.getString("name");
        String number = repoObj.getString("number");
        String status = repoObj.getString("status");
        String indexMethod = repoObj.getString("index_method");
        String type = repoObj.getString("type");
        LLM llm = LLM.parse(indexMethod);
        RepoVO repo = new RepoVO(number, name, status, type, llm);
        DynamicObjectCollection files = repoObj.getDynamicObjectCollection("doc_manage");
        ArrayList<RepoFileVO> fileVOList = new ArrayList<RepoFileVO>(files.size());
        for (DynamicObject file : files) {
            String fileName = file.getString("file_name");
            String fileStatus = file.getString("file_status");
            String filePath = file.getString("file_path");
            String fileSource = file.getString("file_source");
            String url = file.getString("url");
            String title = file.getString("title");
            RepoFileVO repoFileVO = new RepoFileVO(fileName, fileStatus, filePath, fileSource, url, title);
            fileVOList.add(repoFileVO);
        }
        repo.setFiles(fileVOList);
        return repo;
    }

    public static RepoFileVO getFileByChunkId(long chunkId) {
        DynamicObject gaiChunk = QueryServiceHelper.queryOne((String)"gai_text_chunk", (String)"fileid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)chunkId)});
        long fileId = gaiChunk.getLong("fileid");
        String sql = "select ffilename,ffilesource,ftitle,furl,ffilepath,ffilestatus from t_gai_repo_doc_manage  where fentryid=? ";
        RepoFileVO fileVO = (RepoFileVO)DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)sql, (Object[])new Object[]{fileId}, resultSet -> {
            if (resultSet.next()) {
                String filename = resultSet.getString("ffilename");
                String filesource = resultSet.getString("ffilesource");
                String title = resultSet.getString("ftitle");
                String url = resultSet.getString("furl");
                String filepath = resultSet.getString("ffilepath");
                String filestatus = resultSet.getString("ffilestatus");
                return new RepoFileVO(filename, filestatus, filepath, filesource, url, title);
            }
            return null;
        });
        return fileVO;
    }

    public static List<RepoFileVO> getFilesByChunkIds(List<Long> chunkIds) {
        DynamicObjectCollection fileIds = QueryServiceHelper.query((String)"gai_text_chunk", (String)"fileid", (QFilter[])new QFilter[]{new QFilter("id", "in", chunkIds)});
        if (fileIds != null && fileIds.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>();
            for (DynamicObject fileId : fileIds) {
                long id = fileId.getLong("fileid");
                ids.add(id);
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select fentryid,ftitle,ffilename,ffilestatus,ffilesource,ffilepath,furl from t_gai_repo_doc_manage ");
            sql.append("where fentryid in (");
            sql.append(String.join((CharSequence)",", Collections.nCopies(ids.size(), "?")));
            sql.append(')');
            List fileVOs = (List)DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)sql.toString(), (Object[])ids.toArray(), resultSet -> {
                ArrayList<RepoFileVO> repoFileVOS = new ArrayList<RepoFileVO>(fileIds.size());
                while (resultSet.next()) {
                    String filename = resultSet.getString("ffilename");
                    String filesource = resultSet.getString("ffilesource");
                    String url = resultSet.getString("furl");
                    String title = resultSet.getString("ftitle");
                    String filepath = resultSet.getString("ffilepath");
                    String filestatus = resultSet.getString("ffilestatus");
                    long fileId = resultSet.getLong("fentryid");
                    RepoFileVO repoFileVO = new RepoFileVO(filename, filestatus, filesource, filepath, url, title, fileId);
                    repoFileVOS.add(repoFileVO);
                }
                return repoFileVOS;
            });
            return fileVOs;
        }
        return new ArrayList<RepoFileVO>(1);
    }

    public static List<RepoFileVO> getFilesByFileIds(List<Long> fileIds) {
        if (fileIds == null || fileIds.size() == 0) {
            return new ArrayList<RepoFileVO>(1);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fentryid,ftitle,ffilename,ffilestatus,ffilesource,ffilepath,furl from t_gai_repo_doc_manage ");
        sql.append("where fentryid in (");
        sql.append(String.join((CharSequence)",", Collections.nCopies(fileIds.size(), "?")));
        sql.append(')');
        return (List)DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)sql.toString(), (Object[])fileIds.toArray(), resultSet -> {
            ArrayList<RepoFileVO> repoFileVOS = new ArrayList<RepoFileVO>(fileIds.size());
            while (resultSet.next()) {
                String filename = resultSet.getString("ffilename");
                String filesource = resultSet.getString("ffilesource");
                String url = resultSet.getString("furl");
                String title = resultSet.getString("ftitle");
                String filepath = resultSet.getString("ffilepath");
                String filestatus = resultSet.getString("ffilestatus");
                long fileId = resultSet.getLong("fentryid");
                RepoFileVO repoFileVO = new RepoFileVO(filename, filestatus, filesource, filepath, url, title, fileId);
                repoFileVOS.add(repoFileVO);
            }
            return repoFileVOS;
        });
    }

    public static void delRepoByIds(Object[] repoIds) {
        RepoService.delRepoByIds(repoIds, true);
    }

    public static void delRepoByIds(Object[] repoIds, boolean delFile) {
        String selectFields = String.join((CharSequence)",", "id", "index_method", repos_file_parh, repos_file_status);
        DynamicObjectCollection repos = QueryServiceHelper.query((String)"gai_repo_info", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)repoIds)});
        for (DynamicObject repo : repos) {
            DynamicObjectCollection dids;
            List<Long> ids;
            String path = repo.getString(repos_file_parh);
            Object repoId = repo.get("id");
            String indexMethod = repo.getString("index_method");
            LLM llm = LLM.parse(indexMethod);
            if (delFile && StringUtils.isNotEmpty((String)path)) {
                FileServiceFactory.getAttachmentFileService().delete(path);
            }
            if ((ids = (dids = QueryServiceHelper.query((String)"gai_text_chunk", (String)"id", (QFilter[])new QFilter[]{new QFilter("repoid", "=", repoId)})).stream().map(o -> o.getLong("id")).collect(Collectors.toList())) != null && ids.size() > 0) {
                MilvusService.getExecutor(llm).delByIdList(ids);
                continue;
            }
            log.info("\u77e5\u8bc6\u5e93[{}]\u6587\u672c\u5757\u6570\u4e3a0", repoId);
        }
        DeleteServiceHelper.delete((String)"gai_text_chunk", (QFilter[])new QFilter[]{new QFilter("repoid", "in", (Object)repoIds)});
    }

    public static void updateRepoDocStatus(long repoId, long fileId) {
        String fileIdFiled = String.format("%s.%s", "doc_manage", "id");
        String fileProcessFiled = String.format("%s.%s", "doc_manage", "progress");
        DynamicObject repoInfo = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)fileProcessFiled, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId).and(fileIdFiled, "=", (Object)fileId)});
        BigDecimal fileProcess = repoInfo.getBigDecimal(fileProcessFiled);
        float process = RepoService.algoRepoTaskFileProcess(fileId);
        float lastProcess = Math.max(fileProcess.floatValue(), process);
        if (lastProcess < 1.0f) {
            DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"update t_gai_repo_doc_manage set ffilestatus=?,fprogress=?,flog=?  where fentryid=? and ffilestatus not in (?,?)", (Object[])new Object[]{"F", Float.valueOf(lastProcess), "running", fileId, "G", "C"});
            log.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u77e5\u8bc6\u5e93:{},fileId:{}\u6587\u4ef6\u672a\u5b8c\u6210\u5411\u91cf\u5316\uff0c\u8fdb\u5ea6\uff1a{}% ", new Object[]{repoId, fileId, Float.valueOf(lastProcess * 100.0f)});
        } else {
            DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"update t_gai_repo_doc_manage set ffilestatus=?,fprogress=?,flog=?  where fentryid=?", (Object[])new Object[]{"C", Float.valueOf(1.0f), "success", fileId});
            log.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u77e5\u8bc6\u5e93:{},fileId:{} \u6587\u4ef6\u5b8c\u6210 ", (Object)repoId, (Object)fileId);
        }
        RepoService.updateRepoStatus(repoId);
    }

    public static void updateRepoStatus(long repoId) {
        boolean noSuccess = QueryServiceHelper.exists((String)"gai_repo_info", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId).and(String.format("%s.%s", "doc_manage", "file_status"), "!=", (Object)"C")});
        if (noSuccess) {
            log.info(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u77e5\u8bc6\u5e93:%s,\u6587\u4ef6\u672a\u5168\u5b8c\u6210\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0\u77e5\u8bc6\u5e93\u72b6\u6001 ", repoId));
        } else {
            DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"update t_gai_repo_info set fstatus=?,fmodifytime=? where fid = ?", (Object[])new Object[]{"C", new Timestamp(System.currentTimeMillis()), repoId});
            log.info(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u77e5\u8bc6\u5e93:%s,\u5b8c\u6210 ", repoId));
        }
    }

    public static float algoRepoTaskProcess(long repoId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from t_gai_repo_doc_manage ");
        sql.append("where fid = ? ");
        String totalCountSql = sql.toString();
        int totalCount = (Integer)DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)totalCountSql, (Object[])new Object[]{repoId}, resultSet -> {
            resultSet.next();
            return resultSet.getInt(1);
        });
        float process = 0.0f;
        if (totalCount != 0) {
            sql.append("and ffilestatus = ? ;");
            String countSql = sql.toString();
            int sucessCount = (Integer)DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)countSql, (Object[])new Object[]{repoId, "C"}, resultSet -> {
                resultSet.next();
                return resultSet.getInt(1);
            });
            process = (float)Math.round((float)sucessCount * 100.0f / (float)totalCount) / 100.0f;
        }
        return process;
    }

    public static float algoRepoTaskFileProcess(long fileId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from t_gai_text_chunk ");
        sql.append("where ffileid = ? ");
        String totalCountSql = sql.toString();
        int totalCount = (Integer)DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)totalCountSql, (Object[])new Object[]{fileId}, resultSet -> {
            resultSet.next();
            return resultSet.getInt(1);
        });
        float process = 0.0f;
        if (totalCount != 0) {
            sql.append("and fstatus = ? ;");
            String countSql = sql.toString();
            int sucessCount = (Integer)DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)countSql, (Object[])new Object[]{fileId, "C"}, resultSet -> {
                resultSet.next();
                return resultSet.getInt(1);
            });
            process = (float)Math.round((float)sucessCount * 100.0f / (float)totalCount) / 100.0f;
        }
        return process;
    }

    public static void checkRepoTaskTime(long repoId, float process, long modiftTime) {
        long currentTime = System.currentTimeMillis();
        if (process >= 1.0f) {
            DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"update t_gai_repo_info set fstatus=? ,fmodifytime=?  where fid=?", (Object[])new Object[]{"C", new Timestamp(currentTime), repoId});
            log.info("\u3010GPT-\u77e5\u8bc6\u5e93\u3011repoId:{},\u4efb\u52a1\u5b8c\u6210\uff0c\u66f4\u65b0\u77e5\u8bc6\u5e93\u72b6\u6001\u4e3a\u53ef\u7528", (Object)repoId);
        } else if (currentTime - modiftTime >= 0x6DDD00L) {
            log.info("\u3010GPT-\u77e5\u8bc6\u5e93\u3011repoId:{},\u4efb\u52a1\u6267\u884c\u8d85\u65f6\uff0c\u66f4\u65b0\u77e5\u8bc6\u5e93\u72b6\u6001\u4e3a\u5931\u8d25", (Object)repoId);
            String logMsg = "\u4efb\u52a1\u6267\u884c\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3010\u6587\u6863\u5904\u7406\u3011\u6267\u884c\u4efb\u52a1";
            DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"update t_gai_repo_info set fstatus=?,fmodifytime=? where fid = ?", (Object[])new Object[]{"D", new Timestamp(System.currentTimeMillis()), repoId});
            DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"update t_gai_repo_doc_manage set ffilestatus=? ,flog=? where fid=? and ffilestatus=?", (Object[])new Object[]{"D", logMsg, repoId, "B"});
            DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"update t_gai_repo_doc_manage set ffilestatus=?,flog=?  where fid=? and ffilestatus=?", (Object[])new Object[]{"G", logMsg, repoId, "F"});
        }
    }

    public static RepoOcrAsyncVO getRepoInfoByFileId(long fileId) {
        String selectFields = String.join((CharSequence)",", "id", "index_method", "chunk_strategy");
        DynamicObject repo = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("doc_manage.id", "=", (Object)fileId)});
        String indexMethod = repo.getString("index_method");
        Long repoId = repo.getLong("id");
        LLM llm = LLM.parse(indexMethod);
        String chunkStrategy = repo.getString("chunk_strategy");
        ChunkRule.ChunkStrategy strategy = ChunkRule.ChunkStrategy.parse(chunkStrategy);
        RepoOcrAsyncVO repoOcrAsyncVO = new RepoOcrAsyncVO(repoId, llm, strategy);
        return repoOcrAsyncVO;
    }
}

