/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.AgentSample;
import kd.ai.gai.core.domain.dto.agent.Question;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.domain.vo.SuggestedAskData;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.jetbrains.annotations.NotNull;

public class SkillService {
    public static final String ID = "id";
    public static final String ORDER = "order";
    public static final String SKILL_ID = "skillid";
    public static final String SKILL_TYPE = "skilltype";
    public static final String SKILL_SERVICE_DES = "skillservicedesc";
    private static final String QUERY_4_LIST_FIELDS = "id,skillid,skilltype,skillservicedesc,order";
    public static final String SKILL_FORM_ID = "gai_skill";
    public static final String AGENT_FORM_ID = "gai_agent";
    public static final String PROCESS_FORM_ID = "gai_process";
    private static final Log log = LogFactory.getLog(SkillService.class);

    public static Skill Agent2Skill4Save(Agent agent, int order) {
        Skill skill = new Skill();
        skill.setId(agent.getAgentId() + "");
        skill.setType(Skill.Type.AGENT);
        skill.setOrder(order);
        skill.setServiceDes(agent.getDescription());
        return skill;
    }

    public static void clearAndSaveList(List<Skill> skillList) {
        QFilter[] qFilters = new QFilter[]{new QFilter(ID, ">", (Object)0L)};
        DeleteServiceHelper.delete((String)SKILL_FORM_ID, (QFilter[])qFilters);
        DynamicObject[] dynamicObjects = new DynamicObject[skillList.size()];
        for (int i = 0; i < skillList.size(); ++i) {
            Skill skill = skillList.get(i);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)SKILL_FORM_ID);
            dynamicObject.set(ORDER, (Object)skill.getOrder());
            dynamicObject.set(SKILL_SERVICE_DES, (Object)skill.getServiceDes());
            dynamicObject.set(SKILL_ID, (Object)skill.getId());
            dynamicObject.set(SKILL_TYPE, (Object)skill.getType());
            dynamicObjects[i] = dynamicObject;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public static List<Skill> getList(String appId, List<String> blgs, boolean forceShowAllAgent) {
        return SkillService.getSkills(appId, blgs, forceShowAllAgent);
    }

    public static List<Skill> getList(String appId, List<String> blgs) {
        return SkillService.getSkills(appId, blgs, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<Skill> getSkills(String appId, List<String> blgs, boolean forceShowAllAgent) {
        QFilter[] qFilters = new QFilter[]{new QFilter(ID, ">", (Object)0L)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)SKILL_FORM_ID, (String)QUERY_4_LIST_FIELDS, (QFilter[])qFilters, (String)ORDER);
        ArrayList<Skill> skills = new ArrayList<Skill>();
        Iterator iterator = dynamicObjects.iterator();
        while (true) {
            String skillServiceDesc;
            Skill skill;
            DynamicObject dynamicObject;
            block9: {
                if (!iterator.hasNext()) {
                    return skills;
                }
                dynamicObject = (DynamicObject)iterator.next();
                skill = new Skill();
                long skillId = dynamicObject.getLong(SKILL_ID);
                long originId = dynamicObject.getLong(ID);
                skillServiceDesc = dynamicObject.getString(SKILL_SERVICE_DES);
                skill.setOriginId(originId);
                skill.setId(skillId + "");
                String skillType = dynamicObject.getString(SKILL_TYPE);
                if (Skill.Type.AGENT.name().equals(skillType)) {
                    List<AgentSample> agents = AgentService.getAgentListByIdList(Collections.singletonList(skillId), appId, forceShowAllAgent);
                    if (!agents.isEmpty()) {
                        AgentSample agent = agents.get(0);
                        skill.setType(Skill.Type.AGENT);
                        skill.setName(agent.getName());
                        skill.setNumber(agent.getNumber());
                        skill.setPicture(agent.getPicture());
                        skill.setBgColor(agent.getBgColor());
                        skill.setPrologue(agent.getPrologue());
                        List<Question> questions = agent.getQuestionList();
                        ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>();
                        if (questions != null) {
                            for (Question question : questions) {
                                suggestedAskDataList.add(new SuggestedAskData("1", question.getValue()));
                            }
                            skill.setSuggestedAsks(suggestedAskDataList);
                        }
                        break block9;
                    } else {
                        log.info("\u8fd9\u4e2aid\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684agent\uff0c\u5df2\u7ecf\u5ffd\u7565", (Object)skillId);
                        continue;
                    }
                }
                skill.setType(Skill.Type.PROCESS);
                Skill process = ProcessService.getProcessByIdAndOther(skillId, appId, blgs);
                if (process != null) {
                    skill.setName(process.getName());
                    skill.setNumber(process.getNumber());
                    skill.setSuggestedAsks(process.getSuggestedAsks());
                    skill.setPrologue(process.getPrologue());
                } else {
                    log.info("\u8fd9\u4e2aid\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684process\uff0c\u5df2\u7ecf\u5ffd\u7565", (Object)skillId);
                    continue;
                }
            }
            skill.setServiceDes(skillServiceDesc);
            skill.setOrder(dynamicObject.getInt(ORDER));
            skills.add(skill);
        }
    }
}

