/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.enuz.ForwardType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.util.StringUtils;

public class WebSocketService {
    private WebSocketService() {
    }

    public static void push2RootPage(String k, String pageId, String rootPageId, String globalSessionId, Map<String, Object> resultVoMap) {
        if (pageId == null && rootPageId == null) {
            return;
        }
        ArrayList commands = new ArrayList();
        ArrayList subList = new ArrayList();
        HashMap<String, Object> subCom = new HashMap<String, Object>();
        subCom.put("k", StringUtils.isEmpty((String)k) ? "gpt_gai" : k);
        subCom.put("v", resultVoMap);
        subList.add(subCom);
        HashMap<String, Serializable> command1 = new HashMap<String, Serializable>();
        command1.put("a", Character.valueOf('u'));
        command1.put("p", subList);
        commands.add(command1);
        HashMap<String, Object> arg = new HashMap<String, Object>();
        arg.put("pageId", pageId);
        arg.put("actions", commands);
        HashMap<String, Object> commandMain = new HashMap<String, Object>();
        commandMain.put("a", "sendDynamicFormAction");
        commandMain.put("p", Collections.singletonList(arg));
        RequestContext.get().setGlobalSessionId(globalSessionId);
        PushMessage message = new PushMessage(PushMessageRange.RootPage, rootPageId, (Object)JSON.toJSONString(Collections.singleton(commandMain), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        PushServiceHelper.push((PushMessage)message);
    }

    public static void pushStreamChat(String k, String pageId, String rootPageId, String globalSessionId, String chatSessionId, String taskId, String flowId, int index, String chat, boolean mergeLastMessageCard) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildChat(true, chatSessionId, taskId, flowId, index, chat, mergeLastMessageCard);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushChat(String k, String pageId, String taskId, String rootPageId, String globalSessionId, String chatSessionId, String chat) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildChat(false, chatSessionId, taskId, 0, chat, false);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushStreamDown(String k, String pageId, String rootPageId, String globalSessionId, String chatSessionId, String taskId, String flowId, String chatMsgJustRecord, String messageId) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildStreamDone(chatSessionId, taskId, flowId, chatMsgJustRecord, messageId);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushMultiMsg(String k, String pageId, String rootPageId, String globalSessionId, String chatSessionId, boolean replaceLast, List<MsgNodeMessage.MessageElement> messageElementList, String messageId) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildMultiMsg(chatSessionId, replaceLast, messageElementList, messageId);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushForward(String k, String pageId, String rootPageId, String globalSessionId, String chatSessionId, ForwardType type, String actionKey, String forwardMsgKey) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildForward(chatSessionId, type, actionKey, forwardMsgKey);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushErrMsg(String k, String pageId, String rootPageId, String globalSessionId, String code, String msg, String chatSessionId) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildErrMsg(code, msg, chatSessionId);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushFakeOk(String k, String pageId, String rootPageId, String globalSessionId, String code, String msg, String chatSessionId) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildFakeErrMsg(code, msg, chatSessionId);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushWaiting(String k, String pageId, String rootPageId, String globalSessionId, long flowId, String taskId, String chatSessionId) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildWaiting(flowId, taskId, chatSessionId);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushWaitingDone(String k, String pageId, String rootPageId, String globalSessionId, String chatSessionId) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildWaitingDone(chatSessionId);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushChangeConfig(String k, String pageId, String rootPageId, String globalSessionId, GaiInitConfig gaiInitConfig) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildChangeConfig(gaiInitConfig);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushResult(String k, String pageId, String rootPageId, String globalSessionId, String resultActionType, Object data) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildResult(resultActionType, data);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, resultVoMap);
    }

    public static void pushChatBottom(String k, String pageId, String rootPageId, String globalSessionId, ContextData contextData) {
        Map<String, Object> contextMsg = ResultVoHelper.buildChatBottom(contextData);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, contextMsg);
    }

    public static void pushIdentifySkill(String k, String pageId, String rootPageId, String globalSessionId, String skillId) {
        Map<String, Object> contextMsg = ResultVoHelper.buildIdentifySkill(skillId);
        WebSocketService.push2RootPage(k, pageId, rootPageId, globalSessionId, contextMsg);
    }
}

