/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import kd.ai.gai.core.domain.dto.agent.AiccAgentConfig;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AgentServiceService {
    private static final Log log = LogFactory.getLog(AgentServiceService.class);

    public static boolean agentVersionHasChange(String number, String newVersion) {
        DynamicObject agentServiceDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.AICC_AGENT_SERVICE.getId(), (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (agentServiceDo != null) {
            String agentVersion = agentServiceDo.getString("agentversion");
            if (StringUtils.equalsIgnoreCase((CharSequence)agentVersion, (CharSequence)newVersion)) {
                return false;
            }
            agentServiceDo.set("agentversion", (Object)newVersion);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentServiceDo});
        }
        return true;
    }

    public static AiccAgentConfig getAgentService(String number) {
        AiccAgentConfig aiccAgentConfig = null;
        DynamicObject agentServiceDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.AICC_AGENT_SERVICE.getId(), (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (agentServiceDo != null) {
            aiccAgentConfig = new AiccAgentConfig();
            aiccAgentConfig.setNumber(number);
            aiccAgentConfig.setServerUrl(agentServiceDo.getString("serverurl"));
            aiccAgentConfig.setLlm(agentServiceDo.getString("llm"));
            aiccAgentConfig.setLlmStyle(agentServiceDo.getString("llmstyle"));
            aiccAgentConfig.setAgentVersion(agentServiceDo.getString("agentversion"));
        }
        return aiccAgentConfig;
    }

    public static Boolean agentIsAvail(String number) {
        AiccAgentConfig aiccAgentConfig = AgentServiceService.getAgentService(number);
        if (aiccAgentConfig != null && StringUtils.isNotEmpty((CharSequence)aiccAgentConfig.getServerUrl()) && StringUtils.isNotEmpty((CharSequence)aiccAgentConfig.getLlm()) && StringUtils.isNotEmpty((CharSequence)aiccAgentConfig.getLlmStyle())) {
            return true;
        }
        return false;
    }
}

