/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.java_websocket.client.WebSocketClient;
import com.alipay.api.java_websocket.handshake.ServerHandshake;
import java.net.URI;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.ai.gai.core.api.websocket.query.RequiredParams;
import kd.ai.gai.core.api.websocket.query.WsRequestParams;
import kd.ai.gai.core.domain.dto.agent.AiccAgentConfig;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.AgentServiceService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.StringUtils;

public class AgentServicesWebSocketService {
    private static final Log log = LogFactory.getLog(AgentServicesWebSocketService.class);
    private static final int MAX_TIME_OUT = 60000;
    public static final AgentServicesWebSocketService agentServicesWebSocketService = new AgentServicesWebSocketService();
    BlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();
    private AgentServicesWebSocketClient agentServicesWebSocketClient;

    private AgentServicesWebSocketService() {
    }

    public void onMessage(WsRequestParams wsRequestParams) {
        if (wsRequestParams.isRequest()) {
            RequiredParams requiredParams = wsRequestParams.getRequiredParams();
            String requestId = requiredParams.getRequestId();
            long startTime = KDDateUtils.now().getTime();
            while (KDDateUtils.now().getTime() - startTime < 60000L) {
                try {
                    String message = this.messageQueue.poll(100L, TimeUnit.MILLISECONDS);
                    boolean toBreak = false;
                    while (message != null) {
                        String responeRequestId = this.processMessage(message);
                        if (StringUtils.equalsIgnoreCase((CharSequence)requestId, (CharSequence)responeRequestId)) {
                            Date now = KDDateUtils.now();
                            log.info("\u3010type:{}\u3011, requestId:{} receive response with [{}, {}](cost:{}s)", new Object[]{requiredParams.getType(), requiredParams.getRequestId(), KDDateFormatUtils.getDateTimeFormat().format(new Date(startTime)), KDDateFormatUtils.getDateTimeFormat().format(new Date()), (now.getTime() - startTime) / 1000L});
                            toBreak = true;
                        }
                        message = this.messageQueue.poll(100L, TimeUnit.MILLISECONDS);
                    }
                    if (!toBreak) continue;
                    break;
                }
                catch (Exception e) {
                    log.error(String.format("\u3010type:%s\u3011, requestId:%s onMessage error : %s", requiredParams.getType(), requiredParams.getRequestId(), e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public String processMessage(String message) {
        log.info("processMessage: {}", (Object)message);
        String requestId = "";
        WsRequestParams wsRequestParams = (WsRequestParams)JSON.parseObject((String)message, WsRequestParams.class);
        RequiredParams requiredParams = wsRequestParams.getRequiredParams();
        String newVersion = requiredParams.getVersion();
        log.info("agentService newVersion:{}", (Object)newVersion);
        JSONObject bizParams = (JSONObject)wsRequestParams.getBizParams();
        if (wsRequestParams.isResponse()) {
            String type;
            BaseResult baseResult = (BaseResult)JSONObject.toJavaObject((JSON)bizParams, BaseResult.class);
            switch (type = requiredParams.getType()) {
                case "response.agent.list.all": {
                    boolean versionHasChange = AgentServiceService.agentVersionHasChange("gai_agent", newVersion);
                    log.info("agentService versionHasChange:{}", (Object)versionHasChange);
                    if (!versionHasChange) break;
                    JSONObject dataJo = baseResult.getDataAsJSONObject();
                    AgentService.syncPresetAgent(dataJo);
                    break;
                }
            }
            requestId = wsRequestParams.getRequiredParams().getRequestId();
        }
        return requestId;
    }

    public void connect() {
        try {
            AiccAgentConfig aiccAgentConfig = AgentServiceService.getAgentService("gai_agent");
            String serverUrl = aiccAgentConfig.getServerUrl();
            String wsUri = String.format("%s/agent/services", serverUrl);
            this.agentServicesWebSocketClient = new AgentServicesWebSocketClient(this.messageQueue, new URI(wsUri));
            boolean succ = this.agentServicesWebSocketClient.connectBlocking(10L, TimeUnit.SECONDS);
            if (succ) {
                log.info("connect success : ");
            }
        }
        catch (Throwable e) {
            log.error(String.format("error : %s", e.getMessage()), e);
        }
    }

    public void sendMsg(WsRequestParams wsRequestParams) {
        try {
            String msg = wsRequestParams.toJSONString();
            log.info("sendMsg: {}", (Object)msg);
            this.connect();
            this.agentServicesWebSocketClient.send(msg);
            this.onMessage(wsRequestParams);
        }
        catch (Throwable e) {
            log.error(String.format("error : %s", e.getMessage()), e);
        }
    }

    static class AgentServicesWebSocketClient
    extends WebSocketClient {
        private static final Log log = LogFactory.getLog(AgentServicesWebSocketClient.class);
        private static final String ERROR_FLAG = "ERROR:";
        BlockingQueue<String> messageQueue;

        public AgentServicesWebSocketClient(BlockingQueue<String> messageQueue, URI serverUri) {
            super(serverUri);
            this.messageQueue = messageQueue;
        }

        public void onMessage(String text) {
            boolean b = this.messageQueue.offer(text);
            if (!b) {
                log.warn("offer message: {} error", (Object)text);
            }
        }

        public void onError(Exception e) {
            boolean b = this.messageQueue.offer(ERROR_FLAG + e.getMessage());
            if (!b) {
                log.warn("offer error to queue ");
            }
        }

        public void onOpen(ServerHandshake serverHandshake) {
            log.warn("agentServices onOpen ");
        }

        public void onClose(int code, String status, boolean b) {
            log.warn("agentServices onClose ");
        }
    }
}

