/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.agent.FileInfo;
import kd.ai.gai.core.domain.dto.agent.GaiMsgConfig;
import kd.ai.gai.core.domain.dto.agent.annotations.BaseAnnotation;
import kd.ai.gai.core.domain.dto.agent.annotations.FileAnnotation;
import kd.ai.gai.core.domain.dto.agent.annotations.FormAnnotation;
import kd.ai.gai.core.domain.dto.agent.annotations.IframeAnnotation;
import kd.ai.gai.core.domain.dto.agent.annotations.ImgAnnotation;
import kd.ai.gai.core.domain.dto.agent.annotations.ImgUrlAnnotation;
import kd.ai.gai.core.domain.dto.agent.annotations.RepoDocAnnotation;
import kd.ai.gai.core.domain.dto.agent.annotations.UrlAnnotation;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.enuz.AttType;
import kd.ai.gai.core.enuz.agent.GaiTagEnum;
import kd.ai.gai.core.service.FilePreviewService;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.agent.FileService;
import kd.ai.gai.core.util.EntityUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class AnnotationService {
    private static final Log log = LogFactory.getLog(AnnotationService.class);

    public static String clearTags(String contentTag) {
        String regex = "\\[\\w+].*?\\[/\\w+]";
        return contentTag.replaceAll(regex, "");
    }

    public static GaiMsgConfig parseGaiMsgConfig(String contentTag) {
        String patternString;
        Pattern pattern;
        Matcher matcher;
        if (StringUtils.isNotEmpty((CharSequence)contentTag) && (matcher = (pattern = Pattern.compile(patternString = "\\[gaimsgconfig\\](.*?)\\[/gaimsgconfig\\]")).matcher(contentTag)).find()) {
            String str = matcher.group(1);
            if (StringUtils.isNotEmpty((CharSequence)(str = StringEscapeUtils.unescapeJson((String)str))) && StrUtils.isValidJson(str)) {
                return (GaiMsgConfig)JSONObject.parseObject((String)str, GaiMsgConfig.class);
            }
        }
        return null;
    }

    public static List<String> parseTagAndContentList(String contentTag) {
        ArrayList<String> gaitagAndContentList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)contentTag)) {
            String regex = "\\[(gaimsgconfig|gaitag|gaiimg|gaiimgurl|gaifile|gaiurl|gaiiframe|gairepodoc|gaiform)](.*?)\\[/\\1]";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(contentTag);
            while (matcher.find()) {
                String tag = matcher.group(1);
                String tagContent = matcher.group(2);
                gaitagAndContentList.add(String.format("[%s]%s[/%s]", tag, tagContent, tag));
            }
        }
        return gaitagAndContentList;
    }

    public static String parseTagAndAppendChatSessionId(String contentTag, String chatSessionId, Long sessionId) {
        if (StringUtils.isNotEmpty((CharSequence)contentTag)) {
            String regex = "\\[(gaiiframe)](.*?)\\[/\\1]";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(contentTag);
            while (matcher.find()) {
                String tag = matcher.group(1);
                String tagContent = matcher.group(2);
                String newTagContent = tagContent;
                if (StringUtils.contains((CharSequence)newTagContent, (CharSequence)"gaiChatSessionId")) continue;
                newTagContent = StringUtils.contains((CharSequence)newTagContent, (CharSequence)"?") ? String.format("%s&%s=%s&%s=%s", newTagContent, "gaiChatSessionId", chatSessionId, "gaiSessionId", sessionId) : String.format("%s?%s=%s&%s=%s", newTagContent, "gaiChatSessionId", chatSessionId, chatSessionId, "gaiSessionId", sessionId);
                contentTag = StringUtils.replace((String)contentTag, (String)String.format("[%s]%s[/%s]", tag, tagContent, tag), (String)String.format("[%s]%s[/%s]", tag, newTagContent, tag));
            }
        }
        return contentTag;
    }

    public static List<BaseAnnotation> parseMessageAnnotations(String contentTag) {
        ArrayList<BaseAnnotation> annotations = new ArrayList<BaseAnnotation>();
        if (StringUtils.isNotEmpty((CharSequence)contentTag)) {
            String regex = "\\[(gaimsgconfig|gaitag|gaiimg|gaiimgurl|gaifile|gaiurl|gaiiframe|gairepodoc|gaiform)](.*?)\\[/\\1]";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(contentTag);
            ArrayList<Long> gaiimgFileIdList = new ArrayList<Long>();
            ArrayList<Long> gaifileIdList = new ArrayList<Long>();
            ArrayList<Long> gairepodocFileIdList = new ArrayList<Long>();
            while (matcher.find()) {
                String tag = matcher.group(1);
                String tagContent = matcher.group(2);
                GaiTagEnum gaiTagEnum = GaiTagEnum.valueOf(tag);
                switch (gaiTagEnum) {
                    case gaiimg: {
                        gaiimgFileIdList.add(Long.parseLong(tagContent));
                        break;
                    }
                    case gaiimgurl: {
                        AnnotationService.parseImgUrl(annotations, tagContent);
                        break;
                    }
                    case gaifile: {
                        gaifileIdList.add(Long.parseLong(tagContent));
                        break;
                    }
                    case gaiurl: {
                        AnnotationService.parseUrl(annotations, tagContent);
                        break;
                    }
                    case gaiiframe: {
                        AnnotationService.parseIframe(annotations, tagContent);
                        break;
                    }
                    case gairepodoc: {
                        gairepodocFileIdList.add(Long.parseLong(tagContent));
                        break;
                    }
                    case gaiform: {
                        AnnotationService.parseForm(annotations, tagContent);
                        break;
                    }
                }
            }
            AnnotationService.parseFile(annotations, gaifileIdList);
            AnnotationService.parseImg(annotations, gaiimgFileIdList);
            AnnotationService.parseRepoDoc(annotations, gairepodocFileIdList);
        }
        return annotations;
    }

    private static void parseRepoDoc(List<BaseAnnotation> annotations, List<Long> fileIdList) {
        List<RepoFileVO> repoFileVOList = RepoService.getFilesByFileIds(fileIdList);
        if (CollectionUtils.isNotEmpty(repoFileVOList)) {
            Map<Long, RepoFileVO> repoFileVOMap = repoFileVOList.stream().collect(Collectors.toMap(RepoFileVO::getFileId, a -> a));
            for (Long fileId : fileIdList) {
                ContextData.Item item;
                String fileName;
                RepoFileVO repoFileVO = repoFileVOMap.get(fileId);
                log.info("\u67e5\u8be2\u5230\u6587\u4ef6({}):{}.", (Object)fileId, JSON.toJSON((Object)repoFileVO));
                int order = fileIdList.indexOf(fileId) + 1;
                if ("doc".equals(repoFileVO.getSource())) {
                    fileName = repoFileVO.getName();
                    String previewPath = FilePreviewService.getPreviewUrl(repoFileVO.getPath());
                    item = new ContextData.Item(AttType.document, fileName, previewPath, order);
                } else if ("code".equals(repoFileVO.getSource())) {
                    fileName = repoFileVO.getName();
                    String previewPath = FilePreviewService.getPreviewUrl(repoFileVO.getPath());
                    item = new ContextData.Item(AttType.code, fileName, previewPath, order);
                } else {
                    String url = repoFileVO.getUrl();
                    boolean isNextCloud = url.startsWith("{domainContextUrl}");
                    if (isNextCloud) {
                        String domainContextUrl = UrlService.getDomainContextUrl();
                        url = url.replaceFirst("\\{domainContextUrl\\}", domainContextUrl);
                    }
                    item = new ContextData.Item(AttType.knowledge, repoFileVO.getTitle(), url, order);
                }
                if (item == null) continue;
                RepoDocAnnotation repoDocAnnotation = new RepoDocAnnotation();
                repoDocAnnotation.setGaitag(GaiTagEnum.gairepodoc.name());
                repoDocAnnotation.setName(item.getName());
                repoDocAnnotation.setOrder(item.getOrder());
                repoDocAnnotation.setType(item.getType().name());
                repoDocAnnotation.setContent(item.getContent());
                repoDocAnnotation.setId(String.valueOf(fileId));
                annotations.add(repoDocAnnotation);
            }
        }
    }

    private static void parseIframe(List<BaseAnnotation> annotations, String tagContent) {
        IframeAnnotation iFrameAnnotation = new IframeAnnotation();
        iFrameAnnotation.setGaitag(GaiTagEnum.gaiiframe.name());
        iFrameAnnotation.setUrl(tagContent);
        annotations.add(iFrameAnnotation);
    }

    private static void parseImgUrl(List<BaseAnnotation> annotations, String tagContent) {
        ImgUrlAnnotation imgUrlAnnotation = new ImgUrlAnnotation();
        imgUrlAnnotation.setGaitag(GaiTagEnum.gaiimgurl.name());
        imgUrlAnnotation.setUrl(tagContent);
        annotations.add(imgUrlAnnotation);
    }

    private static void parseUrl(List<BaseAnnotation> annotations, String tagContent) {
        String urlRegex = "(?:<urlname>(.*?)</urlname>)?<urlhref>(.*?)</urlhref>";
        Pattern urlPattern = Pattern.compile(urlRegex);
        Matcher urlMatcher = urlPattern.matcher(tagContent);
        if (urlMatcher.find()) {
            String urlname = urlMatcher.group(1);
            String urlhref = urlMatcher.group(2);
            UrlAnnotation urlAnnotation = new UrlAnnotation();
            urlAnnotation.setGaitag(GaiTagEnum.gaiurl.name());
            urlAnnotation.setUrlname(urlname);
            urlAnnotation.setUrlhref(urlhref);
            annotations.add(urlAnnotation);
        }
    }

    private static void parseForm(List<BaseAnnotation> annotations, String tagContent) {
        String urlRegex = "<formid>(.*?)</formid>.*?<formname>(.*?)</formname>.*?<billformid>(.*?)</billformid>.*?<filters>(.*?)</filters>";
        Pattern urlPattern = Pattern.compile(urlRegex);
        Matcher urlMatcher = urlPattern.matcher(tagContent);
        if (urlMatcher.find()) {
            String formId = urlMatcher.group(1);
            String formName = urlMatcher.group(2);
            String billFormId = urlMatcher.group(3);
            String filters = urlMatcher.group(4);
            FormAnnotation formAnnotation = new FormAnnotation();
            formAnnotation.setGaitag(GaiTagEnum.gaiform.name());
            formAnnotation.setFormId(formId);
            formAnnotation.setFormName(formName);
            formAnnotation.setBillFormId(billFormId);
            formAnnotation.setFilters(filters);
            annotations.add(formAnnotation);
        }
    }

    private static void parseFile(List<BaseAnnotation> annotations, List<Long> fileIdList) {
        List<FileInfo> fileInfoLIst;
        if (CollectionUtils.isNotEmpty(fileIdList) && CollectionUtils.isNotEmpty(fileInfoLIst = FileService.queryFileList(fileIdList))) {
            for (FileInfo fileInfo : fileInfoLIst) {
                FileAnnotation fileAnnotation = new FileAnnotation();
                fileAnnotation.setGaitag(GaiTagEnum.gaifile.name());
                fileAnnotation.setFileType(fileInfo.getFileType());
                fileAnnotation.setFileSize(fileInfo.getFileSize());
                fileAnnotation.setFileUrl(fileInfo.getFileUrl());
                fileAnnotation.setPreviewUrl(fileInfo.getPreviewUrl());
                fileAnnotation.setName(fileInfo.getName());
                fileAnnotation.setNumber(fileInfo.getNumber());
                fileAnnotation.setId(StrUtils.longAsString(fileInfo.getId()));
                annotations.add(fileAnnotation);
            }
        }
    }

    private static void parseImg(List<BaseAnnotation> annotations, List<Long> fileIdList) {
        List<FileInfo> fileInfoLIst;
        if (CollectionUtils.isNotEmpty(fileIdList) && CollectionUtils.isNotEmpty(fileInfoLIst = FileService.queryFileList(fileIdList))) {
            for (FileInfo fileInfo : fileInfoLIst) {
                ImgAnnotation imgAnnotation = new ImgAnnotation();
                imgAnnotation.setGaitag(GaiTagEnum.gaiimg.name());
                imgAnnotation.setFileType(fileInfo.getFileType());
                imgAnnotation.setFileSize(fileInfo.getFileSize());
                imgAnnotation.setFileUrl(fileInfo.getFileUrl());
                imgAnnotation.setPreviewUrl(fileInfo.getPreviewUrl());
                imgAnnotation.setName(fileInfo.getName());
                imgAnnotation.setNumber(fileInfo.getNumber());
                imgAnnotation.setId(StrUtils.longAsString(fileInfo.getId()));
                annotations.add(imgAnnotation);
            }
        }
    }

    public static void showFormByAnnotation(IFormView formView, FormAnnotation formAnnotation) {
        String formId = formAnnotation.getFormId();
        if (StringUtils.equalsIgnoreCase((CharSequence)formId, (CharSequence)"bos_list")) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId(formAnnotation.getBillFormId());
            lsp.setFormId(formAnnotation.getFormId());
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("700px");
            inlineStyleCss.setWidth("1200px");
            lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            lsp.setLookUp(true);
            ListFilterParameter lfp = new ListFilterParameter();
            QFilter qFilter = null;
            try {
                qFilter = EntityUtils.transFilterJson2QFilter(formAnnotation.getBillFormId(), formAnnotation.getFilters());
            }
            catch (Exception e) {
                log.error("\u8fc7\u6ee4\u6761\u4ef6\u8f6c\u6362\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                throw new KDBizException("\u8fc7\u6ee4\u6761\u4ef6\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            }
            lfp.setFilter(qFilter);
            lsp.setListFilterParameter(lfp);
            formView.showForm((FormShowParameter)lsp);
        }
    }
}

