/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.domain.dto.agent.AgentTool;
import kd.ai.gai.core.domain.dto.agent.CosmicAction;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.service.agent.AgentToolService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class CosmicActionService {
    private static final Log logger = LogFactory.getLog(CosmicActionService.class);

    public static BaseResult call(CosmicAction cosmicAction) {
        HashMap<String, String> varMaps;
        logger.info("\u6267\u884c\u8c03\u7528\u82cd\u7a79Action\u5de5\u5177\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)cosmicAction));
        Long toolId = cosmicAction.getToolId();
        if (toolId == null) {
            return BaseResult.fail("toolId\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AgentTool tool = AgentToolService.getAgentTool(toolId);
        if (tool == null) {
            return BaseResult.fail("\u5de5\u5177\u4e0d\u5b58\u5728");
        }
        JSONObject toolParams = cosmicAction.getToolParams();
        if (toolParams == null) {
            return BaseResult.fail("toolParams\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String chatSessionId = cosmicAction.getChatSessionId();
        logger.info("chatSessionId:{}", (Object)chatSessionId);
        if (!StringUtils.isEmpty((CharSequence)chatSessionId)) {
            FlowCacheData.restoreRequestContext(chatSessionId);
        }
        JSONObject actionConfig = tool.getConfigTag();
        String action = actionConfig.getString("action");
        JSONArray inputParams = toolParams.getJSONArray("inputParams");
        Object[] bizParams = new Object[2];
        bizParams[0] = action;
        if (inputParams != null && !inputParams.isEmpty()) {
            varMaps = new HashMap(inputParams.size());
            for (int i = 0; i < inputParams.size(); ++i) {
                JSONObject param = inputParams.getJSONObject(i);
                String paramName = param.getString("paramName");
                String paramValue = param.getString("paramValue");
                varMaps.put(paramName, paramValue);
            }
            CosmicActionService.buildChatSessionIdVar(varMaps, chatSessionId);
            logger.info("build varMaps : {}", (Object)JSONObject.toJSONString(varMaps));
            bizParams[1] = varMaps;
        } else {
            varMaps = new HashMap<String, String>(1);
            CosmicActionService.buildChatSessionIdVar(varMaps, chatSessionId);
            logger.info("build varMaps : {}", (Object)JSONObject.toJSONString(varMaps));
            bizParams[1] = varMaps;
        }
        String className = actionConfig.getString("serviceName");
        String appId = actionConfig.getString("appId");
        Object ret = DispatchServiceHelper.invokeBOSService((String)appId, (String)"IGPTService", (String)"invokeGptAction", (Object[])new Object[]{className, "invokeAction", bizParams});
        if (ret instanceof Map) {
            Map data = (Map)ret;
            logger.info("call cosmic action result : {}", ret);
            JSONObject output = new JSONObject();
            output.put("output", (Object)JSONObject.toJSONString((Object)data));
            return new BaseResult(output);
        }
        logger.error("{} : {} \u8c03\u7528\u8fd4\u56de\u7c7b\u578b\u4e0d\u662fMap<String,String>, \u8fd4\u56de\u503c: {} ", new Object[]{appId, className, ret});
        JSONObject output = new JSONObject();
        output.put("output", (Object)"");
        return new BaseResult(output);
    }

    private static void buildChatSessionIdVar(Map<String, String> varMaps, String chatSessionId) {
        JSONObject gaiParams = new JSONObject();
        gaiParams.put("chatSessionId", (Object)chatSessionId);
        if (StringUtils.isEmpty((CharSequence)chatSessionId)) {
            logger.error("chatSessionId is null,can't get PAGE_ID and ROOT_PAGE_ID from context");
        } else {
            Context context = FlowCacheData.getContext(chatSessionId);
            if (context != null) {
                gaiParams.put("PAGE_ID", (Object)context.getBizPageId());
                gaiParams.put("ROOT_PAGE_ID", (Object)context.getRootPageId());
            }
        }
        varMaps.put("gaiParams", JSONObject.toJSONString((Object)gaiParams, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }
}

